/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.logging.Logger;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.logging.Logging;

final class RasterQueryInfo {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");
    private GeneralEnvelope requestedEnvelope;
    private Rectangle requestedDim;
    private int pyramidLevel;
    private Rectangle matchingTiles;
    private GeneralEnvelope resultEnvelope;
    private Rectangle resultDimension;
    private Long rasterId;
    private Rectangle mosaicLocation;
    private RenderedImage resultImage;
    private Rectangle tiledImageSize;
    private double[] resolution;
    private int rasterIndex;
    private Rectangle levelTileRange;

    public RasterQueryInfo() {
        this.setResultDimensionInsideTiledImage(new Rectangle(0, 0, 0, 0));
        this.setMatchingTiles(new Rectangle(0, 0, 0, 0));
        this.setResultEnvelope(null);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("[Raster query info:");
        s.append("\n\tRaster ID            : ").append(this.getRasterId());
        s.append("\n\tPyramid level        : ").append(this.getPyramidLevel());
        s.append("\n\tResolution           : ").append(this.getResolution()[0] + "," + this.getResolution()[1]);
        s.append("\n\tRequested envelope   : ").append(this.getRequestedEnvelope());
        s.append("\n\tRequested dimension  : ").append(this.getRequestedDim());
        Rectangle mt = this.getMatchingTiles();
        Rectangle ltr = this.getLevelTileRange();
        String matching = "x=" + mt.x + "-" + (mt.width - 1) + ", y=" + mt.y + "-" + (mt.height - 1);
        String level = "x=" + ltr.x + "-" + (ltr.width - 1) + ", y=" + ltr.y + "-" + (ltr.height - 1);
        s.append("\n\tMatching tiles       : ").append(matching).append(" out of ").append(level);
        s.append("\n\tTiled image size     : ").append(this.getTiledImageSize());
        s.append("\n\tResult dimension     : ").append(this.getResultDimensionInsideTiledImage());
        s.append("\n\tMosaiced dimension   : ").append(this.getMosaicLocation());
        s.append("\n\tResult envelope      : ").append(this.getResultEnvelope());
        s.append("\n]");
        return s.toString();
    }

    public Long getRasterId() {
        return this.rasterId;
    }

    public GeneralEnvelope getRequestedEnvelope() {
        return this.requestedEnvelope;
    }

    public Rectangle getRequestedDim() {
        return this.requestedDim;
    }

    public int getPyramidLevel() {
        return this.pyramidLevel;
    }

    public Rectangle getMatchingTiles() {
        return this.matchingTiles;
    }

    public GeneralEnvelope getResultEnvelope() {
        return this.resultEnvelope;
    }

    public Rectangle getResultDimensionInsideTiledImage() {
        return this.resultDimension;
    }

    void setRasterId(Long rasterId) {
        this.rasterId = rasterId;
    }

    void setPyramidLevel(int pyramidLevel) {
        this.pyramidLevel = pyramidLevel;
    }

    void setRequestedEnvelope(GeneralEnvelope requestedEnvelope) {
        this.requestedEnvelope = requestedEnvelope;
    }

    void setRequestedDim(Rectangle requestedDim) {
        this.requestedDim = requestedDim;
    }

    void setResultEnvelope(GeneralEnvelope resultEnvelope) {
        this.resultEnvelope = resultEnvelope;
    }

    void setMatchingTiles(Rectangle matchingTiles) {
        this.matchingTiles = matchingTiles;
    }

    void setResultDimensionInsideTiledImage(Rectangle resultDimension) {
        this.resultDimension = resultDimension;
    }

    void setMosaicLocation(Rectangle rasterMosaicLocation) {
        this.mosaicLocation = rasterMosaicLocation;
    }

    public Rectangle getMosaicLocation() {
        return this.mosaicLocation;
    }

    public void setResultImage(RenderedImage rasterImage) {
        this.resultImage = rasterImage;
        if (rasterImage.getWidth() != this.tiledImageSize.width || rasterImage.getHeight() != this.tiledImageSize.height) {
            LOGGER.warning("Result image and expected dimensions don't match: image=" + this.resultImage.getWidth() + "x" + this.resultImage.getHeight() + ", expected=" + this.tiledImageSize.width + "x" + this.tiledImageSize.height);
        }
    }

    public RenderedImage getResultImage() {
        return this.resultImage;
    }

    void setTiledImageSize(Rectangle tiledImageSize) {
        this.tiledImageSize = tiledImageSize;
    }

    public Rectangle getTiledImageSize() {
        return this.tiledImageSize;
    }

    void setResolution(double[] resolution) {
        this.resolution = resolution;
    }

    public double[] getResolution() {
        double[] dArray;
        if (this.resolution == null) {
            double[] dArray2 = new double[2];
            dArray2[0] = -1.0;
            dArray = dArray2;
            dArray2[1] = -1.0;
        } else {
            dArray = this.resolution;
        }
        return dArray;
    }

    void setRasterIndex(int rasterN) {
        this.rasterIndex = rasterN;
    }

    public int getRasterIndex() {
        return this.rasterIndex;
    }

    void setLevelTileRange(Rectangle levelTileRange) {
        this.levelTileRange = levelTileRange;
    }

    public Rectangle getLevelTileRange() {
        return this.levelTileRange;
    }
}

