/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeQueryInfo;
import com.esri.sde.sdk.client.SeTable;
import com.esri.sde.sdk.client.SeVersion;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequenceFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.data.ArcSDEAdapter;
import org.geotools.arcsde.data.ArcSDEAttributeReader;
import org.geotools.arcsde.data.ArcSDEFeatureReader;
import org.geotools.arcsde.data.ArcSDEQuery;
import org.geotools.arcsde.data.ArcSdeFeatureSource;
import org.geotools.arcsde.data.ArcSdeFeatureStore;
import org.geotools.arcsde.data.ArcSdeFeatureWriter;
import org.geotools.arcsde.data.ArcTransactionState;
import org.geotools.arcsde.data.AutoCommitFeatureWriter;
import org.geotools.arcsde.data.FIDReader;
import org.geotools.arcsde.data.FeatureTypeInfo;
import org.geotools.arcsde.data.FeatureTypeInfoCache;
import org.geotools.arcsde.data.SessionTransactionState;
import org.geotools.arcsde.data.TransactionFeatureWriter;
import org.geotools.arcsde.data.versioning.ArcSdeVersionHandler;
import org.geotools.arcsde.data.versioning.AutoCommitVersionHandler;
import org.geotools.arcsde.data.view.QueryInfoParser;
import org.geotools.arcsde.data.view.SelectQualifier;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.arcsde.session.SessionWrapper;
import org.geotools.arcsde.session.UnavailableConnectionException;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.LockingManager;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.view.DefaultView;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcSDEDataStore
implements DataStore {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.data");
    private static final int DEFAULT_LAYER_NAMES_CACHE_UPDATE_FREQ_SECS = 60;
    final FeatureListenerManager listenerManager = new FeatureListenerManager();
    final ISessionPool connectionPool;
    final FeatureTypeInfoCache typeInfoCache;
    private String version;

    public ArcSDEDataStore(ISessionPool connPool) throws IOException {
        this(connPool, null, null, false);
    }

    public ArcSDEDataStore(ISessionPool connPool, String namespaceUri, String versionName, boolean allowNonSpatialTables) throws IOException {
        this.connectionPool = connPool;
        this.version = versionName == null ? SeVersion.SE_QUALIFIED_DEFAULT_VERSION_NAME : versionName;
        this.typeInfoCache = new FeatureTypeInfoCache(this.connectionPool, namespaceUri, 60, allowNonSpatialTables);
    }

    public ISession getSession(Transaction transaction) throws IOException {
        ISession session;
        if (transaction == null) {
            throw new NullPointerException("transaction can't be null. Did you mean Transaction.AUTO_COMMIT?");
        }
        if (Transaction.AUTO_COMMIT.equals(transaction)) {
            try {
                session = this.connectionPool.getSession(false);
            }
            catch (UnavailableConnectionException e) {
                throw new RuntimeException("Session pool exhausted", e);
            }
        } else {
            SessionTransactionState state = SessionTransactionState.getState(transaction, this.connectionPool);
            session = state.getConnection();
        }
        return session;
    }

    private ArcTransactionState getState(Transaction transaction) {
        if (Transaction.AUTO_COMMIT.equals(transaction)) {
            return null;
        }
        ArcTransactionState state = (ArcTransactionState)transaction.getState((Object)this);
        if (state == null) {
            state = new ArcTransactionState(this, this.listenerManager);
            transaction.putState((Object)this, (Transaction.State)state);
        }
        return state;
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        HashMap<String, String> hints = new HashMap<String, String>();
        hints.put("rowid.column.type", "SDE");
        String rowIdName = "SDE_ROW_ID";
        while (featureType.getDescriptor(rowIdName) != null) {
            rowIdName = rowIdName + "2";
        }
        hints.put("rowid.column.name", rowIdName);
        this.createSchema(featureType, hints);
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        FeatureTypeInfo typeInfo = this.typeInfoCache.getFeatureTypeInfo(typeName);
        SimpleFeatureType schema = typeInfo.getFeatureType();
        return schema;
    }

    public String[] getTypeNames() throws IOException {
        List<String> layerNames = this.typeInfoCache.getTypeNames();
        return layerNames.toArray(new String[layerNames.size()]);
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setTitle("ArcSDE connection to " + this.connectionPool.getConfig().getServerName() + " using database version '" + this.version + "'");
        info.setDescription("GeoTools ArcSDE DataStore plugin");
        try {
            info.setSchema(this.typeInfoCache.getNamesapceURI() == null ? FeatureTypes.DEFAULT_NAMESPACE : new URI(this.typeInfoCache.getNamesapceURI()));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return info;
    }

    public void dispose() {
        LOGGER.fine("Disposing " + this.connectionPool);
        this.typeInfoCache.dispose();
        if (!this.connectionPool.isClosed()) {
            this.connectionPool.close();
        }
        LOGGER.fine("Session pool disposed");
    }

    protected void finalize() {
        this.dispose();
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        assert (query != null);
        assert (query.getTypeName() != null);
        assert (query.getFilter() != null);
        assert (transaction != null);
        SimpleFeatureType featureType = this.getQueryType(query);
        return this.getFeatureReader(query, transaction, featureType);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction, SimpleFeatureType featureType) throws IOException {
        FeatureReader<SimpleFeatureType, SimpleFeature> reader;
        Filter filter = query.getFilter();
        if (filter == Filter.EXCLUDE || filter.equals(Filter.EXCLUDE)) {
            return new EmptyFeatureReader((FeatureType)featureType);
        }
        String typeName = query.getTypeName();
        ArcSdeVersionHandler versionHandler = this.getVersionHandler(typeName, transaction);
        ISession session = this.getSession(transaction);
        try {
            reader = this.getFeatureReader(query, featureType, session, versionHandler);
        }
        catch (IOException ioe) {
            session.dispose();
            throw ioe;
        }
        catch (RuntimeException re) {
            session.dispose();
            throw re;
        }
        return reader;
    }

    private FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, SimpleFeatureType targetSchema, ISession session, ArcSdeVersionHandler versionHandler) throws IOException {
        ArcSDEFeatureReader reader;
        ArcSDEQuery sdeQuery;
        String typeName = query.getTypeName();
        FeatureTypeInfo typeInfo = this.typeInfoCache.getFeatureTypeInfo(typeName, session);
        SimpleFeatureType completeSchema = typeInfo.getFeatureType();
        Filter filter = query.getFilter();
        if (filter == Filter.EXCLUDE || filter.equals(Filter.EXCLUDE)) {
            return new EmptyFeatureReader((FeatureType)targetSchema);
        }
        if (typeInfo.isInProcessView()) {
            SeQueryInfo definitionQuery = typeInfo.getSdeDefinitionQuery();
            PlainSelect viewSelectStatement = typeInfo.getDefinitionQuery();
            sdeQuery = ArcSDEQuery.createInprocessViewQuery(session, completeSchema, query, definitionQuery, viewSelectStatement);
        } else {
            FIDReader fidStrategy = typeInfo.getFidStrategy();
            sdeQuery = ArcSDEQuery.createQuery(session, completeSchema, query, fidStrategy, versionHandler);
        }
        GeometryFactory geometryFactory = this.getGeometryFactory(query.getHints());
        ArcSDEAttributeReader attReader = new ArcSDEAttributeReader(sdeQuery, geometryFactory, session);
        try {
            reader = new ArcSDEFeatureReader(attReader);
        }
        catch (SchemaException e) {
            throw new RuntimeException("Schema missmatch, should never happen!: " + e.getMessage(), e);
        }
        filter = this.getUnsupportedFilter(typeInfo, filter, session);
        if (!filter.equals(Filter.INCLUDE)) {
            reader = new FilteringFeatureReader((FeatureReader)reader, filter);
        }
        if (!targetSchema.equals(reader.getFeatureType())) {
            LOGGER.fine("Recasting feature type to subtype by using a ReTypeFeatureReader");
            reader = new ReTypeFeatureReader((FeatureReader)reader, targetSchema, false);
        }
        if (query.getMaxFeatures() != Integer.MAX_VALUE) {
            reader = new MaxFeatureReader((FeatureReader)reader, query.getMaxFeatures());
        }
        return reader;
    }

    private GeometryFactory getGeometryFactory(Hints queryHints) {
        Hints hints = queryHints == null ? GeoTools.getDefaultHints() : queryHints;
        GeometryFactory gf = (GeometryFactory)hints.get((Object)Hints.JTS_GEOMETRY_FACTORY);
        if (gf == null) {
            Integer SRID;
            PrecisionModel pm = (PrecisionModel)hints.get((Object)Hints.JTS_PRECISION_MODEL);
            if (pm == null) {
                pm = new PrecisionModel();
            }
            int srid = (SRID = (Integer)hints.get((Object)Hints.JTS_SRID)) == null ? 0 : SRID;
            Integer dimension = (Integer)hints.get((Object)Hints.COORDINATE_DIMENSION);
            Object csFactory = (CoordinateSequenceFactory)hints.get((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
            if (csFactory == null) {
                csFactory = dimension == null || dimension <= 3 ? CoordinateArraySequenceFactory.instance() : new LiteCoordinateSequenceFactory();
            }
            gf = new GeometryFactory(pm, srid, csFactory);
        }
        return gf;
    }

    public SimpleFeatureType getQueryType(Query query) throws IOException {
        SimpleFeatureType completeSchema;
        String typeName = query.getTypeName();
        String[] propertyNames = query.getPropertyNames();
        FeatureTypeInfo typeInfo = this.typeInfoCache.getFeatureTypeInfo(typeName);
        SimpleFeatureType featureType = completeSchema = typeInfo.getFeatureType();
        if (!query.retrieveAllProperties() || query.getCoordinateSystem() != null) {
            try {
                featureType = DataUtilities.createSubType((SimpleFeatureType)featureType, (String[])propertyNames, (CoordinateReferenceSystem)query.getCoordinateSystem());
            }
            catch (SchemaException e) {
                LOGGER.log(Level.FINEST, e.getMessage(), e);
                throw new DataSourceException("Could not create Feature Type for query", (Throwable)e);
            }
        }
        return featureType;
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(String typeName) throws IOException {
        FeatureTypeInfo typeInfo = this.typeInfoCache.getFeatureTypeInfo(typeName);
        ArcSdeFeatureSource fsource = typeInfo.isWritable() ? new ArcSdeFeatureStore(typeInfo, this) : new ArcSdeFeatureSource(typeInfo, this);
        return fsource;
    }

    public ArcSdeFeatureWriter getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, transaction);
    }

    ArcSdeVersionHandler getVersionHandler(String typeName, Transaction transaction) throws IOException {
        ArcSdeVersionHandler versionHandler = ArcSdeVersionHandler.NONVERSIONED_HANDLER;
        FeatureTypeInfo featureTypeInfo = this.typeInfoCache.getFeatureTypeInfo(typeName);
        boolean versioned = featureTypeInfo.isVersioned();
        ArcTransactionState state = this.getState(transaction);
        if (null == state) {
            if (versioned) {
                versionHandler = new AutoCommitVersionHandler(this.version);
            }
        } else {
            versionHandler = state.getVersionHandler(versioned, this.version);
        }
        return versionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArcSdeFeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        ArcSdeVersionHandler versionHandler = this.getVersionHandler(typeName, transaction);
        ISession session = this.getSession(transaction);
        try {
            FeatureReader<SimpleFeatureType, SimpleFeature> reader;
            FeatureTypeInfo typeInfo = this.typeInfoCache.getFeatureTypeInfo(typeName, session);
            if (!typeInfo.isWritable()) {
                throw new DataSourceException(typeName + " is not writable");
            }
            SimpleFeatureType featureType = typeInfo.getFeatureType();
            if (Filter.EXCLUDE.equals(filter)) {
                reader = new FeatureReader<SimpleFeatureType, SimpleFeature>((FeatureType)featureType);
            } else {
                DefaultQuery query = new DefaultQuery(typeName, filter);
                SessionWrapper nonDisposableSession = new SessionWrapper(session){

                    public void dispose() throws IllegalStateException {
                    }
                };
                reader = this.getFeatureReader((Query)query, featureType, (ISession)nonDisposableSession, versionHandler);
            }
            FIDReader fidReader = typeInfo.getFidStrategy();
            ArcTransactionState state = this.getState(transaction);
            ArcSdeFeatureWriter writer = Transaction.AUTO_COMMIT == transaction ? new AutoCommitFeatureWriter(fidReader, featureType, reader, session, this.listenerManager, versionHandler) : new TransactionFeatureWriter(fidReader, featureType, reader, state, versionHandler, this.listenerManager);
            return writer;
        }
        catch (IOException e) {
            try {
                session.rollbackTransaction();
            }
            finally {
                session.dispose();
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                session.rollbackTransaction();
            }
            catch (IOException e1) {
                LOGGER.log(Level.SEVERE, "Error rolling back transaction on " + session, e);
            }
            finally {
                session.dispose();
            }
            throw e;
        }
    }

    public ArcSdeFeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        return this.getFeatureWriter(typeName, (Filter)Filter.EXCLUDE, transaction);
    }

    public LockingManager getLockingManager() {
        return null;
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getView(Query query) throws IOException, SchemaException {
        return new DefaultView(this.getFeatureSource(query.getTypeName()), query);
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Schema modification not supported");
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(Name typeName) throws IOException {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    public List<Name> getNames() throws IOException {
        return this.typeInfoCache.getNames();
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }

    private Filter getUnsupportedFilter(FeatureTypeInfo typeInfo, Filter filter, ISession session) {
        try {
            SeTable table;
            SeQueryInfo qInfo;
            if (typeInfo.isInProcessView()) {
                String mainLayerName;
                qInfo = typeInfo.getSdeDefinitionQuery();
                try {
                    mainLayerName = qInfo.getConstruct().getTables()[0];
                }
                catch (SeException e) {
                    throw new ArcSdeException(e);
                }
                table = session.getTable(mainLayerName);
            } else {
                table = session.getTable(typeInfo.getFeatureTypeName());
                qInfo = null;
            }
            FIDReader fidReader = typeInfo.getFidStrategy();
            SimpleFeatureType schema = typeInfo.getFeatureType();
            PlainSelect viewSelectStatement = typeInfo.getDefinitionQuery();
            SeLayer layer = null;
            if (schema.getGeometryDescriptor() != null) {
                layer = session.getLayer(table.getQualifiedName());
            }
            ArcSDEQuery.FilterSet filters = ArcSDEQuery.createFilters(table, layer, schema, filter, qInfo, viewSelectStatement, fidReader);
            Filter result = filters.getUnsupportedFilter();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Supported filters: " + filters.getSqlFilter() + " --- " + filters.getGeometryFilter());
                LOGGER.fine("Unsupported filter: " + result.toString());
            }
            return result;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            return filter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(SimpleFeatureType featureType, Map<String, String> hints) throws IOException, IllegalArgumentException {
        if (featureType.getGeometryDescriptor() == null && !this.typeInfoCache.isAllowNonSpatialTables()) {
            throw new DataSourceException("This DataStore does not allow FeatureTypes with no geometry attributes");
        }
        ISession session = this.getSession(Transaction.AUTO_COMMIT);
        try {
            ArcSDEAdapter.createSchema(featureType, hints, session);
        }
        finally {
            session.dispose();
        }
        this.typeInfoCache.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerView(String typeName, PlainSelect select) throws IOException {
        if (typeName == null) {
            throw new NullPointerException("typeName");
        }
        if (select == null) {
            throw new NullPointerException("select");
        }
        if (Arrays.asList(this.getTypeNames()).contains(typeName)) {
            throw new IllegalArgumentException(typeName + " already exists as a FeatureType");
        }
        this.verifyQueryIsSupported(select);
        ISession session = this.getSession(Transaction.AUTO_COMMIT);
        try {
            SeQueryInfo queryInfo;
            PlainSelect qualifiedSelect = SelectQualifier.qualify(session, select);
            try {
                LOGGER.fine("creating definition query info");
                queryInfo = QueryInfoParser.parse(session, qualifiedSelect);
            }
            catch (SeException e) {
                throw new ArcSdeException("Error Parsing select: " + qualifiedSelect, e);
            }
            FeatureTypeInfo typeInfo = ArcSDEAdapter.createInprocessViewSchema(session, typeName, this.typeInfoCache.getNamesapceURI(), qualifiedSelect, queryInfo);
            this.typeInfoCache.addInprocessViewInfo(typeInfo);
        }
        finally {
            session.dispose();
        }
    }

    private void verifyQueryIsSupported(PlainSelect select) throws UnsupportedOperationException {
        LinkedList<Object> errors = new LinkedList<Object>();
        this.verifyUnsupportedSqlConstruct(errors, select.getGroupByColumnReferences());
        this.verifyUnsupportedSqlConstruct(errors, select.getInto());
        this.verifyUnsupportedSqlConstruct(errors, select.getJoins());
        this.verifyUnsupportedSqlConstruct(errors, select.getLimit());
        if (errors.size() > 0) {
            throw new UnsupportedOperationException("The following constructs are not supported: " + errors);
        }
    }

    private void verifyUnsupportedSqlConstruct(List<Object> errors, Object construct) {
        if (construct instanceof List) {
            List constructsList = (List)construct;
            if (constructsList.size() > 0) {
                errors.addAll(constructsList);
            }
        } else if (construct != null) {
            errors.add(construct);
        }
    }
}

