/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.info;

import com.esri.sde.sdk.client.SDEPoint;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeRasterAttr;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.geotools.arcsde.raster.info.PyramidLevelInfo;
import org.geotools.arcsde.raster.info.RasterBandInfo;
import org.geotools.arcsde.raster.info.RasterCellType;
import org.geotools.arcsde.raster.info.RasterUtils;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RasterInfo {
    private static final Comparator<PyramidLevelInfo> levelComparator = new Comparator<PyramidLevelInfo>(){

        @Override
        public int compare(PyramidLevelInfo p0, PyramidLevelInfo p1) {
            return p0.getLevel() - p1.getLevel();
        }
    };
    ArrayList<PyramidLevelInfo> pyramidList;
    private int tileWidth;
    private int tileHeight;
    private GeneralEnvelope originalEnvelope;
    private ArrayList<RasterBandInfo> bands;
    private CoordinateReferenceSystem crs;
    private Long rasterId;

    RasterInfo(SeRasterAttr rasterAttributes, CoordinateReferenceSystem crs) throws DataSourceException {
        this.crs = crs;
        try {
            this.rasterId = rasterAttributes.getRasterId().longValue();
            int numLevels = rasterAttributes.getMaxLevel() + 1;
            this.pyramidList = new ArrayList(numLevels);
            this.tileWidth = rasterAttributes.getTileWidth();
            this.tileHeight = rasterAttributes.getTileHeight();
            for (int level = 0; level < numLevels; ++level) {
                if (level == 1 && rasterAttributes.skipLevelOne()) continue;
                SeExtent slExtent = rasterAttributes.getExtentByLevel(level);
                int levelWidth = rasterAttributes.getImageWidthByLevel(level);
                int levelHeight = rasterAttributes.getImageHeightByLevel(level);
                Dimension levelImageSize = new Dimension(levelWidth, levelHeight);
                Point imgOffset = new Point();
                Point2D.Double extOffset = new Point2D.Double();
                SDEPoint imageOffset = rasterAttributes.getImageOffsetByLevel(level);
                int xOffset = (int)(imageOffset == null ? 0.0 : imageOffset.getX());
                int yOffset = (int)(imageOffset == null ? 0.0 : imageOffset.getY());
                imgOffset.setLocation(xOffset, yOffset);
                SDEPoint extentOffset = rasterAttributes.getExtentOffsetByLevel(level);
                double xOffsetExtent = extentOffset == null ? 0.0 : extentOffset.getX();
                double yOffsetExtent = extentOffset == null ? 0.0 : extentOffset.getY();
                ((Point2D)extOffset).setLocation(xOffsetExtent, yOffsetExtent);
                int numTilesWide = rasterAttributes.getTilesPerRowByLevel(level);
                int numTileHigh = rasterAttributes.getTilesPerColByLevel(level);
                ReferencedEnvelope levelExtent = new ReferencedEnvelope(slExtent.getMinX(), slExtent.getMaxX(), slExtent.getMinY(), slExtent.getMaxY(), crs);
                this.addPyramidLevel(level, levelExtent, imgOffset, extOffset, numTilesWide, numTileHigh, levelImageSize);
            }
        }
        catch (SeException se) {
            throw new DataSourceException((Throwable)se);
        }
    }

    public Long getRasterId() {
        return this.rasterId;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public RasterInfo(Long rasterId, int tileWidth, int tileHeight) {
        this.rasterId = rasterId;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.pyramidList = new ArrayList(4);
    }

    public Dimension getTileDimension() {
        return new Dimension(this.tileWidth, this.tileHeight);
    }

    public PyramidLevelInfo getPyramidLevel(int level) {
        return this.pyramidList.get(level);
    }

    public int getNumLevels() {
        return this.pyramidList.size();
    }

    double[] getResolution(int pyramidLevel) {
        double highestRes = this.getPyramidLevel(0).getXRes();
        PyramidLevelInfo level = this.getPyramidLevel(pyramidLevel);
        double[] resolution = new double[]{level.getXRes(), level.getYRes(), level.getXRes() / highestRes};
        return resolution;
    }

    public int getOptimalPyramidLevel(OverviewPolicy policy, double[] requestedRes) {
        double reqy;
        double requestedScaleFactorY;
        int pyramidLevelChoice = 0;
        double reqx = requestedRes[0];
        double[] highestRes = this.getResolution(0);
        double requestedScaleFactorX = reqx / highestRes[0];
        boolean leastReduceAxis = !(requestedScaleFactorX <= (requestedScaleFactorY = (reqy = requestedRes[1]) / highestRes[1]));
        double requestedScaleFactor = !leastReduceAxis ? requestedScaleFactorX : requestedScaleFactorY;
        int numLevels = this.getNumLevels();
        if (0 == numLevels || requestedScaleFactor <= 1.0) {
            pyramidLevelChoice = 0;
        } else {
            double[] min = this.getResolution(numLevels - 1);
            if (requestedScaleFactor >= min[2]) {
                pyramidLevelChoice = numLevels - 1;
            } else {
                double[] prev = highestRes;
                for (int levelN = 1; levelN < numLevels; ++levelN) {
                    double[] curr = this.getResolution(levelN);
                    if (curr[2] == requestedScaleFactor) {
                        pyramidLevelChoice = levelN;
                        continue;
                    }
                    if (curr[2] > requestedScaleFactor || levelN == numLevels - 1) {
                        if (policy == OverviewPolicy.QUALITY) {
                            pyramidLevelChoice = levelN - 1;
                            break;
                        }
                        if (policy == OverviewPolicy.SPEED) {
                            return levelN;
                        }
                        if (requestedScaleFactor - prev[2] < curr[2] - requestedScaleFactor) {
                            pyramidLevelChoice = levelN - 1;
                            break;
                        }
                        pyramidLevelChoice = levelN;
                        break;
                    }
                    prev = curr;
                }
            }
        }
        return pyramidLevelChoice;
    }

    public void addPyramidLevel(int level, ReferencedEnvelope extent, Point imgOffset, Point2D extOffset, int numTilesWide, int numTilesHigh, Dimension imageSize) {
        PyramidLevelInfo pyramidLevel = new PyramidLevelInfo(level, extent, imgOffset, extOffset, numTilesWide, numTilesHigh, imageSize);
        this.pyramidList.add(pyramidLevel);
        Collections.sort(this.pyramidList, levelComparator);
    }

    void setOriginalEnvelope(GeneralEnvelope originalEnvelope) {
        this.originalEnvelope = originalEnvelope;
    }

    public GeneralEnvelope getOriginalEnvelope() {
        return this.originalEnvelope;
    }

    public void setBands(List<RasterBandInfo> bands) {
        this.bands = new ArrayList<RasterBandInfo>(bands);
    }

    public List<RasterBandInfo> getBands() {
        return new ArrayList<RasterBandInfo>(this.bands);
    }

    public int getNumBands() {
        return this.bands.size();
    }

    public RasterBandInfo getBand(int index) {
        return this.bands.get(index);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public RasterCellType getTargetCellType() {
        List<Number> noDataValues = this.getNoDataValues();
        RasterCellType nativeCellType = this.getNativeCellType();
        RasterCellType targetCellType = RasterUtils.determineTargetCellType(nativeCellType, noDataValues);
        return targetCellType;
    }

    public boolean isColorMapped() {
        return this.getBand(0).isColorMapped();
    }

    public RasterCellType getNativeCellType() {
        return this.getBand(0).getCellType();
    }

    public List<Number> getNoDataValues() {
        ArrayList<Number> noDataValues = new ArrayList<Number>();
        for (RasterBandInfo band : this.getBands()) {
            Number noDataValue = band.getNoDataValue();
            noDataValues.add(noDataValue);
        }
        return noDataValues;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[Id: ").append(this.getRasterId());
        String srs = null;
        try {
            srs = CRS.lookupIdentifier((IdentifiedObject)this.getCoordinateReferenceSystem(), (boolean)false);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        sb.append(", bands: ").append(this.getNumBands());
        sb.append(", levels: ").append(this.getNumLevels());
        sb.append(", tile size: ").append(this.getTileWidth()).append("x").append(this.getTileHeight());
        sb.append(", crs: ").append(srs == null ? this.getCoordinateReferenceSystem().toWKT() : srs);
        GeneralEnvelope env = this.getOriginalEnvelope();
        sb.append(", Envelope: ").append(env.getMinimum(0)).append(",").append(env.getMinimum(1)).append(" ").append(env.getMaximum(0)).append(",").append(env.getMaximum(1));
        sb.append("]\n Bands[");
        for (RasterBandInfo band : this.getBands()) {
            sb.append("\n\t");
            sb.append(band.toString());
        }
        sb.append("\n ]");
        sb.append("\n Pyramid[");
        for (int l = 0; l < this.getNumLevels(); ++l) {
            sb.append("\n\t").append(this.getPyramidLevel(l).toString());
        }
        sb.append("\n ]");
        return sb.toString();
    }
}

