/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.geotools.Builder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.builder.FeatureTypeConstraintBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedLayerBuilder<P>
implements Builder<NamedLayer> {
    private StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private P parent;
    boolean unset = true;
    private LinkedHashSet<FeatureTypeConstraintBuilder<NamedLayerBuilder<P>>> constraints = new LinkedHashSet();
    private String name;

    public NamedLayerBuilder() {
        this(null);
    }

    public NamedLayerBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    @Override
    public NamedLayer build() {
        if (this.unset) {
            return null;
        }
        NamedLayer layer = this.sf.createNamedLayer();
        layer.setName(this.name);
        ArrayList<FeatureTypeConstraint> list = new ArrayList<FeatureTypeConstraint>();
        for (FeatureTypeConstraintBuilder featureTypeConstraintBuilder : this.constraints) {
            list.add(featureTypeConstraintBuilder.build());
        }
        layer.layerFeatureConstraints().addAll(list);
        if (this.parent == null) {
            this.reset();
        }
        return layer;
    }

    public P end() {
        return this.parent;
    }

    @Override
    public NamedLayerBuilder<P> reset() {
        this.unset = false;
        this.constraints.clear();
        return this;
    }

    @Override
    public NamedLayerBuilder<P> reset(NamedLayer layer) {
        if (layer == null) {
            return this.reset();
        }
        this.name = layer.getName();
        this.constraints.clear();
        if (layer.layerFeatureConstraints() != null) {
            for (FeatureTypeConstraint featureConstraint : layer.layerFeatureConstraints()) {
                this.constraints.add(new FeatureTypeConstraintBuilder<NamedLayerBuilder>(this).reset(featureConstraint));
            }
        }
        this.unset = false;
        return this;
    }

    @Override
    public NamedLayerBuilder<P> unset() {
        this.unset = true;
        return this;
    }
}

