/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.builder;

import org.geotools.Builder;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.UserLayer;
import org.geotools.styling.builder.NamedLayerBuilder;
import org.geotools.styling.builder.UserLayerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyledLayerBuilder<P>
implements Builder<StyledLayer> {
    private P parent;
    protected Builder<? extends StyledLayer> delegate;

    public StyledLayerBuilder() {
        this(null);
    }

    public StyledLayerBuilder(P parent) {
        this.parent = parent;
        this.reset();
    }

    @Override
    public StyledLayer build() {
        if (this.delegate == null) {
            return null;
        }
        StyledLayer styledLayer = this.delegate.build();
        if (this.parent == null) {
            this.reset();
        }
        return styledLayer;
    }

    UserLayerBuilder<P> user() {
        if (this.delegate == null || !(this.delegate instanceof UserLayerBuilder)) {
            this.delegate = new UserLayerBuilder<P>(this.parent);
        }
        return (UserLayerBuilder)this.delegate;
    }

    NamedLayerBuilder<P> named() {
        if (this.delegate == null || !(this.delegate instanceof NamedLayerBuilder)) {
            this.delegate = new NamedLayerBuilder<P>(this.parent);
        }
        return (NamedLayerBuilder)this.delegate;
    }

    public P end() {
        return this.parent;
    }

    @Override
    public StyledLayerBuilder<P> reset() {
        this.delegate = new NamedLayerBuilder<P>(this.parent);
        return this;
    }

    @Override
    public StyledLayerBuilder<P> unset() {
        this.delegate = null;
        return this;
    }

    @Override
    public StyledLayerBuilder<P> reset(StyledLayer layer) {
        if (layer == null) {
            return this.reset();
        }
        if (layer instanceof NamedLayer) {
            this.delegate = new NamedLayerBuilder().reset((NamedLayer)layer);
        } else if (layer instanceof UserLayer) {
            this.delegate = new UserLayerBuilder<P>(this.parent).reset((UserLayer)layer);
        }
        return this;
    }
}

