/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.tdk.cache;

import com.vividsolutions.jts.geom.Geometry;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.feature.DecoratingFeature;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.type.Types;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.Identifier;
import org.opengis.geometry.BoundingBox;

public class CachingSimpleFeature
extends DecoratingFeature {
    Map<Integer, Object> _updatedValues = new HashMap<Integer, Object>();
    List<Object> _cachedValuesList;
    private Map<Object, Object> _cachedUserData;
    private Map<Object, Object>[] attributeUserData;
    private Map<String, Integer> _index;

    public CachingSimpleFeature(SimpleFeature delegate) {
        super(delegate);
        this.buildIndex(delegate.getType());
    }

    private void buildIndex(SimpleFeatureType type) {
        this._index = new HashMap<String, Integer>();
        List descriptors = type.getAttributeDescriptors();
        int index = 0;
        for (AttributeDescriptor descriptor : descriptors) {
            this._index.put(descriptor.getLocalName(), index);
            ++index;
        }
    }

    public Object getAttribute(int index) {
        if (this._updatedValues.containsKey(index)) {
            return this._updatedValues.get(index);
        }
        return super.getAttribute(index);
    }

    public Object getAttribute(Name name) {
        return this.getAttribute(this._index.get(name.getLocalPart()));
    }

    public Object getAttribute(String path) {
        return this.getAttribute(this._index.get(path));
    }

    public List<Object> getAttributes() {
        if (this._cachedValuesList != null) {
            return this._cachedValuesList;
        }
        this._cachedValuesList = new ArrayList<Object>();
        List originalValues = super.getAttributes();
        int index = 0;
        for (Object originalValue : originalValues) {
            if (this._updatedValues.containsKey(index)) {
                this._cachedValuesList.add(this._updatedValues.get(index));
            } else {
                this._cachedValuesList.add(originalValue);
            }
            ++index;
        }
        return this._cachedValuesList;
    }

    public BoundingBox getBounds() {
        ReferencedEnvelope bounds = new ReferencedEnvelope(super.getFeatureType().getCoordinateReferenceSystem());
        List<Object> values = this.getAttributes();
        for (Object o : values) {
            if (!(o instanceof Geometry)) continue;
            Geometry g = (Geometry)o;
            if (bounds.isNull()) {
                bounds.init(g.getEnvelopeInternal());
                continue;
            }
            bounds.expandToInclude(g.getEnvelopeInternal());
        }
        return bounds;
    }

    public Object getDefaultGeometry() {
        return this.getAttribute(this.getFeatureType().getGeometryDescriptor().getName());
    }

    public GeometryAttribute getDefaultGeometryProperty() {
        GeometryDescriptor geometryDescriptor = this.getFeatureType().getGeometryDescriptor();
        GeometryAttributeImpl geometryAttribute = null;
        if (geometryDescriptor != null) {
            Object defaultGeometry = this.getDefaultGeometry();
            geometryAttribute = new GeometryAttributeImpl(defaultGeometry, geometryDescriptor, null);
        }
        return geometryAttribute;
    }

    public void setDefaultGeometryProperty(GeometryAttribute geometryAttribute) {
        if (geometryAttribute != null) {
            this.setDefaultGeometry(geometryAttribute.getValue());
        } else {
            this.setDefaultGeometry(null);
        }
    }

    public Collection<Property> getProperties(Name name) {
        return this.getProperties(name.getLocalPart());
    }

    public Collection<Property> getProperties(String name) {
        Integer idx = this._index.get(name);
        if (idx != null) {
            Set<Attribute> c = Collections.singleton(new Attribute(idx));
            return c;
        }
        return Collections.emptyList();
    }

    public Property getProperty(Name name) {
        return this.getProperty(name.getLocalPart());
    }

    public Property getProperty(String name) {
        Integer idx = this._index.get(name);
        if (idx == null) {
            return null;
        }
        int index = idx;
        AttributeDescriptor descriptor = this.getFeatureType().getDescriptor(index);
        if (descriptor instanceof GeometryDescriptor) {
            return new GeometryAttributeImpl(this.getAttribute(idx), (GeometryDescriptor)descriptor, null);
        }
        return new Attribute(index);
    }

    public Collection<Property> getProperties() {
        return new AttributeList();
    }

    public Map<Object, Object> getUserData() {
        if (this._cachedUserData == null) {
            this._cachedUserData = new HashMap<Object, Object>(super.getUserData());
        }
        return this._cachedUserData;
    }

    public Collection<? extends Property> getValue() {
        return new AttributeList();
    }

    public void setAttribute(int index, Object value) {
        this._updatedValues.put(index, value);
        this._cachedValuesList = null;
    }

    public void setAttribute(Name name, Object value) {
        this.setAttribute(this._index.get(name.getLocalPart()), value);
    }

    public void setAttribute(String path, Object value) {
        this.setAttribute(this._index.get(path), value);
    }

    public void setAttributes(List<Object> values) {
        int index = 0;
        for (Object value : values) {
            this.setAttribute(index, value);
            ++index;
        }
    }

    public void setAttributes(Object[] values) {
        this.setAttributes(Arrays.asList(values));
    }

    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        this.setAttribute(this.getDefaultGeometryProperty().getName(), (Object)geometry);
    }

    public void setDefaultGeometry(Object value) {
        this.setAttribute(this.getDefaultGeometryProperty().getName(), value);
    }

    public void setValue(Collection<Property> properties) {
        int index = 0;
        for (Property property : properties) {
            this.setAttribute(index, property.getValue());
            ++index;
        }
    }

    public void setValue(Object value) {
        this.setValue((Collection)value);
    }

    protected SimpleFeature getDelegate() {
        return this.delegate;
    }

    static /* synthetic */ Map[] access$002(CachingSimpleFeature x0, Map[] x1) {
        x0.attributeUserData = x1;
        return x1;
    }

    class Attribute
    implements org.opengis.feature.Attribute {
        int index;

        Attribute(int index) {
            this.index = index;
        }

        public Identifier getIdentifier() {
            return null;
        }

        public AttributeDescriptor getDescriptor() {
            return CachingSimpleFeature.this.getFeatureType().getDescriptor(this.index);
        }

        public AttributeType getType() {
            return CachingSimpleFeature.this.getFeatureType().getType(this.index);
        }

        public Name getName() {
            return this.getDescriptor().getName();
        }

        public Map<Object, Object> getUserData() {
            if (CachingSimpleFeature.this.attributeUserData == null) {
                CachingSimpleFeature.access$002(CachingSimpleFeature.this, new HashMap[CachingSimpleFeature.this.getAttributeCount()]);
            }
            if (CachingSimpleFeature.this.attributeUserData[this.index] == null) {
                ((CachingSimpleFeature)CachingSimpleFeature.this).attributeUserData[this.index] = new HashMap();
            }
            return CachingSimpleFeature.this.attributeUserData[this.index];
        }

        public Object getValue() {
            return CachingSimpleFeature.this.getAttribute(this.index);
        }

        public boolean isNillable() {
            return this.getDescriptor().isNillable();
        }

        public void setValue(Object newValue) {
            CachingSimpleFeature.this.setAttribute(this.index, newValue);
        }

        public void validate() {
            Types.validate((AttributeDescriptor)this.getDescriptor(), (Object)CachingSimpleFeature.this.getAttribute(this.index));
        }
    }

    class AttributeList
    extends AbstractList<Property> {
        AttributeList() {
        }

        @Override
        public Attribute get(int index) {
            return new Attribute(index);
        }

        @Override
        public Attribute set(int index, Property element) {
            CachingSimpleFeature.this.setAttribute(index, element.getValue());
            return null;
        }

        @Override
        public int size() {
            return CachingSimpleFeature.this.getAttributeCount();
        }
    }
}

