/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.tdk.cache;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.tecgraf.tdk.cache.CachingDataStore;
import org.tecgraf.tdk.cache.CachingFeatureAccessFactory;
import org.tecgraf.tdk.cache.CachingFeatureSource;
import org.tecgraf.tdk.cache.DefaultCachingFeatureAccessFactory;
import org.tecgraf.tdk.cache.FeatureCacher;
import org.tecgraf.tdk.cache.query.DefaultQueryAnalyzer;

public class SimpleCachingDataStore
implements CachingDataStore {
    private static Logger _logger = Logger.getLogger(SimpleCachingDataStore.class);
    DataStore _wrapped;
    private Map<String, FeatureCacher<SimpleFeatureType, SimpleFeature>> _featureCachers = new WeakHashMap<String, FeatureCacher<SimpleFeatureType, SimpleFeature>>();
    CachingFeatureAccessFactory<SimpleFeatureType, SimpleFeature> _cachingFeatureAccessFactory = new DefaultCachingFeatureAccessFactory();

    public SimpleCachingDataStore(DataStore original) {
        if (original == null) {
            throw new IllegalArgumentException("original can't be null");
        }
        this._wrapped = original;
    }

    public void setCachingFeatureAccessFactory(CachingFeatureAccessFactory<SimpleFeatureType, SimpleFeature> cachingFeatureAccessFactory) {
        this._cachingFeatureAccessFactory = cachingFeatureAccessFactory;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        String typeName = query.getTypeName();
        this.buildFeatureCacher(typeName);
        FeatureCacher<SimpleFeatureType, SimpleFeature> cacher = this._featureCachers.get(typeName);
        DefaultQueryAnalyzer queryAnalyzer = new DefaultQueryAnalyzer(cacher.getCachedQuery());
        if (!queryAnalyzer.isSubQuery(query)) {
            FeatureSource source = this._wrapped.getFeatureSource(typeName);
            DefaultQuery includeAllQuery = new DefaultQuery(query.getTypeName(), (Filter)Filter.INCLUDE);
            cacher.add((FeatureCollection<SimpleFeatureType, SimpleFeature>)source.getFeatures((Query)includeAllQuery), (Query)includeAllQuery);
        }
        return this._cachingFeatureAccessFactory.createFeatureReader(query, cacher);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        this.buildFeatureCacher(typeName);
        return this.buildCachingFeatureWriter(typeName, (FeatureWriter<SimpleFeatureType, SimpleFeature>)this._wrapped.getFeatureWriter(typeName, transaction));
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        this.buildFeatureCacher(typeName);
        return this.buildCachingFeatureWriter(typeName, (FeatureWriter<SimpleFeatureType, SimpleFeature>)this._wrapped.getFeatureWriter(typeName, filter, transaction));
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        this.buildFeatureCacher(typeName);
        return this.buildCachingFeatureWriter(typeName, (FeatureWriter<SimpleFeatureType, SimpleFeature>)this._wrapped.getFeatureWriterAppend(typeName, transaction));
    }

    private FeatureWriter<SimpleFeatureType, SimpleFeature> buildCachingFeatureWriter(String typeName, FeatureWriter<SimpleFeatureType, SimpleFeature> wrappedWriter) throws IOException {
        FeatureCacher<SimpleFeatureType, SimpleFeature> cacher = this._featureCachers.get(typeName);
        return this._cachingFeatureAccessFactory.createFeatureWriter(wrappedWriter, cacher);
    }

    public LockingManager getLockingManager() {
        return this._wrapped.getLockingManager();
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        return this._wrapped.getSchema(typeName);
    }

    public String[] getTypeNames() throws IOException {
        return this._wrapped.getTypeNames();
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getView(Query query) throws IOException, SchemaException {
        return this._wrapped.getView(query);
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        this._wrapped.updateSchema(typeName, featureType);
        this.clearCache(typeName);
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this._wrapped.createSchema((FeatureType)featureType);
    }

    public void dispose() {
        this._wrapped.dispose();
        this.clearCache();
    }

    public ServiceInfo getInfo() {
        return this._wrapped.getInfo();
    }

    public List<Name> getNames() throws IOException {
        return this._wrapped.getNames();
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        return (SimpleFeatureType)this._wrapped.getSchema(name);
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this._wrapped.updateSchema(typeName, (FeatureType)featureType);
        this.clearCache(typeName.getLocalPart());
    }

    @Override
    public DataStore getTargetDataStore() {
        return this._wrapped;
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(String typeName) throws IOException {
        this.buildFeatureCacher(typeName);
        FeatureCacher<SimpleFeatureType, SimpleFeature> cacher = this._featureCachers.get(typeName);
        FeatureSource featureSource = this._wrapped.getFeatureSource(typeName);
        CachingFeatureSource<SimpleFeatureType, SimpleFeature> source = null;
        source = featureSource instanceof FeatureStore ? this._cachingFeatureAccessFactory.createFeatureStore((FeatureStore<SimpleFeatureType, SimpleFeature>)((FeatureStore)featureSource), cacher) : this._cachingFeatureAccessFactory.createFeatureSource((FeatureSource<SimpleFeatureType, SimpleFeature>)featureSource, cacher);
        return source;
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(Name typeName) throws IOException {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    @Override
    public void clearCache() {
        this._featureCachers.clear();
    }

    @Override
    public void clearCache(String typename) {
        if (this._featureCachers.containsKey(typename)) {
            this._featureCachers.remove(typename);
        }
    }

    private void buildFeatureCacher(String typeName) throws IOException {
        if (!this._featureCachers.containsKey(typeName)) {
            _logger.debug((Object)("Type '" + typeName + "' not cached, creating new cacher."));
            FeatureCacher<SimpleFeatureType, SimpleFeature> cacher = this._cachingFeatureAccessFactory.createFeatureCacher(this.getSchema(typeName));
            this._featureCachers.put(typeName, cacher);
        }
    }
}

