/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.tdk.cache;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.identity.FeatureId;
import org.tecgraf.tdk.cache.CachingFeatureStore;
import org.tecgraf.tdk.cache.FeatureCacher;
import org.tecgraf.tdk.cache.SimpleCachingFeatureSource;

public class SimpleCachingFeatureStore
extends SimpleCachingFeatureSource
implements CachingFeatureStore<SimpleFeatureType, SimpleFeature> {
    private FeatureStore<SimpleFeatureType, SimpleFeature> _wrapped;
    private FeatureCacher<SimpleFeatureType, SimpleFeature> _cacher;
    private FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());

    public SimpleCachingFeatureStore(FeatureStore<SimpleFeatureType, SimpleFeature> original, FeatureCacher<SimpleFeatureType, SimpleFeature> cacher) {
        super((FeatureSource<SimpleFeatureType, SimpleFeature>)original, cacher);
        this._wrapped = original;
        this._cacher = cacher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        List featureIds = this._wrapped.addFeatures(collection);
        if (collection.size() == 0) {
            return featureIds;
        }
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder((SimpleFeatureType)collection.getSchema());
        FeatureCollection newFeaturesCollection = FeatureCollections.newCollection();
        FeatureIterator featureIterator = collection.features();
        try {
            int index = 0;
            while (featureIterator.hasNext()) {
                SimpleFeature simpleFeature = builder.buildFeature(((FeatureId)featureIds.get(index)).getID(), ((SimpleFeature)featureIterator.next()).getAttributes().toArray());
                newFeaturesCollection.add((Feature)simpleFeature);
                ++index;
            }
        }
        finally {
            featureIterator.close();
        }
        DefaultQuery query = new DefaultQuery(((SimpleFeatureType)collection.getSchema()).getTypeName(), (Filter)this.filterFactory.id(new HashSet(featureIds)));
        this._cacher.add((FeatureCollection<SimpleFeatureType, SimpleFeature>)newFeaturesCollection, (Query)query);
        return featureIds;
    }

    public Transaction getTransaction() {
        return this._wrapped.getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyFeatures(AttributeDescriptor[] type, Object[] value, Filter filter) throws IOException {
        this._wrapped.modifyFeatures(type, value, filter);
        FeatureCollection<SimpleFeatureType, SimpleFeature> featuresToUpdate = this.getFeatures(filter);
        FeatureIterator featureIterator = featuresToUpdate.features();
        try {
            while (featureIterator.hasNext()) {
                SimpleFeature featureToUpdate = (SimpleFeature)featureIterator.next();
                int index = 0;
                for (AttributeDescriptor attributeDescriptor : type) {
                    featureToUpdate.setAttribute(attributeDescriptor.getLocalName(), value[index]);
                    ++index;
                }
                this._cacher.update(featureToUpdate);
            }
        }
        finally {
            featureIterator.close();
        }
    }

    public void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new AttributeDescriptor[]{type}, new Object[]{value}, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeatures(Filter filter) throws IOException {
        this._wrapped.removeFeatures(filter);
        FeatureCollection<SimpleFeatureType, SimpleFeature> collection = this.getFeatures(filter);
        FeatureIterator featureIterator = collection.features();
        try {
            while (featureIterator.hasNext()) {
                this._cacher.remove((SimpleFeature)featureIterator.next());
            }
        }
        finally {
            featureIterator.close();
        }
    }

    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        this._wrapped.removeFeatures((Filter)Filter.INCLUDE);
        this._cacher.clear();
        FeatureCollection featureCollection = FeatureCollections.newCollection();
        while (reader.hasNext()) {
            featureCollection.add(reader.next());
        }
        this.addFeatures((FeatureCollection<SimpleFeatureType, SimpleFeature>)featureCollection);
    }

    public void setTransaction(Transaction transaction) {
        this._wrapped.setTransaction(transaction);
    }
}

