/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: CachingType.java
 * created: Dec 18, 2009
 */
package org.tecgraf.tdk.data;

/**
 * Caching type holds the types of cache gt-caching-datastore currently supports.
 * @author fabiomano
 * @since gt-caching-datastore 1.0
 */
public enum CachingType
{
    SIMPLECACHING("Simple Caching");
    
    private String _name;
    private CachingType(String name)
    {
        _name = name;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Enum#toString()
     */
    @Override
    public String toString()
    {
        return _name;
    }
    
    public static CachingType getCachingType(String name)
    {
        if (name == null)
            throw new IllegalArgumentException("name can't be null");
        
        for (CachingType type: CachingType.values())
        {
            if (type._name.equals(name))
                return type;
        }
        throw new IllegalArgumentException("No valid CachingType with name " + name);
    }
}
