/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.tdk.cache;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.tecgraf.tdk.cache.CachingFeatureReader;
import org.tecgraf.tdk.cache.FeatureCacher;

public class SimpleCachingFeatureReader
implements CachingFeatureReader<SimpleFeatureType, SimpleFeature> {
    private FeatureCacher<SimpleFeatureType, SimpleFeature> _cacher;
    private FeatureIterator<SimpleFeature> _featureIterator;

    public SimpleCachingFeatureReader(Query query, FeatureCacher<SimpleFeatureType, SimpleFeature> cacher) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null");
        }
        if (cacher == null) {
            throw new IllegalArgumentException("cacher can't be null");
        }
        this._cacher = cacher;
        FeatureCollection<SimpleFeatureType, SimpleFeature> collection = this._cacher.get(query);
        this._featureIterator = collection.features();
    }

    public void close() throws IOException {
        this._featureIterator.close();
    }

    public SimpleFeatureType getFeatureType() {
        return this._cacher.getFeatureType();
    }

    public boolean hasNext() throws IOException {
        return this._featureIterator.hasNext();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        return (SimpleFeature)this._featureIterator.next();
    }
}

