/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.spatialindex;

import org.geotools.caching.grid.spatialindex.GridSpatialIndex;
import org.geotools.caching.spatialindex.Data;
import org.geotools.caching.spatialindex.Node;
import org.geotools.caching.spatialindex.Region;
import org.geotools.caching.spatialindex.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeLockInvalidatingVisitor
implements Visitor {
    private Region region;
    private GridSpatialIndex index;
    private int dataCount = 0;

    public NodeLockInvalidatingVisitor(GridSpatialIndex index, Region r) {
        this.region = r;
        this.index = index;
    }

    public NodeLockInvalidatingVisitor(GridSpatialIndex index) {
        this(index, null);
    }

    @Override
    public boolean isDataVisitor() {
        return false;
    }

    @Override
    public void visitData(Data<?> d) {
    }

    @Override
    public void visitNode(Node n) {
        if (this.region == null || this.region.contains(n.getShape())) {
            try {
                n.getIdentifier().writeLock();
                try {
                    this.dataCount += n.getDataCount();
                    n.clear();
                    this.index.writeNode(n);
                }
                finally {
                    n.getIdentifier().writeUnLock();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public int getDataCount() {
        return this.dataCount;
    }
}

