/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.spatialindex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import org.geotools.caching.grid.spatialindex.GridData;
import org.geotools.caching.spatialindex.Node;
import org.geotools.caching.spatialindex.NodeIdentifier;
import org.geotools.caching.spatialindex.RegionNodeIdentifier;
import org.geotools.caching.spatialindex.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridNode
implements Node,
Serializable {
    private static final long serialVersionUID = 7786313461725794946L;
    protected HashSet<GridData> data;
    protected transient RegionNodeIdentifier id = null;

    protected GridNode() {
    }

    protected GridNode(RegionNodeIdentifier id) {
        this.data = new HashSet();
        this.id = id;
    }

    @Override
    public void setIdentifier(NodeIdentifier id) {
        this.id = (RegionNodeIdentifier)id;
    }

    @Override
    public NodeIdentifier getChildIdentifier(int index) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException("GridNode have no children.");
    }

    @Override
    public int getChildrenCount() {
        return 0;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public boolean isIndex() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public NodeIdentifier getIdentifier() {
        return this.id;
    }

    @Override
    public Shape getShape() {
        return this.getIdentifier().getShape();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean insertData(GridData data) {
        HashSet<GridData> hashSet = this.data;
        synchronized (hashSet) {
            if (this.data.contains(data)) {
                return false;
            }
            this.data.add(data);
            return true;
        }
    }

    protected void deleteData(GridData data) {
        this.data.remove(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        HashSet<GridData> hashSet = this.data;
        synchronized (hashSet) {
            this.data.clear();
            this.getIdentifier().setValid(false);
        }
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    public HashSet<GridData> getData() {
        return this.data;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GridNode: MBR:" + this.getIdentifier().getShape());
        return sb.toString();
    }

    public String toReadableText() {
        StringBuffer sb = new StringBuffer();
        sb.append("GridNode ******");
        sb.append("\tMBR= " + this.getIdentifier().getShape() + "\n");
        sb.append("\t#Data= " + this.data.size() + "\n");
        Iterator<GridData> it = this.data.iterator();
        while (it.hasNext()) {
            sb.append("\t\t" + it.next().getData().toString() + "\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        HashSet<GridData> hashSet = this.data;
        synchronized (hashSet) {
            stream.writeObject(this.data);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.data = (HashSet)stream.readObject();
    }
}

