/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.chart;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.Arrays;
import java.util.List;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.data.xy.AbstractXYDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryDataset
extends AbstractXYDataset {
    double buffer;
    double buf;
    List<Geometry> geometries;
    Envelope bounds;

    public GeometryDataset(Geometry ... geometries) {
        this.geometries = Arrays.asList(geometries);
        this.bounds = new Envelope();
        Geometry[] geometryArray = geometries;
        int n = geometries.length;
        int n2 = 0;
        while (n2 < n) {
            Geometry g = geometryArray[n2];
            this.bounds.expandToInclude(g.getEnvelopeInternal());
            ++n2;
        }
        this.setBuffer(0.1);
    }

    public List<Geometry> getGeometries() {
        return this.geometries;
    }

    public void setBuffer(double buffer) {
        this.buffer = buffer;
        this.buf = Math.max(buffer, Math.max(this.bounds.getWidth() * buffer, this.bounds.getHeight() * buffer));
    }

    public int getSeriesCount() {
        return this.geometries.size();
    }

    public Comparable getSeriesKey(int series) {
        Geometry g = this.geometries.get(series);
        String wkt = g.toText();
        if (g instanceof Point) {
            return wkt;
        }
        int i = wkt.indexOf(44);
        int j = wkt.lastIndexOf(44);
        return String.valueOf(wkt.substring(0, i)) + " ... " + wkt.substring(j + 1);
    }

    public int getItemCount(int series) {
        return 1;
    }

    public Number getX(int series, int item) {
        return this.geometries.get((int)series).getCoordinate().x;
    }

    public Number getY(int series, int item) {
        return this.geometries.get((int)series).getCoordinate().x;
    }

    public ValueAxis getDomain() {
        NumberAxis domain = new NumberAxis();
        domain.setRange(this.bounds.getMinX() - this.buf, this.bounds.getMaxX() + this.buf);
        return domain;
    }

    public ValueAxis getRange() {
        NumberAxis range = new NumberAxis();
        range.setRange(this.bounds.getMinY() - this.buf, this.bounds.getMaxY() + this.buf);
        return range;
    }
}

