/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import javax.measure.unit.Unit;
import org.geotools.coverage.Category;
import org.geotools.coverage.CategoryList;
import org.geotools.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GeophysicsCategoryList
extends CategoryList {
    private static final long serialVersionUID = 98602310176453958L;
    private static final int MAX_DIGITS = 6;
    private final Unit<?> unit;
    private final int ndigits;
    private transient Locale locale;
    private transient NumberFormat format;
    private transient FieldPosition dummy;

    GeophysicsCategoryList(Category[] categories, Unit<?> unit, CategoryList inverse) {
        super(categories, unit, true, inverse);
        this.unit = unit;
        this.ndigits = GeophysicsCategoryList.getFractionDigitCount(categories);
        assert (this.isGeophysics(true));
    }

    private static int getFractionDigitCount(Category[] categories) {
        int ndigits = 0;
        double EPS = 1.0E-6;
        int length = categories.length;
        int i = 0;
        while (i < length) {
            int n;
            Category category = categories[i];
            Category geophysics = category.geophysics(true);
            Category packed = category.geophysics(false);
            double ln = Math.log10((geophysics.maximum - geophysics.minimum) / (packed.maximum - packed.minimum));
            if (!Double.isNaN(ln) && (n = -((int)Math.floor(ln + 1.0E-6))) > ndigits) {
                ndigits = Math.min(n, 6);
            }
            ++i;
        }
        return ndigits;
    }

    @Override
    public CategoryList geophysics(boolean geo) {
        CategoryList scaled;
        CategoryList categoryList = scaled = geo ? this : this.inverse;
        assert (scaled.isGeophysics(geo));
        return scaled;
    }

    @Override
    public Unit<?> getUnits() {
        return this.unit;
    }

    @Override
    synchronized StringBuffer format(double value, boolean writeUnits, Locale locale, StringBuffer buffer) {
        if (this.format == null || !Utilities.equals((Object)this.locale, (Object)locale)) {
            this.locale = locale;
            this.format = locale != null ? NumberFormat.getNumberInstance(locale) : NumberFormat.getNumberInstance();
            this.format.setMinimumFractionDigits(this.ndigits);
            this.format.setMaximumFractionDigits(this.ndigits);
            this.dummy = new FieldPosition(0);
        }
        buffer = this.format.format(value, buffer, this.dummy);
        if (writeUnits && this.unit != null) {
            int position = buffer.length();
            buffer.append('\u00a0');
            buffer.append(this.unit);
            if (buffer.length() == position + 1) {
                buffer.setLength(position);
            }
        }
        return buffer;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof GeophysicsCategoryList) {
            GeophysicsCategoryList that = (GeophysicsCategoryList)object;
            return this.ndigits == that.ndigits && Utilities.equals(this.unit, that.unit) && super.equals(that);
        }
        return this.ndigits == 0 && this.unit == null && super.equals(object);
    }
}

