/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.util.Date;
import javax.media.jai.util.Range;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.OrdinateOutsideCoverageException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultTemporalCRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.TransformPathNotFoundException;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.SampleDimension;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

public class SpatioTemporalCoverage3D
extends AbstractCoverage {
    private static final Hints HINTS = null;
    private static final AxisDirection[] DIRECTIONS = new AxisDirection[]{AxisDirection.EAST, AxisDirection.NORTH, AxisDirection.DISPLAY_RIGHT, AxisDirection.DISPLAY_UP, AxisDirection.COLUMN_POSITIVE, AxisDirection.ROW_POSITIVE};
    private final Coverage coverage;
    private final DefaultTemporalCRS temporalCRS;
    private final int temporalDimension;
    private final int xDimension;
    private final int yDimension;
    private transient GeographicBoundingBox boundingBox;
    private final GeneralDirectPosition coordinate;
    private transient GridCoverageFactory factory;

    public SpatioTemporalCoverage3D(CharSequence name, Coverage coverage) throws IllegalArgumentException {
        super(name, coverage);
        CoordinateSystem cs = this.crs.getCoordinateSystem();
        int dimension = cs.getDimension();
        if (dimension != 3) {
            throw new MismatchedDimensionException(Errors.format((int)93, (Object)3, (Object)dimension));
        }
        if (coverage instanceof SpatioTemporalCoverage3D) {
            SpatioTemporalCoverage3D source = (SpatioTemporalCoverage3D)coverage;
            this.coverage = source.coverage;
            this.temporalCRS = source.temporalCRS;
            this.temporalDimension = source.temporalDimension;
            this.xDimension = source.xDimension;
            this.yDimension = source.yDimension;
            this.boundingBox = source.boundingBox;
        } else {
            this.coverage = coverage;
            this.temporalCRS = DefaultTemporalCRS.wrap((TemporalCRS)CRS.getTemporalCRS((CoordinateReferenceSystem)this.crs));
            if (this.temporalCRS == null) {
                throw new IllegalArgumentException(Errors.format((int)62));
            }
            this.temporalDimension = CRSUtilities.getDimensionOf((CoordinateReferenceSystem)this.crs, this.temporalCRS.getClass());
            int xDimension = this.temporalDimension != 0 ? 0 : 1;
            int yDimension = this.temporalDimension != 2 ? 2 : 1;
            Boolean swap = null;
            int p = 0;
            block0: while (p <= 1) {
                AxisDirection direction = cs.getAxis(p == 0 ? xDimension : yDimension).getDirection().absolute();
                int i = 0;
                while (i < DIRECTIONS.length) {
                    if (direction.equals((Object)DIRECTIONS[i])) {
                        boolean needSwap;
                        boolean bl = needSwap = (i & 1) != p;
                        if (swap == null) {
                            swap = needSwap;
                        } else if (swap != needSwap) {
                            swap = null;
                            break block0;
                        }
                    }
                    ++i;
                }
                ++p;
            }
            if (swap != null && swap.booleanValue()) {
                this.xDimension = yDimension;
                this.yDimension = xDimension;
            } else {
                this.xDimension = xDimension;
                this.yDimension = yDimension;
            }
        }
        assert (this.temporalDimension >= 0 && this.temporalDimension < dimension) : this.temporalDimension;
        this.coordinate = new GeneralDirectPosition(dimension);
    }

    public final Coverage getWrappedCoverage() {
        return this.coverage;
    }

    public int getNumSampleDimensions() {
        return this.coverage.getNumSampleDimensions();
    }

    public SampleDimension getSampleDimension(int index) throws IndexOutOfBoundsException {
        return this.coverage.getSampleDimension(index);
    }

    public GeographicBoundingBox getGeographicBoundingBox() throws TransformException {
        if (this.boundingBox == null) {
            Envelope envelope = this.getEnvelope();
            Object geographicArea = XRectangle2D.createFromExtremums((double)envelope.getMinimum(this.xDimension), (double)envelope.getMinimum(this.yDimension), (double)envelope.getMaximum(this.xDimension), (double)envelope.getMaximum(this.yDimension));
            SingleCRS sourceCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.crs);
            if (sourceCRS == null) {
                throw new TransformException(Errors.format((int)31, (Object)this.crs.getName()));
            }
            DefaultGeographicCRS targetCRS = DefaultGeographicCRS.WGS84;
            if (!CRS.equalsIgnoreMetadata((Object)targetCRS, (Object)sourceCRS)) {
                CoordinateOperation transform;
                CoordinateOperationFactory factory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)HINTS);
                try {
                    transform = factory.createOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
                }
                catch (FactoryException exception) {
                    throw new TransformPathNotFoundException(exception);
                }
                geographicArea = CRS.transform((CoordinateOperation)transform, (Rectangle2D)geographicArea, (Rectangle2D)geographicArea);
            }
            this.boundingBox = (GeographicBoundingBox)new GeographicBoundingBoxImpl((Rectangle2D)geographicArea).unmodifiable();
        }
        return this.boundingBox;
    }

    public Range getTimeRange() {
        Envelope envelope = this.getEnvelope();
        return new Range(Date.class, (Comparable)this.temporalCRS.toDate(envelope.getMinimum(this.temporalDimension)), (Comparable)this.temporalCRS.toDate(envelope.getMaximum(this.temporalDimension)));
    }

    public final int toSourceDimension(int dimension) {
        switch (dimension) {
            case 0: {
                return this.xDimension;
            }
            case 1: {
                return this.yDimension;
            }
            case 2: {
                return this.temporalDimension;
            }
        }
        throw new IllegalArgumentException();
    }

    public final DirectPosition toDirectPosition(Point2D point, Date date) {
        this.coordinate.ordinates[this.xDimension] = point.getX();
        this.coordinate.ordinates[this.yDimension] = point.getY();
        this.coordinate.ordinates[this.temporalDimension] = this.temporalCRS.toValue(date);
        return this.coordinate;
    }

    public final Date toDate(DirectPosition position) {
        return this.temporalCRS.toDate(position.getOrdinate(this.temporalDimension));
    }

    public final Point2D toPoint2D(DirectPosition position) {
        return new Point2D.Double(position.getOrdinate(this.xDimension), position.getOrdinate(this.yDimension));
    }

    public final boolean[] evaluate(Point2D point, Date time, boolean[] dest) throws CannotEvaluateException {
        try {
            return this.evaluate(this.toDirectPosition(point, time), dest);
        }
        catch (OrdinateOutsideCoverageException exception) {
            if (exception.getOutOfBoundsDimension() == this.temporalDimension) {
                exception = new OrdinateOutsideCoverageException(exception, time);
            }
            throw exception;
        }
    }

    public final byte[] evaluate(Point2D point, Date time, byte[] dest) throws CannotEvaluateException {
        try {
            return this.evaluate(this.toDirectPosition(point, time), dest);
        }
        catch (OrdinateOutsideCoverageException exception) {
            if (exception.getOutOfBoundsDimension() == this.temporalDimension) {
                exception = new OrdinateOutsideCoverageException(exception, time);
            }
            throw exception;
        }
    }

    public final int[] evaluate(Point2D point, Date time, int[] dest) throws CannotEvaluateException {
        try {
            return this.evaluate(this.toDirectPosition(point, time), dest);
        }
        catch (OrdinateOutsideCoverageException exception) {
            if (exception.getOutOfBoundsDimension() == this.temporalDimension) {
                exception = new OrdinateOutsideCoverageException(exception, time);
            }
            throw exception;
        }
    }

    public final float[] evaluate(Point2D point, Date time, float[] dest) throws CannotEvaluateException {
        try {
            return this.evaluate(this.toDirectPosition(point, time), dest);
        }
        catch (OrdinateOutsideCoverageException exception) {
            if (exception.getOutOfBoundsDimension() == this.temporalDimension) {
                exception = new OrdinateOutsideCoverageException(exception, time);
            }
            throw exception;
        }
    }

    public final double[] evaluate(Point2D point, Date time, double[] dest) throws CannotEvaluateException {
        try {
            return this.evaluate(this.toDirectPosition(point, time), dest);
        }
        catch (OrdinateOutsideCoverageException exception) {
            if (exception.getOutOfBoundsDimension() == this.temporalDimension) {
                exception = new OrdinateOutsideCoverageException(exception, time);
            }
            throw exception;
        }
    }

    public final Object evaluate(DirectPosition coord) throws CannotEvaluateException {
        return this.coverage.evaluate(coord);
    }

    public final boolean[] evaluate(DirectPosition coord, boolean[] dest) throws CannotEvaluateException {
        return this.coverage.evaluate(coord, dest);
    }

    public final byte[] evaluate(DirectPosition coord, byte[] dest) throws CannotEvaluateException {
        return this.coverage.evaluate(coord, dest);
    }

    public final int[] evaluate(DirectPosition coord, int[] dest) throws CannotEvaluateException {
        return this.coverage.evaluate(coord, dest);
    }

    public final float[] evaluate(DirectPosition coord, float[] dest) throws CannotEvaluateException {
        return this.coverage.evaluate(coord, dest);
    }

    public final double[] evaluate(DirectPosition coord, double[] dest) throws CannotEvaluateException {
        return this.coverage.evaluate(coord, dest);
    }

    public GridCoverage2D getGridCoverage2D(Date time) throws CannotEvaluateException {
        InternationalString name = this.getName();
        SingleCRS crs = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.crs);
        if (crs == null) {
            throw new CannotEvaluateException(Errors.format((int)31, (Object)this.crs.getName()));
        }
        RenderedImage image = this.getRenderableImage(time).createDefaultRendering();
        GridSampleDimension[] bands = new GridSampleDimension[this.getNumSampleDimensions()];
        int i = 0;
        while (i < this.getNumSampleDimensions()) {
            bands[i] = GridSampleDimension.wrap(this.getSampleDimension(i));
            ++i;
        }
        LinearTransform gridToCRS = ProjectiveTransform.create((AffineTransform)((AffineTransform)image.getProperty("gridToCRS")));
        if (this.factory == null) {
            this.factory = CoverageFactoryFinder.getGridCoverageFactory(HINTS);
        }
        return this.factory.create((CharSequence)name, image, (CoordinateReferenceSystem)crs, (MathTransform)gridToCRS, bands, null, null);
    }

    public RenderableImage getRenderableImage(Date date) {
        return new Renderable(date);
    }

    protected Dimension2D getDefaultPixelSize() {
        return null;
    }

    private final class Renderable
    extends AbstractCoverage.Renderable {
        public Renderable(Date date) {
            super(SpatioTemporalCoverage3D.this.xDimension, SpatioTemporalCoverage3D.this.yDimension);
            this.coordinate.ordinates[((SpatioTemporalCoverage3D)SpatioTemporalCoverage3D.this).temporalDimension] = SpatioTemporalCoverage3D.this.temporalCRS.toValue(date);
        }

        public RenderedImage createDefaultRendering() {
            Dimension2D pixelSize = SpatioTemporalCoverage3D.this.getDefaultPixelSize();
            if (pixelSize == null) {
                return super.createDefaultRendering();
            }
            return this.createScaledRendering((int)Math.round((double)this.getWidth() / pixelSize.getWidth()), (int)Math.round((double)this.getHeight() / pixelSize.getHeight()), null);
        }
    }
}

