/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.Classes;
import org.geotools.util.Utilities;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.util.Cloneable;

public class ImageGeometry
implements GridGeometry,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1985363181119389264L;
    private final GridEnvelope2D gridRange;
    private final AffineTransform2D gridToCRS;

    public ImageGeometry(Rectangle bounds, AffineTransform gridToCRS) {
        this.gridRange = new GridEnvelope2D(bounds);
        this.gridToCRS = new AffineTransform2D(gridToCRS);
    }

    public GridEnvelope2D getGridRange() {
        return this.gridRange.clone();
    }

    public AffineTransform2D getGridToCRS() {
        return this.gridToCRS;
    }

    public AffineTransform2D getGridToCoordinateSystem() {
        return this.gridToCRS;
    }

    public String toString() {
        return String.valueOf(Classes.getShortClassName((Object)this)) + '[' + this.gridRange + ", " + this.gridToCRS + ']';
    }

    public int hashCode() {
        return this.gridRange.hashCode() ^ this.gridToCRS.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            ImageGeometry that = (ImageGeometry)object;
            return Utilities.equals((Object)this.gridRange, (Object)that.gridRange) && Utilities.equals((Object)this.gridToCRS, (Object)that.gridToCRS);
        }
        return false;
    }

    public ImageGeometry clone() {
        try {
            return (ImageGeometry)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

