/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.LookupDescriptor;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.LookupTableFactory;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.factory.Hints;
import org.geotools.resources.XArray;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.NumberRange;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ViewsManager {
    private static final float EPS = 1.0E-5f;
    private final Map<ViewType, GridCoverage2D> views = new EnumMap<ViewType, GridCoverage2D>(ViewType.class);

    private ViewsManager(GridCoverage2D coverage) {
        boolean geophysics = true;
        boolean photographic = true;
        int numBands = coverage.getNumSampleDimensions();
        int i = 0;
        while (i < numBands) {
            List<Category> categories;
            GridSampleDimension band = coverage.getSampleDimension(i);
            if (band != null && (categories = band.getCategories()) != null && !categories.isEmpty()) {
                photographic = false;
                GridSampleDimension packed = band.geophysics(false);
                if (band != packed) {
                    for (Category category : packed.getCategories()) {
                        if (!category.isQuantitative()) {
                            continue;
                        }
                        break;
                    }
                } else {
                    geophysics = false;
                }
            }
            ++i;
        }
        ViewType type = photographic ? ViewType.PHOTOGRAPHIC : (geophysics ? ViewType.GEOPHYSICS : ViewType.PACKED);
        this.views.put(type, coverage);
        this.views.put(ViewType.NATIVE, coverage.getNativeView());
    }

    static ViewsManager create(GridCoverage2D coverage) {
        Class<? extends GridCoverage2D> viewClass = coverage.getViewClass();
        if (viewClass != null) {
            List<GridCoverage> sources = coverage.getSources();
            while (sources != null) {
                LinkedHashSet next = null;
                for (GridCoverage source : sources) {
                    List more;
                    if (source instanceof GridCoverage2D) {
                        GridCoverage2D candidate = (GridCoverage2D)source;
                        if (Utilities.equals((Object)coverage.image, (Object)candidate.image) && Utilities.equals((Object)coverage.gridGeometry, (Object)candidate.gridGeometry) && Arrays.equals(coverage.sampleDimensions, candidate.sampleDimensions) && viewClass.equals(candidate.getViewClass())) {
                            return candidate.copyViewsTo(coverage);
                        }
                    }
                    if (source == null || (more = source.getSources()) == null || more.isEmpty()) continue;
                    if (next == null) {
                        next = new LinkedHashSet(more);
                        continue;
                    }
                    next.addAll(more);
                }
                sources = next;
            }
        }
        return new ViewsManager(coverage);
    }

    public synchronized GridCoverage2D get(GridCoverage2D caller, ViewType type, Hints userHints) {
        GridCoverage2D coverage = this.views.get((Object)type);
        if (coverage != null) {
            return coverage;
        }
        coverage = this.views.get((Object)ViewType.NATIVE);
        if (coverage == null) {
            throw new IllegalStateException("This coverage has been disposed.");
        }
        switch (type) {
            case RENDERED: {
                coverage = this.rendered(caller, userHints);
                break;
            }
            case PACKED: {
                coverage = ViewsManager.geophysics(coverage, false, userHints);
                break;
            }
            case GEOPHYSICS: {
                coverage = ViewsManager.geophysics(coverage, true, userHints);
                break;
            }
            case PHOTOGRAPHIC: {
                coverage = ViewsManager.photographic(coverage, userHints);
                break;
            }
            default: {
                throw new IllegalArgumentException(Errors.format((int)58, (Object)"type", (Object)((Object)type)));
            }
        }
        coverage = caller.specialize(coverage);
        if (caller.copyViewsTo(coverage) != this) {
            throw new AssertionError();
        }
        this.views.put(type, coverage);
        return coverage;
    }

    private static GridCoverage2D photographic(GridCoverage2D coverage, Hints userHints) {
        ImageLayout layout;
        LookupTableJAI lookup;
        int dataType;
        ColorSpace cs;
        RenderedImage image = coverage.getRenderedImage();
        ColorModel cm = image.getColorModel();
        if (cm instanceof ComponentColorModel) {
            return coverage;
        }
        if (cm instanceof IndexColorModel) {
            Object data;
            IndexColorModel icm = (IndexColorModel)cm;
            int mapSize = icm.getMapSize();
            if (ColorUtilities.isGrayPalette(icm, false)) {
                byte[] gray = new byte[mapSize];
                icm.getGreens(gray);
                if (icm.hasAlpha()) {
                    byte[] alpha = new byte[mapSize];
                    icm.getAlphas(alpha);
                    data = new byte[][]{gray, alpha};
                } else {
                    data = new byte[][]{gray};
                }
                cs = ColorSpace.getInstance(1003);
            } else {
                data = new byte[cm.getNumComponents()][mapSize];
                switch (((byte[][])data).length) {
                    default: {
                        icm.getAlphas(data[3]);
                    }
                    case 3: {
                        icm.getBlues(data[2]);
                    }
                    case 2: {
                        icm.getGreens(data[1]);
                    }
                    case 1: {
                        icm.getReds(data[0]);
                    }
                    case 0: 
                }
                cs = icm.getColorSpace();
            }
            dataType = 0;
            lookup = new LookupTableJAI(data);
        } else {
            lookup = null;
            cs = cm.getColorSpace();
            dataType = cm instanceof DirectColorModel ? 0 : image.getSampleModel().getTransferType();
        }
        ComponentColorModel targetCM = new ComponentColorModel(cs, cm.hasAlpha(), cm.isAlphaPremultiplied(), cm.getTransparency(), dataType);
        SampleModel targetSM = ((ColorModel)targetCM).createCompatibleSampleModel(image.getWidth(), image.getHeight());
        RenderingHints hints = ImageUtilities.getRenderingHints(image);
        if (hints == null) {
            hints = new RenderingHints(null);
        }
        if ((layout = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT)) == null) {
            layout = new ImageLayout();
        }
        layout.setColorModel((ColorModel)targetCM);
        layout.setSampleModel(targetSM);
        hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        RenderedOp view = lookup != null ? LookupDescriptor.create((RenderedImage)image, (LookupTableJAI)lookup, (RenderingHints)hints) : FormatDescriptor.create((RenderedImage)image, (Integer)dataType, (RenderingHints)hints);
        assert (view.getColorModel() instanceof ComponentColorModel);
        return ViewsManager.createView(coverage, view, null, 2, userHints);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GridCoverage2D geophysics(GridCoverage2D coverage, boolean toGeo, Hints userHints) {
        int n;
        String operation;
        RenderingHints hints;
        ParameterBlock param;
        Object[] targetBands;
        Object[] sourceBands;
        block45: {
            PlanarImage image = coverage.image;
            while (image instanceof NullOpImage) {
                NullOpImage op = (NullOpImage)image;
                if (op.getNumSources() != 1) break;
                image = op.getSourceImage(0);
            }
            SampleModel sourceModel = image.getSampleModel();
            int numBands = sourceModel.getNumBands();
            sourceBands = coverage.sampleDimensions;
            targetBands = (GridSampleDimension[])sourceBands.clone();
            assert (targetBands.length == numBands) : targetBands.length;
            int i = 0;
            while (i < targetBands.length) {
                targetBands[i] = ((GridSampleDimension)targetBands[i]).geophysics(toGeo);
                ++i;
            }
            if (Arrays.equals(sourceBands, targetBands)) {
                return coverage;
            }
            int visibleBand = CoverageUtilities.getVisibleBand(image);
            Object[] nativeBands = toGeo ? sourceBands : targetBands;
            boolean isIdentity = true;
            MathTransform1D[] transforms = new MathTransform1D[numBands];
            int i2 = 0;
            while (i2 < numBands) {
                MathTransform1D transform = ((GridSampleDimension)nativeBands[i2]).getSampleToGeophysics();
                if (transform != null && !toGeo) {
                    try {
                        transform = transform.inverse();
                    }
                    catch (NoninvertibleTransformException e) {
                        transform = null;
                        isIdentity = false;
                    }
                }
                transforms[i2] = transform;
                isIdentity &= transform.isIdentity();
                ++i2;
            }
            if (isIdentity) {
                return coverage;
            }
            ImageLayout layout = ImageUtilities.getImageLayout((RenderedImage)image);
            ColorModel colors = ((GridSampleDimension)targetBands[visibleBand]).getColorModel(visibleBand, numBands);
            SampleModel targetModel = colors.createCompatibleSampleModel(layout.getTileWidth((RenderedImage)image), layout.getTileHeight((RenderedImage)image));
            if (colors instanceof IndexColorModel && targetModel.getClass().equals(ComponentSampleModel.class)) {
                int w = targetModel.getWidth();
                int h = targetModel.getHeight();
                targetModel = new PixelInterleavedSampleModel(colors.getTransferType(), w, h, 1, w, new int[1]);
            }
            layout = layout.setSampleModel(targetModel).setColorModel(colors);
            param = new ParameterBlock().addSource(image);
            hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            hints.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            hints.put(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
            operation = null;
            try {
                int sourceType = sourceModel.getDataType();
                int targetType = targetModel.getDataType();
                LookupTableJAI table = LookupTableFactory.create(sourceType, targetType, transforms);
                if (table != null) {
                    operation = "Lookup";
                    param = param.add(table);
                }
            }
            catch (TransformException sourceType) {
                // empty catch block
            }
            if (operation != null) break block45;
            try {
                boolean canRescale = true;
                boolean canPiecewise = true;
                boolean conditional = false;
                double[] scales = null;
                double[] offsets = null;
                float[][][] fArray = null;
                int i3 = 0;
                block9: while (i3 < numBands) {
                    List<Category> sources = ((GridSampleDimension)sourceBands[i3]).getCategories();
                    int numCategories = sources.size();
                    float[] sourceBreakpoints = null;
                    float[] targetBreakpoints = null;
                    double expectedSource = Double.NaN;
                    double expectedTarget = Double.NaN;
                    int jbp = 0;
                    int j = 0;
                    while (true) {
                        block43: {
                            NumberRange<? extends Number> range;
                            double scale;
                            double offset;
                            Category sourceCategory;
                            block47: {
                                MathTransform1D transform;
                                block46: {
                                    if (j >= numCategories) {
                                        sourceBreakpoints = XArray.resize((float[])sourceBreakpoints, (int)jbp);
                                        var23_32[i3][0] = sourceBreakpoints;
                                        targetBreakpoints = XArray.resize((float[])targetBreakpoints, (int)jbp);
                                        var23_32[i3][1] = targetBreakpoints;
                                        assert (XArray.isSorted((float[])sourceBreakpoints));
                                        break;
                                    }
                                    sourceCategory = sources.get(j);
                                    Category packedCategory = sourceCategory.geophysics(false);
                                    transform = packedCategory.getSampleToGeophysics();
                                    if (transform != null) break block46;
                                    if (toGeo) {
                                        canRescale = false;
                                        NumberRange<? extends Number> target = sourceCategory.geophysics(true).getRange();
                                        offset = target.getMinimum();
                                        if (Double.doubleToRawLongBits(offset) != Double.doubleToRawLongBits(target.getMaximum())) {
                                            canPiecewise = false;
                                            break block9;
                                        }
                                        scale = 0.0;
                                        break block47;
                                    } else {
                                        canPiecewise = false;
                                        assert (!packedCategory.equals(sourceCategory)) : packedCategory;
                                        range = packedCategory.getRange();
                                        if (range.getMinimum(true) == 0.0 && range.getMaximum(true) == 0.0) {
                                            assert (Double.isNaN(sourceCategory.getRange().getMinimum())) : sourceCategory;
                                            conditional = true;
                                            break block43;
                                        } else {
                                            canRescale = false;
                                            break block9;
                                        }
                                    }
                                }
                                if (!toGeo) {
                                    transform = transform.inverse();
                                }
                                offset = transform.transform(0.0);
                                scale = transform.derivative(Double.NaN);
                                if (Double.isNaN(scale) || Double.isNaN(offset)) {
                                    canRescale = false;
                                    canPiecewise = false;
                                    break block9;
                                }
                            }
                            if (j == 0) {
                                if (i3 == 0) {
                                    scales = new double[numBands];
                                    offsets = new double[numBands];
                                    float[][][] fArrayArray = new float[numBands][][];
                                }
                                sourceBreakpoints = new float[numCategories * 2];
                                targetBreakpoints = new float[numCategories * 2];
                                var23_32[i3] = new float[][]{sourceBreakpoints, targetBreakpoints};
                                offsets[i3] = offset;
                                scales[i3] = scale;
                            }
                            if (offset != offsets[i3] || scale != scales[i3]) {
                                canRescale = false;
                            }
                            range = sourceCategory.getRange();
                            double minimum = range.getMinimum(true);
                            double maximum = range.getMaximum(true);
                            float sourceMin = (float)minimum;
                            float sourceMax = (float)maximum;
                            float targetMin = (float)(minimum * scale + offset);
                            float targetMax = (float)(maximum * scale + offset);
                            assert (sourceMin <= sourceMax) : range;
                            if (Math.abs(minimum - expectedSource) <= (double)1.0E-5f) {
                                if (Math.abs((double)targetMin - expectedTarget) <= (double)1.0E-5f || Double.isNaN(expectedTarget)) {
                                    --jbp;
                                } else {
                                    assert (sourceBreakpoints[jbp - 1] < sourceMin) : expectedSource;
                                    canPiecewise = false;
                                }
                            } else if (j != 0) assert (!(expectedSource > (double)sourceMin)) : expectedSource;
                            sourceBreakpoints[jbp] = sourceMin;
                            sourceBreakpoints[jbp + 1] = sourceMax;
                            targetBreakpoints[jbp] = targetMin;
                            targetBreakpoints[jbp + 1] = targetMax;
                            jbp += 2;
                            expectedSource = range.getMaximum(false);
                            expectedTarget = expectedSource * scale + offset;
                        }
                        ++j;
                    }
                    ++i3;
                }
                if (canRescale && scales != null && (!conditional || ViewsManager.isZeroExcluded((RenderedImage)image, scales, offsets))) {
                    operation = "Rescale";
                    param = param.add(scales).add(offsets);
                } else if (canPiecewise) {
                    // empty if block
                }
            }
            catch (TransformException exception) {
                Logging.recoverableException(GridCoverage2D.class, (String)"view", (Throwable)exception);
            }
        }
        if (operation == null) {
            param = param.add(sourceBands);
            operation = "org.geotools.SampleTranscode";
        }
        RenderedOp view = JAI.create(operation, (ParameterBlock)param, (RenderingHints)hints);
        if (toGeo) {
            n = 1;
            return ViewsManager.createView(coverage, view, (GridSampleDimension[])targetBands, n, userHints);
        }
        n = 0;
        return ViewsManager.createView(coverage, view, (GridSampleDimension[])targetBands, n, userHints);
    }

    private GridCoverage2D rendered(GridCoverage2D coverage, Hints userHints) {
        return this.get(coverage, ViewType.PACKED, userHints);
    }

    private static GridCoverage2D createView(GridCoverage2D coverage, RenderedOp view, GridSampleDimension[] targetBands, int code, Hints userHints) {
        InternationalString name = coverage.getName();
        if (GridCoverage2D.LOGGER.isLoggable(CoverageProcessor.OPERATION)) {
            String operation = view.getOperationName();
            String shortName = operation.substring(operation.lastIndexOf(46) + 1);
            Locale locale = coverage.getLocale();
            LogRecord record = Loggings.getResources((Locale)locale).getLogRecord(CoverageProcessor.OPERATION, 39, (Object)new Object[]{name != null ? name.toString(locale) : Vocabulary.getResources((Locale)locale).getString(232), code, shortName});
            record.setSourceClassName(GridCoverage2D.class.getName());
            record.setSourceMethodName("geophysics");
            Logger logger = GridCoverage2D.LOGGER;
            record.setLoggerName(logger.getName());
            logger.log(record);
        }
        GridCoverage[] sources = new GridCoverage[]{coverage};
        return new GridCoverage2D((CharSequence)name, (PlanarImage)view, coverage.gridGeometry, targetBands, sources, null, userHints);
    }

    private static boolean isZeroExcluded(RenderedImage image, double[] scales, double[] offsets) {
        if (image instanceof WritableRenderedImage) {
            return false;
        }
        Object parent = image;
        while (parent instanceof PlanarImage) {
            int n;
            PlanarImage planar = (PlanarImage)image;
            if (parent instanceof RenderedOp) {
                RenderedOp op = (RenderedOp)parent;
                String name = op.getOperationName();
                if (name.equalsIgnoreCase("Extrema")) {
                    int n2 = op.getNumParameters();
                    int i = 0;
                    while (i < n2) {
                        if (op.getObjectParameter(i) instanceof ROI) {
                            return false;
                        }
                        ++i;
                    }
                    break;
                }
                if (!name.equalsIgnoreCase("Null") && !name.equalsIgnoreCase("Histogram")) {
                    return false;
                }
            }
            if ((n = planar.getNumSources()) >= 2) {
                return false;
            }
            if (n == 0) break;
            parent = planar.getSourceObject(0);
        }
        Object property = image.getProperty("extrema");
        if (!(property instanceof double[][])) {
            return false;
        }
        double[][] extrema = (double[][])property;
        if (extrema.length != 2) {
            return false;
        }
        int i = 0;
        while (i < scales.length) {
            double scale = scales[i];
            double offset = offsets[i];
            double minimum = extrema[1][i] * scale + offset;
            double maximum = extrema[0][i] * scale + offset;
            if (minimum > maximum) {
                double tmp = minimum;
                minimum = maximum;
                maximum = tmp;
            }
            if (!(minimum > 0.0) && !(maximum < 0.0)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public synchronized Collection<GridCoverage2D> dispose(boolean force) {
        int disposed;
        do {
            disposed = 0;
            Iterator<GridCoverage2D> it = this.views.values().iterator();
            while (it.hasNext()) {
                GridCoverage2D coverage = it.next();
                if (!coverage.disposeImage(force)) continue;
                it.remove();
                ++disposed;
            }
        } while (disposed != 0);
        return this.views.values();
    }
}

