/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio;

import java.awt.Dimension;
import javax.imageio.ImageReadParam;

public abstract class GeoToolsReadParams
extends ImageReadParam {
    protected ImageReadParam adaptee;
    protected Dimension[] preferredTileSizes = null;
    protected int tileWidth = -1;
    protected int tileHeight = -1;
    protected boolean tilingSet = false;

    public int getTileWidth() {
        if (!this.tilingSet) {
            throw new IllegalStateException("Tiling parameters not set!");
        }
        return this.tileWidth;
    }

    public int getTileHeight() {
        if (!this.tilingSet) {
            throw new IllegalStateException("Tiling parameters not set!");
        }
        return this.tileHeight;
    }

    public void setTiling(int tileWidth, int tileHeight) {
        if (tileWidth <= 0 || tileHeight <= 0) {
            throw new IllegalArgumentException("tile dimensions are non-positive!");
        }
        if (this.preferredTileSizes != null) {
            boolean ok = true;
            int length = this.preferredTileSizes.length;
            int i = 0;
            while (i < length) {
                Dimension min = this.preferredTileSizes[i];
                Dimension max = this.preferredTileSizes[i + 1];
                if (tileWidth < min.width || tileWidth > max.width || tileHeight < min.height || tileHeight > max.height) {
                    ok = false;
                    break;
                }
                i += 2;
            }
            if (!ok) {
                throw new IllegalArgumentException("Illegal tile size!");
            }
        }
        this.tilingSet = true;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
    }

    private static Dimension[] clonePreferredTileSizes(Dimension[] sizes) {
        if (sizes == null) {
            return null;
        }
        int length = sizes.length;
        Dimension[] temp = new Dimension[length];
        int i = 0;
        while (i < length) {
            temp[i] = new Dimension(sizes[i]);
            ++i;
        }
        return temp;
    }

    public Dimension[] getPreferredTileSizes() {
        return GeoToolsReadParams.clonePreferredTileSizes(this.preferredTileSizes);
    }
}

