/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.imageio.geotiff;

import java.awt.geom.AffineTransform;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoKeyEntry;
import org.geotools.coverage.grid.io.imageio.geotiff.GeoTiffConstants;
import org.geotools.coverage.grid.io.imageio.geotiff.PixelScale;
import org.geotools.coverage.grid.io.imageio.geotiff.TiePoint;
import org.geotools.resources.i18n.Errors;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class GeoTiffIIOMetadataDecoder {
    private IIOMetadataNode rootNode = null;
    private IIOMetadataNode geoKeyDir = null;
    private NodeList geoKeyDirEntries = null;
    private int geoKeyDirEntriesNum = 0;
    private IIOMetadataNode tiffTagsEntries;
    private int numTiffTasEntries;
    private int geoKeyDirVersion;
    private int geoKeyRevision;
    private int geoKeyMinorRevision;
    private int geoKeyDirTagsNum;
    private IIOMetadataNode geoKeyDoubleParams;
    private IIOMetadataNode geoKeyAsciiParams;

    public GeoTiffIIOMetadataDecoder(IIOMetadata imageMetadata) {
        if (imageMetadata == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"imageMetadata"));
        }
        this.rootNode = (IIOMetadataNode)imageMetadata.getAsTree(imageMetadata.getNativeMetadataFormatName());
        if (this.rootNode == null) {
            throw new IllegalArgumentException("Unable to retrieve metadata");
        }
        this.tiffTagsEntries = (IIOMetadataNode)this.rootNode.getFirstChild().getChildNodes();
        if (this.tiffTagsEntries == null) {
            throw new IllegalArgumentException("Unable to retrieve metadata");
        }
        this.numTiffTasEntries = this.tiffTagsEntries.getLength();
        this.geoKeyDir = this.getTiffField(34735);
        if (this.geoKeyDir != null) {
            this.geoKeyDirEntries = this.geoKeyDir.getFirstChild().getChildNodes();
            this.geoKeyDirVersion = this.getTiffShort(this.geoKeyDir, 0);
            this.geoKeyRevision = this.getTiffShort(this.geoKeyDir, 1);
            if (this.geoKeyRevision != 1) {
                this.geoKeyRevision = 1;
            }
            this.geoKeyMinorRevision = this.getTiffShort(this.geoKeyDir, 2);
            this.geoKeyDirTagsNum = this.getTiffShort(this.geoKeyDir, 3);
            this.geoKeyDirEntriesNum = this.geoKeyDirEntries.getLength();
        }
        this.geoKeyDoubleParams = this.getTiffField(34736);
        this.geoKeyAsciiParams = this.getTiffField(34737);
    }

    public int getGeoKeyDirectoryVersion() {
        return this.geoKeyDirVersion;
    }

    public int getGeoKeyRevision() {
        return this.geoKeyRevision;
    }

    public int getGeoKeyMinorRevision() {
        return this.geoKeyMinorRevision;
    }

    public int getNumGeoKeys() {
        return this.geoKeyDirTagsNum;
    }

    public String getGeoKey(int keyID) {
        Node sequence;
        GeoKeyEntry rec = this.getGeoKeyRecord(keyID);
        if (rec == null) {
            return null;
        }
        if (rec.getTiffTagLocation() == 0) {
            return String.valueOf(rec.getValueOffset());
        }
        IIOMetadataNode field = this.getTiffField(rec.getTiffTagLocation());
        if (field != null && (sequence = field.getFirstChild()) != null) {
            if (sequence.getNodeName().equals(GeoTiffConstants.GEOTIFF_ASCIIS_TAG)) {
                return this.getTiffAscii((IIOMetadataNode)sequence, rec.getValueOffset(), rec.getCount());
            }
            return this.getValueAttribute(sequence.getChildNodes().item(rec.getValueOffset()));
        }
        return null;
    }

    public GeoKeyEntry getGeoKeyRecord(int keyID) {
        int thisKeyID = 0;
        int i = 4;
        while (i < this.geoKeyDirEntriesNum) {
            thisKeyID = this.getIntValueAttribute(this.geoKeyDirEntries.item(i));
            if (thisKeyID == keyID) {
                return new GeoKeyEntry(thisKeyID, this.getIntValueAttribute(this.geoKeyDirEntries.item(i + 1)), this.getIntValueAttribute(this.geoKeyDirEntries.item(i + 2)), this.getIntValueAttribute(this.geoKeyDirEntries.item(i + 3)));
            }
            i += 4;
        }
        return null;
    }

    public GeoKeyEntry getGeoKeyRecordByIndex(int index) {
        if (this.geoKeyDir != null) {
            return new GeoKeyEntry(this.getIntValueAttribute(this.geoKeyDirEntries.item(index *= 4)), this.getIntValueAttribute(this.geoKeyDirEntries.item(index + 1)), this.getIntValueAttribute(this.geoKeyDirEntries.item(index + 2)), this.getIntValueAttribute(this.geoKeyDirEntries.item(index + 3)));
        }
        return null;
    }

    public PixelScale getModelPixelScales() {
        double[] pixScales = this.getTiffDoubles(this.getTiffField(33550));
        if (pixScales == null) {
            return null;
        }
        PixelScale retVal = new PixelScale();
        int i = 0;
        while (i < pixScales.length) {
            switch (i) {
                case 0: {
                    retVal.setScaleX(pixScales[i]);
                    break;
                }
                case 1: {
                    retVal.setScaleY(pixScales[i]);
                    break;
                }
                case 2: {
                    retVal.setScaleZ(pixScales[i]);
                }
            }
            ++i;
        }
        return retVal;
    }

    public TiePoint[] getModelTiePoints() {
        IIOMetadataNode node = this.getTiffField(33922);
        if (node == null) {
            return null;
        }
        double[] tiePoints = this.getTiffDoubles(node);
        if (tiePoints == null || tiePoints.length <= 0) {
            return null;
        }
        int numTiePoints = tiePoints.length / 6;
        TiePoint[] retVal = new TiePoint[numTiePoints];
        int initialIndex = 0;
        int i = 0;
        while (i < numTiePoints) {
            initialIndex = i * 6;
            retVal[i] = new TiePoint(tiePoints[initialIndex], tiePoints[initialIndex + 1], tiePoints[initialIndex + 2], tiePoints[initialIndex + 3], tiePoints[initialIndex + 4], tiePoints[initialIndex + 5]);
            ++i;
        }
        return retVal;
    }

    public double getNoData() {
        IIOMetadataNode noDataNode = this.getTiffField(42113);
        if (noDataNode == null) {
            return Double.NaN;
        }
        String noData = this.getTiffAscii(noDataNode);
        if (noData == null) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(noData);
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    public boolean hasTiePoints() {
        IIOMetadataNode node = this.getTiffField(33922);
        if (node == null) {
            return false;
        }
        double[] tiePoints = this.getTiffDoubles(node);
        return tiePoints != null && tiePoints.length > 0;
    }

    public boolean hasPixelScales() {
        double[] pixScales = this.getTiffDoubles(this.getTiffField(33550));
        if (pixScales == null) {
            return false;
        }
        int length = pixScales.length;
        int i = 0;
        while (i < length) {
            double tempVal = pixScales[i];
            if (Double.isInfinite(tempVal) || Double.isNaN(tempVal)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasNoData() {
        IIOMetadataNode noDataNode = this.getTiffField(42113);
        if (noDataNode == null) {
            return false;
        }
        String noData = this.getTiffAscii(noDataNode);
        return noData != null && noData.trim().length() != 0;
    }

    public String getAsciiTIFFTag(String tagID) {
        IIOMetadataNode metadataNode;
        String value = null;
        if (GeoTiffConstants.isNumeric(tagID) && (metadataNode = this.getTiffField(Integer.valueOf(tagID))) != null) {
            value = this.getTiffAscii(metadataNode);
        }
        return value;
    }

    public AffineTransform getModelTransformation() {
        IIOMetadataNode node = this.getTiffField(34264);
        if (node == null) {
            return null;
        }
        double[] modelTransformation = this.getTiffDoubles(node);
        if (modelTransformation == null) {
            return null;
        }
        AffineTransform transform = null;
        if (modelTransformation.length == 9) {
            transform = new AffineTransform(modelTransformation[0], modelTransformation[4], modelTransformation[1], modelTransformation[5], modelTransformation[6], modelTransformation[7]);
        } else if (modelTransformation.length == 16) {
            transform = new AffineTransform(modelTransformation[0], modelTransformation[4], modelTransformation[1], modelTransformation[5], modelTransformation[3], modelTransformation[7]);
        }
        return transform;
    }

    public boolean hasModelTrasformation() {
        IIOMetadataNode node = this.getTiffField(34264);
        if (node == null) {
            return false;
        }
        double[] modelTransformation = this.getTiffDoubles(node);
        return modelTransformation != null;
    }

    private String getValueAttribute(Node node) {
        return node.getAttributes().getNamedItem(GeoTiffConstants.VALUE_ATTRIBUTE).getNodeValue();
    }

    private int getIntValueAttribute(Node node) {
        return Integer.parseInt(this.getValueAttribute(node));
    }

    private IIOMetadataNode getTiffField(int tag) {
        if (tag == 34737 && this.geoKeyAsciiParams != null) {
            return this.geoKeyAsciiParams;
        }
        if (tag == 34736 && this.geoKeyDoubleParams != null) {
            return this.geoKeyDoubleParams;
        }
        if (tag == 34735 && this.geoKeyDir != null) {
            return this.geoKeyDir;
        }
        Node child = null;
        Node number = null;
        int i = 0;
        while (i < this.numTiffTasEntries) {
            child = this.tiffTagsEntries.item(i);
            number = child.getAttributes().getNamedItem(GeoTiffConstants.NUMBER_ATTRIBUTE);
            if (number != null && tag == Integer.parseInt(number.getNodeValue())) {
                return (IIOMetadataNode)child;
            }
            ++i;
        }
        return null;
    }

    private int getTiffShort(IIOMetadataNode tiffField, int index) {
        return this.getIntValueAttribute(((IIOMetadataNode)tiffField.getFirstChild()).getElementsByTagName(GeoTiffConstants.GEOTIFF_SHORT_TAG).item(index));
    }

    private double[] getTiffDoubles(IIOMetadataNode tiffField) {
        if (tiffField == null) {
            return null;
        }
        NodeList doubles = ((IIOMetadataNode)tiffField.getFirstChild()).getElementsByTagName(GeoTiffConstants.GEOTIFF_DOUBLE_TAG);
        int length = doubles.getLength();
        double[] result = new double[length];
        int i = 0;
        while (i < length) {
            result[i] = Double.parseDouble(this.getValueAttribute(doubles.item(i)));
            ++i;
        }
        return result;
    }

    private String getTiffAscii(IIOMetadataNode tiffField, int start, int length) {
        String valueAttribute = this.getValueAttribute(((IIOMetadataNode)tiffField.getFirstChild()).getElementsByTagName(GeoTiffConstants.GEOTIFF_ASCII_TAG).item(0));
        if (start == -1) {
            start = 0;
        }
        if (length == -1) {
            length = valueAttribute.length() + 1;
        }
        return valueAttribute.substring(start, start + length - 1);
    }

    private String getTiffAscii(IIOMetadataNode tiffField) {
        return this.getTiffAscii(tiffField, -1, -1);
    }

    public IIOMetadataNode getRootNode() {
        return this.rootNode;
    }

    public boolean hasGeoKey() {
        return this.geoKeyDir != null;
    }
}

