/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.util.InternationalString;

public class BaseScaleOperationJAI
extends OperationJAI {
    private static final long serialVersionUID = 1L;

    public BaseScaleOperationJAI(String operation) throws OperationNotFoundException {
        super(operation);
    }

    public BaseScaleOperationJAI(OperationDescriptor operation) {
        super(operation);
    }

    public BaseScaleOperationJAI(OperationDescriptor operation, ParameterDescriptorGroup descriptor) {
        super(operation, descriptor);
    }

    protected GridCoverage2D deriveGridCoverage(GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        ImageLayout layout;
        int indexOfBorderExtenderParam;
        int indexOfInterpolationParam;
        try {
            indexOfInterpolationParam = parameters.parameters.indexOfParam("Interpolation");
        }
        catch (IllegalArgumentException e) {
            indexOfInterpolationParam = -1;
        }
        try {
            indexOfBorderExtenderParam = parameters.parameters.indexOfParam("BorderExtender");
        }
        catch (IllegalArgumentException e) {
            indexOfBorderExtenderParam = -1;
        }
        Interpolation interpolation = (Interpolation)(indexOfInterpolationParam == -1 ? new InterpolationNearest() : parameters.parameters.getObjectParameter("Interpolation"));
        BorderExtender borderExtender = indexOfBorderExtenderParam != -1 ? parameters.parameters.getObjectParameter("BorderExtender") : BorderExtender.createInstance((int)1);
        GridCoverage2D sourceCoverage = sources[0];
        MathTransform2D sourceG2W = sourceCoverage.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT);
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        ViewType strategy = CoverageUtilities.preferredViewForOperation(sourceCoverage, interpolation, false, (RenderingHints)parameters.hints);
        switch (strategy) {
            case PHOTOGRAPHIC: {
                break;
            }
            case PACKED: 
            case GEOPHYSICS: {
                sourceCoverage = sourceCoverage.view(strategy);
                sourceImage = sourceCoverage.getRenderedImage();
            }
        }
        RenderingHints targetHints = ImageUtilities.getRenderingHints(sourceImage);
        if (targetHints == null) {
            targetHints = new RenderingHints(null);
        }
        if (parameters.hints != null) {
            targetHints.add((RenderingHints)parameters.hints);
        }
        if ((layout = (ImageLayout)targetHints.get(JAI.KEY_IMAGE_LAYOUT)) != null) {
            layout = (ImageLayout)layout.clone();
        } else {
            layout = new ImageLayout(sourceImage);
            layout.unsetTileLayout();
        }
        if ((layout.getValidMask() & 0xF0) == 0) {
            layout.setTileGridXOffset(layout.getMinX(sourceImage));
            layout.setTileGridYOffset(layout.getMinY(sourceImage));
            int width = layout.getWidth(sourceImage);
            int height = layout.getHeight(sourceImage);
            if (layout.getTileWidth(sourceImage) > width) {
                layout.setTileWidth(width);
            }
            if (layout.getTileHeight(sourceImage) > height) {
                layout.setTileHeight(height);
            }
        }
        targetHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        targetHints.put(JAI.KEY_BORDER_EXTENDER, borderExtender);
        if (strategy != ViewType.PHOTOGRAPHIC) {
            targetHints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        } else {
            targetHints.add(ImageUtilities.REPLACE_INDEX_COLOR_MODEL);
            layout.unsetValid(512);
            layout.unsetValid(256);
        }
        RenderedImage image = this.createRenderedImage(parameters.parameters, targetHints);
        PixelTranslation translationValue = PixelTranslation.getPixelTranslation((PixelOrientation)PixelOrientation.LOWER_RIGHT);
        LinearTransform translation = ProjectiveTransform.create((AffineTransform)AffineTransform.getTranslateInstance(translationValue.dx, translationValue.dy));
        LinearTransform scale = ProjectiveTransform.create((AffineTransform)AffineTransform.getScaleInstance((double)sourceImage.getWidth() / (1.0 * (double)image.getWidth()), (double)sourceImage.getHeight() / (1.0 * (double)image.getHeight())));
        MathTransform finalTransform = ConcatenatedTransform.create((MathTransform)translation, (MathTransform)ConcatenatedTransform.create((MathTransform)scale, (MathTransform)sourceG2W));
        InternationalString name = this.deriveName(sources, 0, parameters);
        Map<String, ?> properties = this.getProperties(image, parameters.crs, name, finalTransform, sources, parameters);
        GridCoverage2D result = BaseScaleOperationJAI.getFactory(parameters.hints).create((CharSequence)name, image, parameters.crs, finalTransform, strategy == ViewType.PHOTOGRAPHIC ? null : (GridSampleDimension[])sourceCoverage.getSampleDimensions().clone(), sources, properties);
        if (strategy == ViewType.GEOPHYSICS) {
            return result.view(ViewType.PACKED);
        }
        if (strategy == ViewType.PACKED) {
            return result.view(ViewType.GEOPHYSICS);
        }
        return result;
    }
}

