/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import org.geotools.resources.Classes;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Loggings;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.util.WeakValueHashMap;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeferredPlanarImage
extends PlanarImage
implements WritableRenderedImage,
TileObserver,
TileComputationListener {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.image");
    private static final int BOX_THICKNESS = 2;
    private static Map<Entry, DataBuffer> buffers;
    private static final int DELAY = 500;
    private final int delay;
    private final PlanarImage image = this.getSourceImage(0);
    private TileObserver[] observers;
    private transient TileRequest[] requests;
    private transient boolean[] waitings;
    private transient Raster[] pendings;

    public DeferredPlanarImage(RenderedImage source) {
        super(new ImageLayout(source), DeferredPlanarImage.toVector(source), null);
        this.image.addTileComputationListener((TileComputationListener)this);
        if (this.image instanceof WritableRenderedImage) {
            ((WritableRenderedImage)this.image).addTileObserver(this);
        }
        this.delay = (int)Math.min(500L * (long)(this.tileWidth * this.tileHeight) / 1000000L, 500L);
    }

    private static Vector<RenderedImage> toVector(RenderedImage image) {
        Vector<RenderedImage> vector = new Vector<RenderedImage>(1);
        vector.add(image);
        return vector;
    }

    private int getTileIndice(int tileX, int tileY) {
        assert (tileX >= this.getMinTileX() && tileX <= this.getMaxTileX()) : tileX;
        assert (tileY >= this.getMinTileY() && tileY <= this.getMaxTileY()) : tileY;
        return (tileY - this.getMinTileY()) * this.getNumXTiles() + (tileX - this.getMinTileX());
    }

    @Override
    public synchronized Raster getTile(int tileX, int tileY) {
        Raster raster;
        int tileIndice;
        TileRequest request;
        if (this.requests == null) {
            this.requests = new TileRequest[this.getNumXTiles() * this.getNumYTiles()];
        }
        if ((request = this.requests[tileIndice = this.getTileIndice(tileX, tileY)]) == null) {
            this.requests[tileIndice] = request = this.image.queueTiles(new Point[]{new Point(tileX, tileY)});
        }
        switch (request.getTileStatus(tileX, tileY)) {
            default: {
                LOGGER.warning("Unknow tile status");
            }
            case 2: 
            case 3: 
            case 4: {
                return this.image.getTile(tileX, tileY);
            }
            case 0: 
            case 1: 
        }
        if (this.pendings != null && this.pendings[tileIndice] != null) {
            return this.pendings[tileIndice];
        }
        if (this.delay != 0) {
            if (this.waitings == null) {
                this.waitings = new boolean[this.requests.length];
            }
            this.waitings[tileIndice] = true;
            try {
                this.wait(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.waitings[tileIndice] = false;
            switch (request.getTileStatus(tileX, tileY)) {
                default: {
                    return this.image.getTile(tileX, tileY);
                }
                case 0: 
                case 1: 
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LogRecord record = Loggings.format((Level)Level.FINER, (int)18, (Object)tileX, (Object)tileY);
            record.setSourceClassName(DeferredPlanarImage.class.getName());
            record.setSourceMethodName("getTile");
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        }
        if (this.pendings == null) {
            this.pendings = new Raster[this.requests.length];
        }
        Point origin = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        DataBuffer buffer = DeferredPlanarImage.getDefaultDataBuffer(this.sampleModel, this.colorModel);
        this.pendings[tileIndice] = raster = Raster.createRaster(this.sampleModel, buffer, origin);
        this.fireTileUpdate(tileX, tileY, true);
        return raster;
    }

    private static synchronized DataBuffer getDefaultDataBuffer(SampleModel sampleModel, ColorModel colorModel) {
        DataBuffer buffer;
        int fill = 0;
        int box = 0;
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel colors = (IndexColorModel)colorModel;
            fill = ColorUtilities.getTransparentPixel(colors);
            box = Math.min(sampleModel.getWidth(), sampleModel.getHeight()) >= 64 ? ColorUtilities.getColorIndex(colors, Color.DARK_GRAY, fill) : fill;
        }
        Entry entry = new Entry(sampleModel, fill, box);
        if (buffers == null) {
            buffers = new WeakValueHashMap();
        }
        if ((buffer = buffers.get(entry)) != null) {
            return buffer;
        }
        buffer = sampleModel.createDataBuffer();
        if (fill > 0) {
            int bank = buffer.getNumBanks();
            while (--bank >= 0) {
                DeferredPlanarImage.fill(buffer, bank, fill);
            }
        }
        if (box != fill && sampleModel.getNumBands() == 1) {
            int width = sampleModel.getWidth();
            int thickness = 2;
            int offset = (width + 1) * thickness;
            switch (buffer.getDataType()) {
                case 0: {
                    byte[] array = ((DataBufferByte)buffer).getData(0);
                    Arrays.fill(array, 0, offset, (byte)box);
                    Arrays.fill(array, array.length - offset, array.length, (byte)box);
                    thickness *= 2;
                    while ((offset += width) < array.length) {
                        Arrays.fill(array, offset - thickness, offset, (byte)box);
                    }
                    break;
                }
            }
        }
        buffers.put(entry, buffer);
        return buffer;
    }

    private static void fill(DataBuffer buffer, int bank, int value) {
        switch (buffer.getDataType()) {
            case 0: {
                Arrays.fill(((DataBufferByte)buffer).getData(bank), (byte)value);
                break;
            }
            case 2: {
                Arrays.fill(((DataBufferShort)buffer).getData(bank), (short)value);
                break;
            }
            case 1: {
                Arrays.fill(((DataBufferUShort)buffer).getData(bank), (short)value);
                break;
            }
            case 3: {
                Arrays.fill(((DataBufferInt)buffer).getData(bank), value);
                break;
            }
            case 4: {
                Arrays.fill(((DataBufferFloat)buffer).getData(bank), (float)value);
                break;
            }
            case 5: {
                Arrays.fill(((DataBufferDouble)buffer).getData(bank), (double)value);
                break;
            }
            default: {
                throw new RasterFormatException(String.valueOf(buffer));
            }
        }
    }

    private void fireTileUpdate(int tileX, int tileY, boolean willBeWritable) {
        TileObserver[] observers = this.observers;
        if (observers != null) {
            int length = observers.length;
            int i = 0;
            while (i < length) {
                try {
                    observers[i].tileUpdate(this, tileX, tileY, willBeWritable);
                }
                catch (RuntimeException cause) {
                    String message = cause.getLocalizedMessage();
                    if (message == null) {
                        message = Classes.getShortClassName((Object)cause);
                    }
                    LogRecord record = new LogRecord(Level.WARNING, message);
                    record.setSourceClassName(observers[i].getClass().getName());
                    record.setSourceMethodName("tileUpdate");
                    record.setThrown(cause);
                    record.setLoggerName(LOGGER.getName());
                    LOGGER.log(record);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tileComputed(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Raster tile) {
        DeferredPlanarImage deferredPlanarImage = this;
        synchronized (deferredPlanarImage) {
            int tileIndice = this.getTileIndice(tileX, tileY);
            if (this.waitings != null && this.waitings[tileIndice]) {
                this.notify();
            }
            if (this.pendings == null || this.pendings[tileIndice] == null) {
                return;
            }
            this.pendings[tileIndice] = null;
        }
        this.fireTileUpdate(tileX, tileY, false);
    }

    public void tileCancelled(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY) {
    }

    public void tileComputationFailure(Object eventSource, TileRequest[] requests, PlanarImage image, int tileX, int tileY, Throwable cause) {
        LogRecord record = new LogRecord(Level.WARNING, cause.getLocalizedMessage());
        record.setSourceClassName(DeferredPlanarImage.class.getName());
        record.setSourceMethodName("getTile");
        record.setThrown(cause);
        record.setLoggerName(LOGGER.getName());
        LOGGER.log(record);
    }

    @Override
    public void tileUpdate(WritableRenderedImage source, int tileX, int tileY, boolean willBeWritable) {
        this.fireTileUpdate(tileX, tileY, willBeWritable);
    }

    @Override
    public synchronized void addTileObserver(TileObserver observer) {
        if (observer != null) {
            if (this.observers == null) {
                this.observers = new TileObserver[]{observer};
            } else {
                int length = this.observers.length;
                this.observers = (TileObserver[])XArray.resize((Object[])this.observers, (int)(length + 1));
                this.observers[length] = observer;
            }
        }
    }

    @Override
    public synchronized void removeTileObserver(TileObserver observer) {
        if (this.observers != null) {
            int i = this.observers.length;
            while (--i >= 0) {
                if (this.observers[i] != observer) continue;
                this.observers = (TileObserver[])XArray.remove((Object[])this.observers, (int)i, (int)1);
                break;
            }
        }
    }

    @Override
    public WritableRaster getWritableTile(int tileX, int tileY) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseWritableTile(int tileX, int tileY) {
        throw new IllegalStateException();
    }

    @Override
    public boolean hasTileWriters() {
        Raster[] pendings = this.pendings;
        if (pendings != null) {
            int length = pendings.length;
            int i = 0;
            while (i < length) {
                if (pendings[i] != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean isTileWritable(int tileX, int tileY) {
        Raster[] pendings = this.pendings;
        return pendings != null && pendings[this.getTileIndice(tileX, tileY)] != null;
    }

    @Override
    public synchronized Point[] getWritableTileIndices() {
        Object[] indices = null;
        if (this.pendings != null) {
            int count = 0;
            int minX = this.getMinTileX();
            int minY = this.getMinTileY();
            int numX = this.getNumXTiles();
            int length = this.pendings.length;
            int i = 0;
            while (i < length) {
                if (this.pendings[i] != null) {
                    if (indices == null) {
                        indices = new Point[length - i];
                    }
                    int x = i % numX + minX;
                    int y = i / numX + minY;
                    assert (this.getTileIndice(x, y) == i) : i;
                    indices[count++] = new Point(x, y);
                }
                ++i;
            }
            if (indices != null) {
                indices = (Point[])XArray.resize((Object[])indices, (int)count);
            }
        }
        return indices;
    }

    @Override
    public void setData(Raster r) {
        throw new UnsupportedOperationException();
    }

    public synchronized void dispose() {
        if (this.image instanceof WritableRenderedImage) {
            ((WritableRenderedImage)this.image).removeTileObserver(this);
        }
        this.image.removeTileComputationListener((TileComputationListener)this);
        this.requests = null;
        this.waitings = null;
        this.pendings = null;
        super.dispose();
        this.image.dispose();
    }

    private static final class Entry {
        public final SampleModel model;
        public final int fill;
        public final int box;

        public Entry(SampleModel model, int fill, int box) {
            this.model = model;
            this.fill = fill;
            this.box = box;
        }

        public int hashCode() {
            return this.model.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                Entry that = (Entry)object;
                return this.model.equals(that.model) && this.fill == that.fill && this.box == that.box;
            }
            return false;
        }
    }
}

