/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.io.Serializable;
import java.util.EventListener;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.swing.event.EventListenerList;
import org.geotools.resources.XArray;

public class IIOListeners
implements Serializable {
    private static final long serialVersionUID = 6944397966242054247L;
    private static final Class[] READ = new Class[]{IIOReadProgressListener.class, IIOReadWarningListener.class};
    private final EventListenerList listeners = new EventListenerList();

    public void addIIOReadProgressListener(IIOReadProgressListener listener) {
        this.listeners.add(IIOReadProgressListener.class, listener);
    }

    public void removeIIOReadProgressListener(IIOReadProgressListener listener) {
        this.listeners.remove(IIOReadProgressListener.class, listener);
    }

    public void addIIOReadWarningListener(IIOReadWarningListener listener) {
        this.listeners.add(IIOReadWarningListener.class, listener);
    }

    public void removeIIOReadWarningListener(IIOReadWarningListener listener) {
        this.listeners.remove(IIOReadWarningListener.class, listener);
    }

    public EventListener[] getReadListeners() {
        return this.getListeners(READ);
    }

    private EventListener[] getListeners(Class[] categories) {
        int count = 0;
        Object[] list = this.listeners.getListenerList();
        Object[] listeners = new EventListener[list.length / 2];
        int i = 0;
        while (i < list.length) {
            Class type = (Class)list[i];
            int j = categories.length;
            block1: while (--j >= 0) {
                if (!type.equals(categories[i])) continue;
                EventListener candidate = (EventListener)list[i + 1];
                int k = count;
                while (--k >= 0) {
                    if (listeners[k] == candidate) break block1;
                }
                listeners[count++] = candidate;
                break;
            }
            i += 2;
        }
        return (EventListener[])XArray.resize((Object[])listeners, (int)count);
    }

    public void addListenersTo(ImageReader reader) {
        Object[] listeners = this.listeners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            EventListener l;
            Object classe = listeners[i++];
            Object listener = listeners[i++];
            if (IIOReadProgressListener.class.equals(classe)) {
                l = (IIOReadProgressListener)listener;
                reader.removeIIOReadProgressListener((IIOReadProgressListener)l);
                reader.addIIOReadProgressListener((IIOReadProgressListener)l);
                continue;
            }
            if (!IIOReadWarningListener.class.equals(classe)) continue;
            l = (IIOReadWarningListener)listener;
            reader.removeIIOReadWarningListener((IIOReadWarningListener)l);
            reader.addIIOReadWarningListener((IIOReadWarningListener)l);
        }
    }
}

