/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources.image;

import com.sun.media.imageioimpl.common.PackageUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.geotools.image.ImageWorker;
import org.geotools.image.io.ImageIOExt;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageUtilities {
    private static final boolean mediaLibAvailable;
    public static final RenderingHints DONT_REPLACE_INDEX_COLOR_MODEL;
    public static final RenderingHints REPLACE_INDEX_COLOR_MODEL;
    public static final RenderingHints NN_INTERPOLATION_HINT;
    public static final RenderingHints NOCACHE_HINT;
    public static final RenderingHints EXTEND_BORDER_BY_COPYING;
    public static final RenderingHints EXTEND_BORDER_BY_REFLECT;
    private static final Dimension GEOTOOLS_DEFAULT_TILE_SIZE;
    private static final int GEOTOOLS_MIN_TILE_SIZE = 256;
    private static final int STRIPE_SIZE = 64;
    public static final String[] INTERPOLATION_NAMES;
    public static final int[] INTERPOLATION_TYPES;
    public static final BorderExtender DEFAULT_BORDER_EXTENDER;
    public static final RenderingHints BORDER_EXTENDER_HINTS;
    public static final String DIRECT_KAKADU_PLUGIN = "it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReader";

    static {
        boolean mediaLib = false;
        Class<?> mediaLibImage = null;
        try {
            mediaLibImage = Class.forName("com.sun.medialib.mlib.Image");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        boolean bl = mediaLib = mediaLibImage != null;
        if (mediaLib) {
            try {
                boolean bl2 = mediaLib = !Boolean.getBoolean("com.sun.media.jai.disableMediaLib");
                if (mediaLib) {
                    final Class<?> mImage = mediaLibImage;
                    mediaLib = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            try {
                                Class[] params = new Class[]{};
                                Method method = mImage.getDeclaredMethod("isAvailable", params);
                                Object[] paramsObj = new Object[]{};
                                Object o = mImage.newInstance();
                                return (Boolean)method.invoke(o, paramsObj);
                            }
                            catch (Throwable e) {
                                return false;
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                mediaLib = false;
            }
        }
        mediaLibAvailable = mediaLib;
        DONT_REPLACE_INDEX_COLOR_MODEL = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        REPLACE_INDEX_COLOR_MODEL = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
        NN_INTERPOLATION_HINT = new RenderingHints(JAI.KEY_INTERPOLATION, Interpolation.getInstance((int)0));
        NOCACHE_HINT = new RenderingHints(JAI.KEY_TILE_CACHE, null);
        EXTEND_BORDER_BY_COPYING = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        EXTEND_BORDER_BY_REFLECT = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)2));
        GEOTOOLS_DEFAULT_TILE_SIZE = new Dimension(512, 512);
        INTERPOLATION_NAMES = new String[]{"Nearest", "NearestNeighbor", "Bilinear", "Bicubic", "Bicubic2"};
        int[] nArray = new int[5];
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        INTERPOLATION_TYPES = nArray;
        DEFAULT_BORDER_EXTENDER = BorderExtender.createInstance((int)1);
        BORDER_EXTENDER_HINTS = new RenderingHints(JAI.KEY_BORDER_EXTENDER, DEFAULT_BORDER_EXTENDER);
    }

    private ImageUtilities() {
    }

    public static ImageLayout getImageLayout(RenderedImage image) {
        return ImageUtilities.getImageLayout(image, true);
    }

    private static ImageLayout getImageLayout(RenderedImage image, boolean initToImage) {
        ImageLayout layout;
        if (image == null) {
            return null;
        }
        ImageLayout imageLayout = layout = initToImage ? new ImageLayout(image) : null;
        if (!(image.getNumXTiles() != 1 && image.getTileWidth() > 64 || image.getNumYTiles() != 1 && image.getTileHeight() > 64)) {
            int s;
            Dimension defaultSize;
            if (layout != null) {
                layout = layout.unsetTileLayout();
            }
            if ((defaultSize = JAI.getDefaultTileSize()) == null) {
                defaultSize = GEOTOOLS_DEFAULT_TILE_SIZE;
            }
            if ((s = ImageUtilities.toTileSize(image.getWidth(), defaultSize.width)) != 0) {
                if (layout == null) {
                    layout = new ImageLayout();
                }
                layout = layout.setTileWidth(s);
                layout.setTileGridXOffset(image.getMinX());
            }
            if ((s = ImageUtilities.toTileSize(image.getHeight(), defaultSize.height)) != 0) {
                if (layout == null) {
                    layout = new ImageLayout();
                }
                layout = layout.setTileHeight(s);
                layout.setTileGridYOffset(image.getMinY());
            }
        }
        return layout;
    }

    public static RenderingHints getRenderingHints(RenderedImage image) {
        ImageLayout layout = ImageUtilities.getImageLayout(image, false);
        return layout != null ? new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout) : null;
    }

    public static Dimension toTileSize(Dimension size) {
        int s;
        Dimension defaultSize = JAI.getDefaultTileSize();
        if (defaultSize == null) {
            defaultSize = GEOTOOLS_DEFAULT_TILE_SIZE;
        }
        if ((s = ImageUtilities.toTileSize(size.width, defaultSize.width)) != 0) {
            size.width = s;
        }
        if ((s = ImageUtilities.toTileSize(size.height, defaultSize.height)) != 0) {
            size.height = s;
        }
        return size;
    }

    private static int toTileSize(int imageSize, int tileSize) {
        int MAX_TILE_SIZE = Math.min(tileSize * 2, imageSize);
        int stop = Math.max(tileSize - 256, MAX_TILE_SIZE - tileSize);
        int sopt = 0;
        int rmax = 0;
        int i = 0;
        while (i <= stop) {
            int r;
            int s = tileSize + i;
            if (s <= MAX_TILE_SIZE) {
                r = imageSize % s;
                if (r == 0) {
                    return s;
                }
                if (r > rmax) {
                    rmax = r;
                    sopt = s;
                }
            }
            if ((s = tileSize - i) >= 256) {
                r = imageSize % s;
                if (r == 0) {
                    return s;
                }
                if (r > rmax) {
                    rmax = r;
                    sopt = s;
                }
            }
            ++i;
        }
        return rmax >= tileSize - tileSize / 4 ? sopt : 0;
    }

    public static ImageLayout createIntersection(ImageLayout layout, List<RenderedImage> sources) {
        int n;
        ImageLayout result = layout;
        if (result == null) {
            result = new ImageLayout();
        }
        if ((n = sources.size()) != 0) {
            RenderedImage source = sources.get(0);
            int minXL = result.getMinX(source);
            int minYL = result.getMinY(source);
            int maxXL = result.getWidth(source) + minXL;
            int maxYL = result.getHeight(source) + minYL;
            int i = 0;
            while (i < n) {
                source = sources.get(i);
                int minX = source.getMinX();
                int minY = source.getMinY();
                int maxX = source.getWidth() + minX;
                int maxY = source.getHeight() + minY;
                int mask = 0;
                if (minXL < minX) {
                    mask |= 5;
                }
                if (minYL < minY) {
                    mask |= 0xA;
                }
                if (maxXL > maxX) {
                    mask |= 4;
                }
                if (maxYL > maxY) {
                    mask |= 8;
                }
                if (mask != 0) {
                    if (layout == result) {
                        result = (ImageLayout)layout.clone();
                    }
                    if ((mask & 1) != 0) {
                        minXL = minX;
                        result.setMinX(minXL);
                    }
                    if ((mask & 2) != 0) {
                        minYL = minY;
                        result.setMinY(minYL);
                    }
                    if ((mask & 4) != 0) {
                        maxXL = maxX;
                        result.setWidth(maxXL - minXL);
                    }
                    if ((mask & 8) != 0) {
                        maxYL = maxY;
                        result.setHeight(maxYL - minYL);
                    }
                }
                ++i;
            }
            if (result != layout) {
                int newSize;
                int oldSize;
                source = sources.get(0);
                if (result.isValid(64) && (oldSize = result.getTileWidth(source)) != (newSize = ImageUtilities.toTileSize(result.getWidth(source), oldSize))) {
                    result.setTileWidth(newSize);
                }
                if (result.isValid(128) && (oldSize = result.getTileHeight(source)) != (newSize = ImageUtilities.toTileSize(result.getHeight(source), oldSize))) {
                    result.setTileHeight(newSize);
                }
            }
        }
        return result;
    }

    public static Interpolation toInterpolation(Object type) throws IllegalArgumentException {
        if (type instanceof Interpolation) {
            return (Interpolation)type;
        }
        if (type instanceof CharSequence) {
            String name = type.toString();
            int length = INTERPOLATION_NAMES.length;
            int i = 0;
            while (i < length) {
                if (INTERPOLATION_NAMES[i].equalsIgnoreCase(name)) {
                    return Interpolation.getInstance((int)INTERPOLATION_TYPES[i]);
                }
                ++i;
            }
        }
        throw new IllegalArgumentException(Errors.format((int)183, (Object)type));
    }

    public static String getInterpolationName(Interpolation interp) {
        if (interp == null) {
            interp = Interpolation.getInstance((int)0);
        }
        String prefix = "Interpolation";
        Class<?> classe = interp.getClass();
        while (classe != null) {
            String name = Classes.getShortName(classe);
            int index = name.lastIndexOf("Interpolation");
            if (index >= 0) {
                return name.substring(index + "Interpolation".length());
            }
            classe = classe.getSuperclass();
        }
        return Classes.getShortClassName((Object)interp);
    }

    public static synchronized <T extends ImageReaderWriterSpi> void allowNativeCodec(String format, Class<T> category, boolean allowed) {
        ImageIOExt.allowNativeCodec(format, category, allowed);
    }

    public static RenderedOp tileImage(RenderedOp image) throws IOException {
        ImageReader reader;
        int width = image.getWidth();
        int height = image.getHeight();
        int tileHeight = image.getTileHeight();
        int tileWidth = image.getTileWidth();
        boolean needToTile = false;
        Object o = image.getProperty("JAI.ImageReader");
        if (o instanceof ImageReader && !(reader = (ImageReader)o).isImageTiled(0)) {
            needToTile = true;
        }
        if (!needToTile && tileWidth == width && tileHeight <= height) {
            needToTile = true;
        }
        if (needToTile) {
            ImageLayout layout = ImageUtilities.getImageLayout((RenderedImage)image);
            layout.unsetValid(768);
            RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            ParameterBlockJAI pbjFormat = new ParameterBlockJAI("Format");
            pbjFormat.addSource((Object)image);
            pbjFormat.setParameter("dataType", image.getSampleModel().getDataType());
            return JAI.create((String)"Format", (ParameterBlock)pbjFormat, (RenderingHints)hints);
        }
        return image;
    }

    public static void fill(WritableRenderedImage image, Number value) {
        int y = image.getMinTileY();
        int ny = image.getNumYTiles();
        while (--ny >= 0) {
            int x = image.getMinTileX();
            int nx = image.getNumXTiles();
            while (--nx >= 0) {
                WritableRaster raster = image.getWritableTile(x, y);
                try {
                    ImageUtilities.fill(raster.getDataBuffer(), value);
                }
                finally {
                    image.releaseWritableTile(x, y);
                }
            }
        }
    }

    private static void fill(DataBuffer buffer, Number value) {
        int[] offsets = buffer.getOffsets();
        int size = buffer.getSize();
        if (buffer instanceof DataBufferByte) {
            DataBufferByte data = (DataBufferByte)buffer;
            byte n = value.byteValue();
            int i = 0;
            while (i < offsets.length) {
                int offset = offsets[i];
                Arrays.fill(data.getData(i), offset, offset + size, n);
                ++i;
            }
        } else if (buffer instanceof DataBufferShort) {
            DataBufferShort data = (DataBufferShort)buffer;
            short n = value.shortValue();
            int i = 0;
            while (i < offsets.length) {
                int offset = offsets[i];
                Arrays.fill(data.getData(i), offset, offset + size, n);
                ++i;
            }
        } else if (buffer instanceof DataBufferUShort) {
            DataBufferUShort data = (DataBufferUShort)buffer;
            short n = value.shortValue();
            int i = 0;
            while (i < offsets.length) {
                int offset = offsets[i];
                Arrays.fill(data.getData(i), offset, offset + size, n);
                ++i;
            }
        } else if (buffer instanceof DataBufferInt) {
            DataBufferInt data = (DataBufferInt)buffer;
            int n = value.intValue();
            int i = 0;
            while (i < offsets.length) {
                int offset = offsets[i];
                Arrays.fill(data.getData(i), offset, offset + size, n);
                ++i;
            }
        } else if (buffer instanceof DataBufferFloat) {
            DataBufferFloat data = (DataBufferFloat)buffer;
            float n = value.floatValue();
            int i = 0;
            while (i < offsets.length) {
                int offset = offsets[i];
                Arrays.fill(data.getData(i), offset, offset + size, n);
                ++i;
            }
        } else if (buffer instanceof DataBufferDouble) {
            DataBufferDouble data = (DataBufferDouble)buffer;
            double n = value.doubleValue();
            int i = 0;
            while (i < offsets.length) {
                int offset = offsets[i];
                Arrays.fill(data.getData(i), offset, offset + size, n);
                ++i;
            }
        } else {
            throw new IllegalArgumentException(Errors.format((int)198));
        }
    }

    public static boolean isMediaLibAvailable() {
        return mediaLibAvailable;
    }

    public static boolean isCLibAvailable() {
        return PackageUtil.isCodecLibAvailable();
    }

    public static final ImageInputStreamSpi getImageInputStreamSPI(Object input) {
        return ImageIOExt.getImageInputStreamSPI(input);
    }

    public static final ImageInputStreamSpi getImageInputStreamSPI(Object input, boolean streamCreationCheck) {
        return ImageIOExt.getImageInputStreamSPI(input, streamCreationCheck);
    }

    public static void disposePlanarImageChain(PlanarImage pi) {
        Utilities.ensureNonNull((String)"PlanarImage", (Object)pi);
        ImageUtilities.disposePlanarImageChain(pi, new HashSet<PlanarImage>());
    }

    private static void disposePlanarImageChain(PlanarImage pi, HashSet<PlanarImage> visited) {
        Vector sinks = pi.getSinks();
        if (sinks != null) {
            for (Object sink : sinks) {
                if (sink instanceof PlanarImage && !visited.contains(sink)) {
                    ImageUtilities.disposePlanarImageChain((PlanarImage)sink, visited);
                    continue;
                }
                if (!(sink instanceof BufferedImage)) continue;
                ((BufferedImage)sink).flush();
            }
        }
        pi.dispose();
        visited.add(pi);
        Vector sources = pi.getSources();
        if (sources != null) {
            for (Object child : sources) {
                if (child instanceof PlanarImage && !visited.contains(child)) {
                    ImageUtilities.disposePlanarImageChain((PlanarImage)child, visited);
                    continue;
                }
                if (!(child instanceof BufferedImage)) continue;
                ((BufferedImage)child).flush();
            }
        }
        if (pi instanceof RenderedOp) {
            RenderedOp op = (RenderedOp)pi;
            for (Object param : op.getParameterBlock().getParameters()) {
                if (!(param instanceof ImageInputStream)) continue;
                ImageInputStream iis = (ImageInputStream)param;
                try {
                    iis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static RenderedImage maskColor(Color transparentColor, RenderedImage image) throws IllegalStateException {
        Utilities.ensureNonNull((String)"image", (Object)image);
        if (transparentColor == null) {
            return image;
        }
        ImageWorker w = new ImageWorker(image);
        if (image.getSampleModel() instanceof MultiPixelPackedSampleModel) {
            w.forceComponentColorModel();
        }
        return w.makeColorTransparent(transparentColor).getRenderedImage();
    }
}

