/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.test;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.geotools.image.ImageWorker;
import org.geotools.image.test.CompareImageDialog;
import org.geotools.image.test.PerceptualDiff;
import org.geotools.image.test.ReferenceImageDialog;
import org.geotools.util.logging.Logging;

public class ImageAssert {
    static final boolean INTERACTIVE = Boolean.getBoolean("org.geotools.image.test.interactive");
    static final Logger LOGGER = Logging.getLogger(Logger.class);

    public static void assertEquals(File expectedFile, RenderedImage actualImage, int threshold) {
        ImageAssert.assertEquals(expectedFile, actualImage, threshold, true);
    }

    public static void assertEquals(RenderedImage expectedImage, RenderedImage actualImage, int threshold) {
        File expectedFile = new File("target/expected.png");
        try {
            ImageIO.write(expectedImage, "PNG", expectedFile);
            ImageAssert.assertEquals(expectedFile, actualImage, threshold, false);
        }
        catch (IOException e) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Failed to write the image to disk"))).initCause(e);
        }
        finally {
            expectedFile.delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void assertEquals(File expectedFile, RenderedImage actualImage, int threshold, boolean actualReferenceFile) {
        if (!expectedFile.exists()) {
            boolean useAsReference;
            boolean bl = useAsReference = actualReferenceFile && INTERACTIVE && ReferenceImageDialog.show(ImageAssert.realignImage(actualImage));
            if (!useAsReference) throw new AssertionError((Object)("Reference image is missing: " + expectedFile));
            try {
                String format = ImageAssert.getFormat(expectedFile);
                new ImageWorker(actualImage).writePNG(expectedFile, "FILTERED", 0.9f, false, false);
                return;
            }
            catch (IOException e) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Failed to write the image to disk"))).initCause(e);
            }
        }
        File actualFile = new File("target/actual.png");
        try {
            ImageIO.write(actualImage, "PNG", actualFile);
            PerceptualDiff.Difference difference = PerceptualDiff.compareImages(expectedFile, actualFile, threshold);
            if (difference.imagesDifferent) {
                boolean overwrite = false;
                if (INTERACTIVE) {
                    BufferedImage expectedImage = ImageIO.read(expectedFile);
                    overwrite = CompareImageDialog.show(ImageAssert.realignImage(expectedImage), ImageAssert.realignImage(actualImage), actualReferenceFile);
                }
                if (!overwrite) throw new AssertionError((Object)("Images are visibly different, PerceptualDiff output is: " + difference.output));
                ImageIO.write(actualImage, "PNG", expectedFile);
                return;
            } else {
                LOGGER.info("Images are equals, PerceptualDiff output is: " + difference.output);
            }
            return;
        }
        catch (IOException e) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Failed to write the image to disk"))).initCause(e);
        }
        finally {
            actualFile.delete();
        }
    }

    static String getFormat(File expectedImage) {
        String loName = expectedImage.getName().toLowerCase();
        if (loName.endsWith(".png")) {
            return "PNG";
        }
        if (loName.endsWith(".tif") || loName.endsWith(".tiff")) {
            return "TIFF";
        }
        throw new IllegalArgumentException("Expected image file should be a png or a tiff");
    }

    static final RenderedImage realignImage(RenderedImage image) {
        if (image.getMinX() > 0 || image.getMinY() > 0) {
            return new BufferedImage(image.getColorModel(), ((WritableRaster)image.getData()).createWritableTranslatedChild(0, 0), image.getColorModel().isAlphaPremultiplied(), null);
        }
        return image;
    }
}

