/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.io.AbstractGridCoverageReader;
import org.geotools.factory.Hints;
import org.geotools.image.io.text.TextMetadataParser;
import org.opengis.coverage.grid.GridRange;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ExoreferencedGridCoverageReader
extends AbstractGridCoverageReader {
    protected final TextMetadataParser metadata;
    private final String extension;

    public ExoreferencedGridCoverageReader(Hints hints, String formatName, TextMetadataParser parser) {
        this(hints, formatName, formatName, parser);
    }

    public ExoreferencedGridCoverageReader(Hints hints, String formatName, String extension, TextMetadataParser parser) {
        super(hints, formatName);
        this.metadata = parser;
        if (parser == null) {
            throw new IllegalArgumentException();
        }
        this.extension = extension;
    }

    public synchronized void reset() throws IOException {
        this.metadata.clear();
        super.reset();
    }

    public synchronized void setLocale(Locale locale) {
        super.setLocale(locale);
    }

    public synchronized void setInput(Object input, boolean seekForwardOnly) throws IOException {
        if (!(input instanceof File)) {
            if (input instanceof URL) {
                URL url = (URL)input;
                this.metadata.clear();
                this.metadata.load(url);
                throw new UnsupportedOperationException("URL support not yet implemented");
            }
            throw new IllegalArgumentException(this.getString(134));
        }
        File file = (File)input;
        this.metadata.clear();
        this.metadata.load(file);
        input = new File(file.getParent(), this.toImageFileName(file.getName()));
        super.setInput(input, seekForwardOnly);
    }

    protected String toImageFileName(String filename) {
        int ext = filename.lastIndexOf(46);
        if (ext < 0) {
            ext = filename.length();
        }
        return filename.substring(0, ext) + '.' + this.extension;
    }

    public synchronized CoordinateReferenceSystem getCoordinateReferenceSystem(int index) throws IOException {
        this.checkImageIndex(index);
        return null;
    }

    public synchronized Envelope getEnvelope(int index) throws IOException {
        this.checkImageIndex(index);
        return null;
    }

    public synchronized GridRange getGridRange(int index) throws IOException {
        this.checkImageIndex(index);
        return null;
    }

    public synchronized GridSampleDimension[] getSampleDimensions(int index) throws IOException {
        this.checkImageIndex(index);
        return null;
    }
}

