/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.metadata;

import java.util.ArrayList;
import java.util.List;
import org.geotools.image.io.metadata.Axis;
import org.geotools.image.io.metadata.Band;
import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.image.io.metadata.MetadataAccessor;
import org.geotools.image.io.metadata.Parameter;
import org.geotools.resources.i18n.Errors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ChildList<T extends MetadataAccessor>
extends MetadataAccessor {
    private final List<T> childs;

    protected ChildList(GeographicMetadata metadata, String parentPath, String childPath) {
        super(metadata, parentPath, childPath);
        int count = this.childCount();
        this.childs = new ArrayList<T>(count != 0 ? count : 4);
    }

    public T getChild(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.childCount()) {
            throw new IndexOutOfBoundsException(Errors.format((int)this.outOfBounds(), (Object)index));
        }
        while (this.childs.size() <= index) {
            this.childs.add(null);
        }
        MetadataAccessor candidate = (MetadataAccessor)this.childs.get(index);
        if (candidate == null) {
            candidate = this.newChild(index);
            this.childs.set(index, candidate);
        }
        return (T)candidate;
    }

    public T addChild() {
        int index = this.appendChild();
        T candidate = this.newChild(index);
        assert (index == this.childs.size());
        this.childs.add(candidate);
        return candidate;
    }

    protected abstract T newChild(int var1);

    int outOfBounds() {
        return 79;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Parameters
    extends ChildList<Parameter> {
        public Parameters(GeographicMetadata metadata) {
            super(metadata, "rectifiedGridDomain/crs/projection", "parameter");
        }

        @Override
        protected Parameter newChild(int index) {
            return new Parameter(this, index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Axes
    extends ChildList<Axis> {
        public Axes(GeographicMetadata metadata) {
            super(metadata, "rectifiedGridDomain/crs/cs", "axis");
        }

        @Override
        protected Axis newChild(int index) {
            return new Axis(this, index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Bands
    extends ChildList<Band> {
        public Bands(GeographicMetadata metadata) {
            super(metadata, "rectifiedGridDomain/rangeSet/bands", "band");
        }

        @Override
        protected Band newChild(int index) {
            return new Band(this, index);
        }

        @Override
        int outOfBounds() {
            return 7;
        }
    }
}

