/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.coverage.grid.ImageGeometry;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.image.io.mosaic.TranslatedTransform;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RegionCalculator {
    private static final double EPS = 1.0E-10;
    private final int xLocation;
    private final int yLocation;
    private final Map<AffineTransform, Tile> tiles;
    private static final Comparator<AffineTransform> X_COMPARATOR = new Comparator<AffineTransform>(){

        @Override
        public int compare(AffineTransform tr1, AffineTransform tr2) {
            return Double.compare(XAffineTransform.getScaleX0((AffineTransform)tr1), XAffineTransform.getScaleX0((AffineTransform)tr2));
        }
    };
    private static final Comparator<AffineTransform> Y_COMPARATOR = new Comparator<AffineTransform>(){

        @Override
        public int compare(AffineTransform tr1, AffineTransform tr2) {
            return Double.compare(XAffineTransform.getScaleY0((AffineTransform)tr1), XAffineTransform.getScaleY0((AffineTransform)tr2));
        }
    };

    public RegionCalculator() {
        this(null);
    }

    public RegionCalculator(Point location) {
        if (location != null) {
            this.xLocation = location.x;
            this.yLocation = location.y;
        } else {
            this.yLocation = 0;
            this.xLocation = 0;
        }
        this.tiles = new IdentityHashMap<AffineTransform, Tile>();
    }

    public Point getLocation() {
        return new Point(this.xLocation, this.yLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Tile tile) {
        AffineTransform gridToCRS;
        Tile tile2 = tile;
        synchronized (tile2) {
            gridToCRS = tile.getPendingGridToCRS(true);
        }
        if (gridToCRS == null) {
            return false;
        }
        if (this.tiles.put(gridToCRS, tile) != null) {
            throw new AssertionError();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ImageGeometry, Tile[]> tiles() {
        HashMap<ImageGeometry, Tile[]> results = new HashMap<ImageGeometry, Tile[]>(4);
        for (Map<AffineTransform, Dimension> tilesAT : RegionCalculator.computePyramidLevels(this.tiles.keySet())) {
            AffineTransform toGrid;
            AffineTransform reference = null;
            double xMin = Double.POSITIVE_INFINITY;
            double xLead = Double.POSITIVE_INFINITY;
            double yMin = Double.POSITIVE_INFINITY;
            double scale = Double.POSITIVE_INFINITY;
            for (AffineTransform tr : tilesAT.keySet()) {
                double s = XAffineTransform.getScale((AffineTransform)tr);
                double y = tr.getTranslateY();
                if (tr.getScaleY() < 0.0 || tr.getShearY() < 0.0) {
                    y = -y;
                }
                double x = tr.getTranslateX();
                if (tr.getScaleX() < 0.0 || tr.getShearX() < 0.0) {
                    x = -x;
                }
                if (!(Math.abs(s - scale) <= 1.0E-10)) {
                    if (!(s < scale)) continue;
                    scale = s;
                    yMin = y;
                    xMin = x;
                } else {
                    if (x < xMin) {
                        xMin = x;
                    }
                    if (!(Math.abs(y - yMin) <= 1.0E-10)) {
                        if (!(y < yMin)) continue;
                        yMin = y;
                    } else if (!(x < xLead)) continue;
                }
                xLead = x;
                reference = tr;
            }
            if (reference == null) continue;
            if ((xLead -= xMin) > 1.0E-10) {
                double[] matrix = new double[6];
                reference.getMatrix(matrix);
                matrix[4] = matrix[4] - xLead;
                reference = new AffineTransform(matrix);
            } else {
                reference = new AffineTransform(reference);
            }
            try {
                toGrid = reference.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new IllegalStateException(e);
            }
            int index = 0;
            Rectangle groupBounds = null;
            Rectangle2D.Double envelope = new Rectangle2D.Double();
            Tile[] tilesArray = new Tile[tilesAT.size()];
            for (Map.Entry<AffineTransform, Dimension> entry : tilesAT.entrySet()) {
                Rectangle bounds;
                AffineTransform tr = entry.getKey();
                Tile tile = this.tiles.remove(tr);
                tr.preConcatenate(toGrid);
                Tile tile2 = tile;
                synchronized (tile2) {
                    tile.setSubsampling(entry.getValue());
                    try {
                        bounds = tile.getRegion();
                    }
                    catch (IOException exception) {
                        bounds = null;
                        Logging.unexpectedException(RegionCalculator.class, (String)"tiles", (Throwable)exception);
                    }
                    if (bounds != null) {
                        XAffineTransform.transform((AffineTransform)tr, (Rectangle2D)bounds, (Rectangle2D)envelope);
                        bounds.x = (int)Math.round(envelope.x);
                        bounds.y = (int)Math.round(envelope.y);
                        bounds.width = (int)Math.round(envelope.width);
                        bounds.height = (int)Math.round(envelope.height);
                    } else {
                        Point location = tile.getLocation();
                        tr.transform(location, location);
                        bounds = new Rectangle(location.x, location.y, 0, 0);
                    }
                    tile.setAbsoluteRegion(bounds);
                }
                if (groupBounds == null) {
                    groupBounds = bounds;
                } else {
                    groupBounds.add(bounds);
                }
                tilesArray[index++] = tile;
            }
            tilesAT.clear();
            if (groupBounds == null) continue;
            int dx = this.xLocation - groupBounds.x;
            int dy = this.yLocation - groupBounds.y;
            if (dx != 0 || dy != 0) {
                reference.translate(-dx, -dy);
                groupBounds.translate(dx, dy);
            }
            ImageGeometry geometry = new ImageGeometry(groupBounds, reference);
            reference = geometry.getGridToCRS();
            HashMap<Dimension, TranslatedTransform> pool = new HashMap<Dimension, TranslatedTransform>();
            for (Tile tile : tilesArray) {
                Dimension subsampling = tile.getSubsampling();
                TranslatedTransform translated = (TranslatedTransform)pool.get(subsampling);
                if (translated == null) {
                    translated = new TranslatedTransform(subsampling, reference, dx, dy);
                    pool.put(subsampling, translated);
                }
                translated.applyTo(tile);
            }
            results.put(geometry, tilesArray);
        }
        return results;
    }

    private static List<Map<AffineTransform, Dimension>> computePyramidLevels(Collection<AffineTransform> gridToCRS) {
        ArrayList<Map<AffineTransform, Dimension>> results = new ArrayList<Map<AffineTransform, Dimension>>(2);
        AffineTransform[] transforms = gridToCRS.toArray(new AffineTransform[gridToCRS.size()]);
        Arrays.sort(transforms, X_COMPARATOR);
        int length = transforms.length;
        while (length != 0) {
            IdentityHashMap<AffineTransform, Dimension> result = new IdentityHashMap<AffineTransform, Dimension>();
            if (length <= (length = RegionCalculator.computePyramidLevels(transforms, length, result, false))) {
                throw new AssertionError(length);
            }
            results.add(result);
        }
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            Map result = (Map)iterator.next();
            length = result.size();
            transforms = result.keySet().toArray(transforms);
            Arrays.sort(transforms, 0, length, Y_COMPARATOR);
            length = RegionCalculator.computePyramidLevels(transforms, length, result, true);
            while (--length >= 0) {
                if (result.remove(transforms[length]) == null) {
                    throw new AssertionError(length);
                }
            }
            if (!result.isEmpty()) continue;
            iterator.remove();
        }
        return results;
    }

    private static int computePyramidLevels(AffineTransform[] gridToCRS, int length, Map<AffineTransform, Dimension> result, boolean isY) {
        double shear;
        double scale;
        AffineTransform base;
        boolean shearIsNull;
        boolean scaleIsNull;
        int processing = 0;
        int remaining = 0;
        do {
            if (processing >= length) {
                return remaining;
            }
            base = gridToCRS[processing++];
            if (isY) {
                scale = base.getScaleY();
                shear = base.getShearY();
            } else {
                scale = base.getScaleX();
                shear = base.getShearX();
            }
            scaleIsNull = Math.abs(scale) < 1.0E-10;
            boolean bl = shearIsNull = Math.abs(shear) < 1.0E-10;
        } while (scaleIsNull && shearIsNull && RegionCalculator.redo(result.remove(base)));
        if (isY) {
            result.get((Object)base).height = 1;
        } else {
            assert (result.isEmpty()) : result;
            result.put(base, new Dimension(1, 0));
        }
        while (processing < length) {
            int level;
            double shear2;
            double scale2;
            AffineTransform candidate = gridToCRS[processing++];
            if (isY) {
                scale2 = candidate.getScaleY();
                shear2 = candidate.getShearY();
            } else {
                scale2 = candidate.getScaleX();
                shear2 = candidate.getShearX();
            }
            if (scaleIsNull) {
                if (!(Math.abs(scale2) < 1.0E-10)) {
                    gridToCRS[remaining++] = candidate;
                    continue;
                }
                level = RegionCalculator.level(shear2 / shear);
            } else {
                level = RegionCalculator.level(scale2 / scale);
                if (shearIsNull ? !(Math.abs(shear2) < 1.0E-10) : RegionCalculator.level(shear2 / shear) != level) {
                    gridToCRS[remaining++] = candidate;
                    continue;
                }
            }
            if (level == 0) {
                gridToCRS[remaining++] = candidate;
                continue;
            }
            if (isY) {
                result.get((Object)candidate).height = level;
                continue;
            }
            if (result.put(candidate, new Dimension(level, 0)) != null) {
                throw new AssertionError(candidate);
            }
        }
        Arrays.fill(gridToCRS, remaining, length, null);
        return remaining;
    }

    private static int level(double ratio) {
        if (ratio > 0.0 && ratio < Double.POSITIVE_INFINITY) {
            double integer;
            boolean inverse;
            boolean bl = inverse = ratio < 0.75;
            if (inverse) {
                ratio = 1.0 / ratio;
            }
            if ((integer = Math.rint(ratio)) < 2.147483647E9 && Math.abs(ratio - integer) < 1.0E-10) {
                int level = (int)integer;
                if (inverse) {
                    level = -level;
                }
                return level;
            }
        }
        return 0;
    }

    private static boolean redo(Dimension size) {
        return true;
    }

    public String toString() {
        ArrayList<Tile> tiles = new ArrayList<Tile>(this.tiles.values());
        Collections.sort(tiles);
        return Tile.toString(tiles, 400);
    }
}

