/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.utils.progress;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.geotools.utils.progress.ExceptionEvent;
import org.geotools.utils.progress.ProcessingEvent;
import org.geotools.utils.progress.ProcessingEventListener;

public abstract class ProgressManager {
    private boolean sendDelayedMessages = false;
    private volatile boolean stopThread = false;
    private List<ProcessingEventListener> notificationListeners = new ArrayList<ProcessingEventListener>();

    public ProgressManager(boolean sendDelayedMessages) {
        this.sendDelayedMessages = sendDelayedMessages;
    }

    public ProgressManager() {
    }

    public final synchronized void addProcessingEventListener(ProcessingEventListener listener) {
        this.notificationListeners.add(listener);
    }

    public final synchronized void removeProcessingEventListener(ProcessingEventListener listener) {
        this.notificationListeners.remove(listener);
    }

    public final synchronized void removeAllProcessingEventListeners() {
        this.notificationListeners.clear();
    }

    public synchronized void fireEvent(String string, double percentage) {
        String newLine = System.getProperty("line.separator");
        StringBuffer message = new StringBuffer("Thread Name ");
        message.append(Thread.currentThread().getName()).append(newLine);
        message.append(this.getClass().toString()).append(newLine).append(string);
        ProcessingEvent evt = new ProcessingEvent(this, string, percentage);
        ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
        eventLauncher.setEvent(evt, this.notificationListeners.toArray());
        this.sendEvent(eventLauncher);
    }

    private void sendEvent(ProgressEventDispatchThreadEventLauncher eventLauncher) {
        if (this.sendDelayedMessages) {
            SwingUtilities.invokeLater(eventLauncher);
        } else {
            eventLauncher.run();
        }
    }

    public synchronized void fireException(String string, double percentage, Exception ex) {
        String newLine = System.getProperty("line.separator");
        StringBuffer message = new StringBuffer("Thread Name ");
        message.append(Thread.currentThread().getName()).append(newLine);
        message.append(this.getClass().toString()).append(newLine).append(string);
        ExceptionEvent evt = new ExceptionEvent(this, string, percentage, ex);
        ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
        eventLauncher.setEvent(evt, this.notificationListeners.toArray());
        this.sendEvent(eventLauncher);
    }

    public synchronized void fireException(Exception ex) {
        this.fireException(ExceptionEvent.getMessageFromException(ex), -1.0, ex);
    }

    public final boolean getStopThread() {
        return this.stopThread;
    }

    public final void stopThread() {
        this.stopThread = true;
    }

    public synchronized void dispose() {
        this.removeAllProcessingEventListeners();
    }

    public abstract void run() throws Throwable;

    protected static final class ProgressEventDispatchThreadEventLauncher
    implements Runnable {
        private ProcessingEvent event;
        private Object[] listeners;

        ProgressEventDispatchThreadEventLauncher() {
        }

        synchronized void setEvent(ProcessingEvent evt, Object[] listeners) {
            if (listeners == null || evt == null) {
                throw new NullPointerException("Input argumentBuilder cannot be null");
            }
            this.listeners = listeners;
            this.event = evt;
        }

        public void run() {
            int numListeners = this.listeners.length;
            if (this.event instanceof ExceptionEvent) {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).exceptionOccurred((ExceptionEvent)this.event);
                }
            } else {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).getNotification(this.event);
                }
            }
        }
    }
}

