/* Generated By:JJTree&JavaCC: Do not edit this line. CQLParser.java */
package org.geotools.filter.text.generated.parsers;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;




/**
 * CQLParser is the result of a javacc jjtree grammar.
 * 
 * @author  Ian Schneider
 * @author  Mauricio Pazos - Axios Engineering
 * @since 2.5
 * @version $Id: CQLGrammar.jjt 24966 2007-03-30 11:33:47Z vmpazos $
 */
public class CQLParser/*@bgen(jjtree)*/implements CQLParserTreeConstants, CQLParserConstants {/*@bgen(jjtree)*/
  protected JJTCQLParserState jjtree = new JJTCQLParserState();public void jjtreeOpenNodeScope(Node n) throws ParseException {

  }

  public void jjtreeCloseNodeScope(Node n) throws ParseException {

  }
private static final Logger LOGGER = Logger.getLogger(CQLParser.class.getName());

  /**
   * initialize geooperations
   */
  protected static final Set GEOOP = new HashSet();
  static {
                GEOOP.add("EQUALS");
                GEOOP.add("DISJOINT");
                GEOOP.add("INTERSECTS");
                GEOOP.add("TOUCHES");
                GEOOP.add("CROSSES");
                GEOOP.add("WITHIN");
                GEOOP.add("CONTAINS");
                GEOOP.add("OVERLAPS");
                GEOOP.add("RELATE");
                GEOOP.add("BBOX");
  }

  protected boolean isGeoOp() {

                String tokenImage = getToken(1).image.toUpperCase();
                boolean OK =
                                 "(".equals(getToken(2).image)
                        && GEOOP.contains(tokenImage);


        return OK;
  }

  protected static final Set RELGEOOP = new HashSet();
  static {
        RELGEOOP.add("DWITHIN");
        RELGEOOP.add("BEYOND");

  }
  protected boolean isRelGeoOp() {

        return "(".equals(getToken(2).image)
            && RELGEOOP.contains(getToken(1).image.toUpperCase());
  }

/*
 * Program structuring syntax to parse a single filter.
 */
  final public Node FilterCompilationUnit() throws ParseException {
    SearchCondition();
    jj_consume_token(0);
    {if (true) return jjtree.rootNode();}
    throw new Error("Missing return statement in function");
  }

/*
 * Program structuring syntax to parse a single expression.
 */
  final public Node ExpressionCompilationUnit() throws ParseException {
    Expression();
    jj_consume_token(0);
    {if (true) return jjtree.rootNode();}
    throw new Error("Missing return statement in function");
  }

/*
 * Program structuring syntax to parse a list of filters.
 */
  final public Node FilterListCompilationUnit() throws ParseException {
    SequenceOfSearchConditions();
    jj_consume_token(0);
    {if (true) return jjtree.rootNode();}
    throw new Error("Missing return statement in function");
  }

  final public void SearchCondition() throws ParseException {
    BooleanValueExpression();
  }

/*
 * <SequenceOfSearchConditions> ::= 
 * 			<search condition>
 * 		|	<SequenceOfSearchConditions> ; <search condition>
 */
  final public void SequenceOfSearchConditions() throws ParseException {
    SearchCondition();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SENTENCE_SEPARATOR:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      jj_consume_token(SENTENCE_SEPARATOR);
      SearchCondition();
    }
  }

/*
 * <boolean value expression> ::= 
 *			<boolean term>
 * 		| 	<boolean value expression> OR <boolean term>
 */
  final public void BooleanValueExpression() throws ParseException {
    BooleanTerm();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_2;
      }
      jj_consume_token(OR);
                                      SimpleNode jjtn001 = new SimpleNode(JJTBOOLEAN_OR_NODE);
                                      boolean jjtc001 = true;
                                      jjtree.openNodeScope(jjtn001);
                                      jjtreeOpenNodeScope(jjtn001);
      try {
        BooleanTerm();
      } catch (Throwable jjte001) {
                                      if (jjtc001) {
                                        jjtree.clearNodeScope(jjtn001);
                                        jjtc001 = false;
                                      } else {
                                        jjtree.popNode();
                                      }
                                      if (jjte001 instanceof RuntimeException) {
                                        {if (true) throw (RuntimeException)jjte001;}
                                      }
                                      if (jjte001 instanceof ParseException) {
                                        {if (true) throw (ParseException)jjte001;}
                                      }
                                      {if (true) throw (Error)jjte001;}
      } finally {
                                      if (jjtc001) {
                                        jjtree.closeNodeScope(jjtn001, true);
                                        jjtreeCloseNodeScope(jjtn001);
                                      }
      }
    }
  }

/*
 * <boolean term> ::= 
 *            <boolean factor>
 *          | <boolean term> AND <boolean factor>
 */
  final public void BooleanTerm() throws ParseException {
    BooleanFactor();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_3;
      }
      jj_consume_token(AND);
                                  SimpleNode jjtn001 = new SimpleNode(JJTBOOLEAN_AND_NODE);
                                  boolean jjtc001 = true;
                                  jjtree.openNodeScope(jjtn001);
                                  jjtreeOpenNodeScope(jjtn001);
      try {
        BooleanFactor();
      } catch (Throwable jjte001) {
                                  if (jjtc001) {
                                    jjtree.clearNodeScope(jjtn001);
                                    jjtc001 = false;
                                  } else {
                                    jjtree.popNode();
                                  }
                                  if (jjte001 instanceof RuntimeException) {
                                    {if (true) throw (RuntimeException)jjte001;}
                                  }
                                  if (jjte001 instanceof ParseException) {
                                    {if (true) throw (ParseException)jjte001;}
                                  }
                                  {if (true) throw (Error)jjte001;}
      } finally {
                                  if (jjtc001) {
                                    jjtree.closeNodeScope(jjtn001, true);
                                    jjtreeCloseNodeScope(jjtn001);
                                  }
      }
    }
  }

  final public void BooleanFactor() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
                        SimpleNode jjtn001 = new SimpleNode(JJTBOOLEAN_NOT_NODE);
                        boolean jjtc001 = true;
                        jjtree.openNodeScope(jjtn001);
                        jjtreeOpenNodeScope(jjtn001);
      try {
        BooleanPrimary();
      } catch (Throwable jjte001) {
                        if (jjtc001) {
                          jjtree.clearNodeScope(jjtn001);
                          jjtc001 = false;
                        } else {
                          jjtree.popNode();
                        }
                        if (jjte001 instanceof RuntimeException) {
                          {if (true) throw (RuntimeException)jjte001;}
                        }
                        if (jjte001 instanceof ParseException) {
                          {if (true) throw (ParseException)jjte001;}
                        }
                        {if (true) throw (Error)jjte001;}
      } finally {
                        if (jjtc001) {
                          jjtree.closeNodeScope(jjtn001, true);
                          jjtreeCloseNodeScope(jjtn001);
                        }
      }
      break;
    default:
      jj_la1[3] = jj_gen;
      if (jj_2_1(1)) {
        BooleanPrimary();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void BooleanPrimary() throws ParseException {
    if (jj_2_2(2147483647)) {
      Predicate();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INCLUDE:
      case EXCLUDE:
        IncludeExcludePredicate();
        break;
      case LP:
        jj_consume_token(LP);
        SearchCondition();
        jj_consume_token(RP);
        break;
      case LSP:
        jj_consume_token(LSP);
        SearchCondition();
        jj_consume_token(RSP);
        break;
      default:
        jj_la1[4] = jj_gen;
        if (jj_2_3(1)) {
          RoutineInvocation();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

/*
 * <predicate> ::= <comparison predicate>
 * 	| <text predicate>
 * 	| <null predicate>
 * 	| <temporal predicate>
 * 	| <classification predicate> (*not supported*)
 * 	| <existence predicate> 
 * 	| <between predicate> (*extension*)
 *  | <includeexclude predicate> (*extension*)
 */
  final public void Predicate() throws ParseException {
    Attribute();
    if (jj_2_4(3)) {
      TextPredicate();
    } else if (jj_2_5(3)) {
      NullPredicate();
    } else if (jj_2_6(3)) {
      ExistencePredicate();
    } else if (jj_2_7(3)) {
      TemporalPredicate();
    } else if (jj_2_8(3)) {
      BetweenPredicate();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
      case NEQ:
      case GT:
      case LT:
      case GTE:
      case LTE:
        ComparissonPredicate();
        break;
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/* ---------------------------------------- *
 *   	<routine invocation>
 * ---------------------------------------- *
/*
 * <routine invocation> ::= 
 *	 <geoop name><georoutine argument list>
 * | <relgeoop name><relgeoop argument list>
 * | <routine name><argument list>
 */
  final public void RoutineInvocation() throws ParseException {
    if (isGeoOp()) {
      RoutineInvocationGeoOp();
    } else if (isRelGeoOp()) {
      RoutineInvocationRelGeoOp();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        RoutineInvocationGeneric();
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void RoutineInvocationGeoOp() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUALS:
      jj_consume_token(EQUALS);
                          SimpleNode jjtn001 = new SimpleNode(JJTROUTINEINVOCATION_GEOOP_EQUAL_NODE);
                          boolean jjtc001 = true;
                          jjtree.openNodeScope(jjtn001);
                          jjtreeOpenNodeScope(jjtn001);
      try {
        GeoRoutineArgumentList();
      } catch (Throwable jjte001) {
                          if (jjtc001) {
                            jjtree.clearNodeScope(jjtn001);
                            jjtc001 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte001 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte001;}
                          }
                          if (jjte001 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte001;}
                          }
                          {if (true) throw (Error)jjte001;}
      } finally {
                          if (jjtc001) {
                            jjtree.closeNodeScope(jjtn001, true);
                            jjtreeCloseNodeScope(jjtn001);
                          }
      }
      break;
    case DISJOINT:
      jj_consume_token(DISJOINT);
                          SimpleNode jjtn002 = new SimpleNode(JJTROUTINEINVOCATION_GEOOP_DISJOINT_NODE);
                          boolean jjtc002 = true;
                          jjtree.openNodeScope(jjtn002);
                          jjtreeOpenNodeScope(jjtn002);
      try {
        GeoRoutineArgumentList();
      } catch (Throwable jjte002) {
                          if (jjtc002) {
                            jjtree.clearNodeScope(jjtn002);
                            jjtc002 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte002 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte002;}
                          }
                          if (jjte002 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte002;}
                          }
                          {if (true) throw (Error)jjte002;}
      } finally {
                          if (jjtc002) {
                            jjtree.closeNodeScope(jjtn002, true);
                            jjtreeCloseNodeScope(jjtn002);
                          }
      }
      break;
    case INTERSECTS:
      jj_consume_token(INTERSECTS);
                       SimpleNode jjtn003 = new SimpleNode(JJTROUTINEINVOCATION_GEOOP_INTERSECT_NODE);
                       boolean jjtc003 = true;
                       jjtree.openNodeScope(jjtn003);
                       jjtreeOpenNodeScope(jjtn003);
      try {
        GeoRoutineArgumentList();
      } catch (Throwable jjte003) {
                       if (jjtc003) {
                         jjtree.clearNodeScope(jjtn003);
                         jjtc003 = false;
                       } else {
                         jjtree.popNode();
                       }
                       if (jjte003 instanceof RuntimeException) {
                         {if (true) throw (RuntimeException)jjte003;}
                       }
                       if (jjte003 instanceof ParseException) {
                         {if (true) throw (ParseException)jjte003;}
                       }
                       {if (true) throw (Error)jjte003;}
      } finally {
                       if (jjtc003) {
                         jjtree.closeNodeScope(jjtn003, true);
                         jjtreeCloseNodeScope(jjtn003);
                       }
      }
      break;
    case TOUCHES:
      jj_consume_token(TOUCHES);
                          SimpleNode jjtn004 = new SimpleNode(JJTROUTINEINVOCATION_GEOOP_TOUCH_NODE);
                          boolean jjtc004 = true;
                          jjtree.openNodeScope(jjtn004);
                          jjtreeOpenNodeScope(jjtn004);
      try {
        GeoRoutineArgumentList();
      } catch (Throwable jjte004) {
                          if (jjtc004) {
                            jjtree.clearNodeScope(jjtn004);
                            jjtc004 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte004 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte004;}
                          }
                          if (jjte004 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte004;}
                          }
                          {if (true) throw (Error)jjte004;}
      } finally {
                          if (jjtc004) {
                            jjtree.closeNodeScope(jjtn004, true);
                            jjtreeCloseNodeScope(jjtn004);
                          }
      }
      break;
    case CROSSES:
      jj_consume_token(CROSSES);
                          SimpleNode jjtn005 = new SimpleNode(JJTROUTINEINVOCATION_GEOOP_CROSS_NODE);
                          boolean jjtc005 = true;
                          jjtree.openNodeScope(jjtn005);
                          jjtreeOpenNodeScope(jjtn005);
      try {
        GeoRoutineArgumentList();
      } catch (Throwable jjte005) {
                          if (jjtc005) {
                            jjtree.clearNodeScope(jjtn005);
                            jjtc005 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte005 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte005;}
                          }
                          if (jjte005 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte005;}
                          }
                          {if (true) throw (Error)jjte005;}
      } finally {
                          if (jjtc005) {
                            jjtree.closeNodeScope(jjtn005, true);
                            jjtreeCloseNodeScope(jjtn005);
                          }
      }
      break;
    case WITHIN:
      jj_consume_token(WITHIN);
                          SimpleNode jjtn006 = new SimpleNode(JJTROUTINEINVOCATION_GEOOP_WITHIN_NODE);
                          boolean jjtc006 = true;
                          jjtree.openNodeScope(jjtn006);
                          jjtreeOpenNodeScope(jjtn006);
      try {
        GeoRoutineArgumentList();
      } catch (Throwable jjte006) {
                          if (jjtc006) {
                            jjtree.clearNodeScope(jjtn006);
                            jjtc006 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte006 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte006;}
                          }
                          if (jjte006 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte006;}
                          }
                          {if (true) throw (Error)jjte006;}
      } finally {
                          if (jjtc006) {
                            jjtree.closeNodeScope(jjtn006, true);
                            jjtreeCloseNodeScope(jjtn006);
                          }
      }
      break;
    case CONTAINS:
      jj_consume_token(CONTAINS);
                          SimpleNode jjtn007 = new SimpleNode(JJTROUTINEINVOCATION_GEOOP_CONTAIN_NODE);
                          boolean jjtc007 = true;
                          jjtree.openNodeScope(jjtn007);
                          jjtreeOpenNodeScope(jjtn007);
      try {
        GeoRoutineArgumentList();
      } catch (Throwable jjte007) {
                          if (jjtc007) {
                            jjtree.clearNodeScope(jjtn007);
                            jjtc007 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte007 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte007;}
                          }
                          if (jjte007 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte007;}
                          }
                          {if (true) throw (Error)jjte007;}
      } finally {
                          if (jjtc007) {
                            jjtree.closeNodeScope(jjtn007, true);
                            jjtreeCloseNodeScope(jjtn007);
                          }
      }
      break;
    case OVERLAPS:
      jj_consume_token(OVERLAPS);
                          SimpleNode jjtn008 = new SimpleNode(JJTROUTINEINVOCATION_GEOOP_OVERLAP_NODE);
                          boolean jjtc008 = true;
                          jjtree.openNodeScope(jjtn008);
                          jjtreeOpenNodeScope(jjtn008);
      try {
        GeoRoutineArgumentList();
      } catch (Throwable jjte008) {
                          if (jjtc008) {
                            jjtree.clearNodeScope(jjtn008);
                            jjtc008 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte008 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte008;}
                          }
                          if (jjte008 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte008;}
                          }
                          {if (true) throw (Error)jjte008;}
      } finally {
                          if (jjtc008) {
                            jjtree.closeNodeScope(jjtn008, true);
                            jjtreeCloseNodeScope(jjtn008);
                          }
      }
      break;
    case RELATE:
      jj_consume_token(RELATE);
                          SimpleNode jjtn009 = new SimpleNode(JJTROUTINEINVOCATION_GEOOP_RELATE_NODE);
                          boolean jjtc009 = true;
                          jjtree.openNodeScope(jjtn009);
                          jjtreeOpenNodeScope(jjtn009);
      try {
        GeoRoutineArgumentList();
      } catch (Throwable jjte009) {
                          if (jjtc009) {
                            jjtree.clearNodeScope(jjtn009);
                            jjtc009 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte009 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte009;}
                          }
                          if (jjte009 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte009;}
                          }
                          {if (true) throw (Error)jjte009;}
      } finally {
                          if (jjtc009) {
                            jjtree.closeNodeScope(jjtn009, true);
                            jjtreeCloseNodeScope(jjtn009);
                          }
      }
      break;
    case BBOX:
      jj_consume_token(BBOX);
      BBoxArgumentList();
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <georoutine argument list> ::=
 *		<left paren><attribute name><comma><geometry literal><right paren>
 *
 */
  final public void GeoRoutineArgumentList() throws ParseException {
    jj_consume_token(LP);
    Attribute();
    jj_consume_token(COMMA);
    GeometryLiteral();
    jj_consume_token(RP);
  }

/*
 * <bbox argument list>::= 
 * 	"(" <attribute> "," 
 * 		<min X> ","
 * 		<min Y> ","
 * 		<max X> ","
 * 		<max Y> 
 * 		[, srs] ")"
 * 
 * <min X> ::= <signed numerical literal> 
 * <min Y> ::= <signed numerical literal> 
 * <max X> ::= <signed numerical literal> 
 * <max Y> ::= <signed numerical literal> 
 * <srs> ::= <character string literal>
*/
  final public void BBoxArgumentList() throws ParseException {
    jj_consume_token(LP);
    Attribute();
    jj_consume_token(COMMA);
    SignedNumericLiteral();
    jj_consume_token(COMMA);
    SignedNumericLiteral();
    jj_consume_token(COMMA);
    SignedNumericLiteral();
    jj_consume_token(COMMA);
    SignedNumericLiteral();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RP:
                             SimpleNode jjtn001 = new SimpleNode(JJTROUTINEINVOCATION_GEOOP_BBOX_NODE);
                             boolean jjtc001 = true;
                             jjtree.openNodeScope(jjtn001);
                             jjtreeOpenNodeScope(jjtn001);
      try {
        jj_consume_token(RP);
      } finally {
                             if (jjtc001) {
                               jjtree.closeNodeScope(jjtn001, true);
                               jjtreeCloseNodeScope(jjtn001);
                             }
      }
      break;
    case COMMA:
      jj_consume_token(COMMA);
      StringLiteral();
                                                     SimpleNode jjtn002 = new SimpleNode(JJTROUTINEINVOCATION_GEOOP_BBOX_SRS_NODE);
                                                     boolean jjtc002 = true;
                                                     jjtree.openNodeScope(jjtn002);
                                                     jjtreeOpenNodeScope(jjtn002);
      try {
        jj_consume_token(RP);
      } finally {
                                                     if (jjtc002) {
                                                       jjtree.closeNodeScope(jjtn002, true);
                                                       jjtreeCloseNodeScope(jjtn002);
                                                     }
      }
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <relgeoop name> ::= DWITHIN | BEYOND
 */
  final public void RoutineInvocationRelGeoOp() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DWITHIN:
      jj_consume_token(DWITHIN);
                          SimpleNode jjtn001 = new SimpleNode(JJTROUTINEINVOCATION_RELOP_DWITHIN_NODE);
                          boolean jjtc001 = true;
                          jjtree.openNodeScope(jjtn001);
                          jjtreeOpenNodeScope(jjtn001);
      try {
        RelGeoRoutineArgumentList();
      } catch (Throwable jjte001) {
                          if (jjtc001) {
                            jjtree.clearNodeScope(jjtn001);
                            jjtc001 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte001 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte001;}
                          }
                          if (jjte001 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte001;}
                          }
                          {if (true) throw (Error)jjte001;}
      } finally {
                          if (jjtc001) {
                            jjtree.closeNodeScope(jjtn001, true);
                            jjtreeCloseNodeScope(jjtn001);
                          }
      }
      break;
    case BEYOND:
      jj_consume_token(BEYOND);
                          SimpleNode jjtn002 = new SimpleNode(JJTROUTINEINVOCATION_RELOP_BEYOND_NODE);
                          boolean jjtc002 = true;
                          jjtree.openNodeScope(jjtn002);
                          jjtreeOpenNodeScope(jjtn002);
      try {
        RelGeoRoutineArgumentList();
      } catch (Throwable jjte002) {
                          if (jjtc002) {
                            jjtree.clearNodeScope(jjtn002);
                            jjtc002 = false;
                          } else {
                            jjtree.popNode();
                          }
                          if (jjte002 instanceof RuntimeException) {
                            {if (true) throw (RuntimeException)jjte002;}
                          }
                          if (jjte002 instanceof ParseException) {
                            {if (true) throw (ParseException)jjte002;}
                          }
                          {if (true) throw (Error)jjte002;}
      } finally {
                          if (jjtc002) {
                            jjtree.closeNodeScope(jjtn002, true);
                            jjtreeCloseNodeScope(jjtn002);
                          }
      }
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <relgeoop argument list> ::= 
 *		<left paren><attribute name><comma><geometry literal><comma><tolerance><right paren>
 */
  final public void RelGeoRoutineArgumentList() throws ParseException {
    jj_consume_token(LP);
    Attribute();
    jj_consume_token(COMMA);
    GeometryLiteral();
    jj_consume_token(COMMA);
    Tolerance();
    jj_consume_token(RP);
  }

/*
 * <tolerance> ::= <unsigned numeric literal><comma><distance units>
 */
  final public void Tolerance() throws ParseException {
          SimpleNode jjtn001 = new SimpleNode(JJTTOLERANCE_NODE);
          boolean jjtc001 = true;
          jjtree.openNodeScope(jjtn001);
          jjtreeOpenNodeScope(jjtn001);
    try {
      UnsignedNumericLiteral();
    } catch (Throwable jjte001) {
          if (jjtc001) {
            jjtree.clearNodeScope(jjtn001);
            jjtc001 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte001 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte001;}
          }
          if (jjte001 instanceof ParseException) {
            {if (true) throw (ParseException)jjte001;}
          }
          {if (true) throw (Error)jjte001;}
    } finally {
          if (jjtc001) {
            jjtree.closeNodeScope(jjtn001, true);
            jjtreeCloseNodeScope(jjtn001);
          }
    }
    jj_consume_token(COMMA);
    DistanceUnits();
  }

  final public void UnsignedNumericLiteral() throws ParseException {
    SignedNumericLiteral();
  }

/**
 * <distance units> ::=
 *	 'feet' | 'meters' | 'statute miles' |
 *   'nautical miles' | 'kilometers'
 * 
 * TODO this set of units is just an example. The real list of distance unit must be developed
 */
  final public void DistanceUnits() throws ParseException {
 /*@bgen(jjtree) DistanceUnits_Node */
  SimpleNode jjtn000 = new SimpleNode(JJTDISTANCEUNITS_NODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FEET:
        jj_consume_token(FEET);
        break;
      case METERS:
        jj_consume_token(METERS);
        break;
      case STATUTE_MILES:
        jj_consume_token(STATUTE_MILES);
        break;
      case NAUTICAL_MILES:
        jj_consume_token(NAUTICAL_MILES);
        break;
      case KILOMETERS:
        jj_consume_token(KILOMETERS);
        break;
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtreeCloseNodeScope(jjtn000);
          }
    }
  }

/*
 * <geometry literal> ::= 
 *	  <Point Tagged Text>
 * 	| <LineString Tagged Text>
 * 	| <Polygon Tagged Text>
 *	| <MultiPoint Tagged Text>
 *  | <MultiLineString Tagged Text>
 * 	| <MultiPolygon Tagged Text>
 * 	| <GeometryCollection Tagged Text>
 *	| <Envelope Tagged Text>
 */
  final public void GeometryLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case POINT:
      PointTaggedText();
      break;
    case LINESTRING:
      LineStringTaggedText();
      break;
    case POLYGON:
      PolygonTaggedText();
      break;
    case MULTIPOINT:
      MultiPointTaggedText();
      break;
    case MULTILINESTRING:
      MultiLineStringTaggedText();
      break;
    case MULTIPOLYGON:
      MultiPolygonTaggedText();
      break;
    case GEOMETRYCOLLECTION:
      GeometryCollectionTaggedText();
      break;
    case ENVELOPE:
      EnvelopeTaggedText();
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 *  <routine invocation > ::= 
 *  |   <routine name > <argument list > 
 *                                           
 * <argument list&gt ::=    
 *      <left paren> [<positional arguments>] <right paren>
 * <positional arguments> ::=
 *      <argument> [ { <comma&gt <argument> }... ]
 *           
 * <argument>  ::= 
 *      <literal>  
 *  |   <attribute name>                                            
 *  |   <function>           (*Extension*)                                            
 *  |   <binary expression>  (*Extnsion*)                            
 */
  final public void RoutineInvocationGeneric() throws ParseException {
    Function();
  }

/* ---------------------------------------- *
 *   	End <routine invocation>
 * ---------------------------------------- *


/* ---------------------------------------- *
 *   	<includeexclude predicate>
 * ---------------------------------------- *
/*
 * <includeexclude predicate> ::= 
 *		  <INCLUDE> | <EXCLUDE>
 */
  final public void IncludeExcludePredicate() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCLUDE:
     SimpleNode jjtn001 = new SimpleNode(JJTINCLUDE_NODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
     jjtreeOpenNodeScope(jjtn001);
      try {
        jj_consume_token(INCLUDE);
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, true);
       jjtreeCloseNodeScope(jjtn001);
     }
      }
      break;
    case EXCLUDE:
       SimpleNode jjtn002 = new SimpleNode(JJTEXCLUDE_NODE);
       boolean jjtc002 = true;
       jjtree.openNodeScope(jjtn002);
       jjtreeOpenNodeScope(jjtn002);
      try {
        jj_consume_token(EXCLUDE);
      } finally {
       if (jjtc002) {
         jjtree.closeNodeScope(jjtn002, true);
         jjtreeCloseNodeScope(jjtn002);
       }
      }
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* ---------------------------------------- *
 *   	<comparison predicate>
 * ---------------------------------------- *
/*
 * <comparison predicate> ::= 
 *		  <attribute name> <comp op> <literal>
 */
  final public void ComparissonPredicate() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      jj_consume_token(EQ);
                  SimpleNode jjtn001 = new SimpleNode(JJTCOMPARISSONPREDICATE_EQ_NODE);
                  boolean jjtc001 = true;
                  jjtree.openNodeScope(jjtn001);
                  jjtreeOpenNodeScope(jjtn001);
      try {
        Expression();
      } catch (Throwable jjte001) {
                  if (jjtc001) {
                    jjtree.clearNodeScope(jjtn001);
                    jjtc001 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte001 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte001;}
                  }
                  if (jjte001 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte001;}
                  }
                  {if (true) throw (Error)jjte001;}
      } finally {
                  if (jjtc001) {
                    jjtree.closeNodeScope(jjtn001, true);
                    jjtreeCloseNodeScope(jjtn001);
                  }
      }
      break;
    case GT:
      jj_consume_token(GT);
                  SimpleNode jjtn002 = new SimpleNode(JJTCOMPARISSONPREDICATE_GT_NODE);
                  boolean jjtc002 = true;
                  jjtree.openNodeScope(jjtn002);
                  jjtreeOpenNodeScope(jjtn002);
      try {
        Expression();
      } catch (Throwable jjte002) {
                  if (jjtc002) {
                    jjtree.clearNodeScope(jjtn002);
                    jjtc002 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte002 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte002;}
                  }
                  if (jjte002 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte002;}
                  }
                  {if (true) throw (Error)jjte002;}
      } finally {
                  if (jjtc002) {
                    jjtree.closeNodeScope(jjtn002, true);
                    jjtreeCloseNodeScope(jjtn002);
                  }
      }
      break;
    case LT:
      jj_consume_token(LT);
                  SimpleNode jjtn003 = new SimpleNode(JJTCOMPARISSONPREDICATE_LT_NODE);
                  boolean jjtc003 = true;
                  jjtree.openNodeScope(jjtn003);
                  jjtreeOpenNodeScope(jjtn003);
      try {
        Expression();
      } catch (Throwable jjte003) {
                  if (jjtc003) {
                    jjtree.clearNodeScope(jjtn003);
                    jjtc003 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte003 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte003;}
                  }
                  if (jjte003 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte003;}
                  }
                  {if (true) throw (Error)jjte003;}
      } finally {
                  if (jjtc003) {
                    jjtree.closeNodeScope(jjtn003, true);
                    jjtreeCloseNodeScope(jjtn003);
                  }
      }
      break;
    case GTE:
      jj_consume_token(GTE);
                  SimpleNode jjtn004 = new SimpleNode(JJTCOMPARISSONPREDICATE_GTE_NODE);
                  boolean jjtc004 = true;
                  jjtree.openNodeScope(jjtn004);
                  jjtreeOpenNodeScope(jjtn004);
      try {
        Expression();
      } catch (Throwable jjte004) {
                  if (jjtc004) {
                    jjtree.clearNodeScope(jjtn004);
                    jjtc004 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte004 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte004;}
                  }
                  if (jjte004 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte004;}
                  }
                  {if (true) throw (Error)jjte004;}
      } finally {
                  if (jjtc004) {
                    jjtree.closeNodeScope(jjtn004, true);
                    jjtreeCloseNodeScope(jjtn004);
                  }
      }
      break;
    case LTE:
      jj_consume_token(LTE);
                  SimpleNode jjtn005 = new SimpleNode(JJTCOMPARISSONPREDICATE_LTE_NODE);
                  boolean jjtc005 = true;
                  jjtree.openNodeScope(jjtn005);
                  jjtreeOpenNodeScope(jjtn005);
      try {
        Expression();
      } catch (Throwable jjte005) {
                  if (jjtc005) {
                    jjtree.clearNodeScope(jjtn005);
                    jjtc005 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte005 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte005;}
                  }
                  if (jjte005 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte005;}
                  }
                  {if (true) throw (Error)jjte005;}
      } finally {
                  if (jjtc005) {
                    jjtree.closeNodeScope(jjtn005, true);
                    jjtreeCloseNodeScope(jjtn005);
                  }
      }
      break;
    case NEQ:
      jj_consume_token(NEQ);
                  SimpleNode jjtn006 = new SimpleNode(JJTCOMPARISSONPREDICATE_NOT_EQUAL_NODE);
                  boolean jjtc006 = true;
                  jjtree.openNodeScope(jjtn006);
                  jjtreeOpenNodeScope(jjtn006);
      try {
        Expression();
      } catch (Throwable jjte006) {
                  if (jjtc006) {
                    jjtree.clearNodeScope(jjtn006);
                    jjtc006 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte006 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte006;}
                  }
                  if (jjte006 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte006;}
                  }
                  {if (true) throw (Error)jjte006;}
      } finally {
                  if (jjtc006) {
                    jjtree.closeNodeScope(jjtn006, true);
                    jjtreeCloseNodeScope(jjtn006);
                  }
      }
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <null predicate> ::= <attribute name> IS [ NOT ] NULL 
 */
  final public void NullPredicate() throws ParseException {
    if (jj_2_9(3)) {
      jj_consume_token(IS);
                               SimpleNode jjtn001 = new SimpleNode(JJTNULLPREDICATENODE);
                               boolean jjtc001 = true;
                               jjtree.openNodeScope(jjtn001);
                               jjtreeOpenNodeScope(jjtn001);
      try {
        jj_consume_token(NULL);
      } finally {
                               if (jjtc001) {
                                 jjtree.closeNodeScope(jjtn001, true);
                                 jjtreeCloseNodeScope(jjtn001);
                               }
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IS:
        jj_consume_token(IS);
        jj_consume_token(NOT);
                                                     SimpleNode jjtn002 = new SimpleNode(JJTNOTNULLPREDICATENODE);
                                                     boolean jjtc002 = true;
                                                     jjtree.openNodeScope(jjtn002);
                                                     jjtreeOpenNodeScope(jjtn002);
        try {
          jj_consume_token(NULL);
        } finally {
                                                     if (jjtc002) {
                                                       jjtree.closeNodeScope(jjtn002, true);
                                                       jjtreeCloseNodeScope(jjtn002);
                                                     }
        }
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/* ---------------------------------------- *
 *   	<temporal predicate>
 * ---------------------------------------- *
 * <temporal predicate> ::= 
 *    <attribute_name> BEFORE <date-time expression>
 *	| <attribute_name> BEFORE OR DURING <period>
 *	| <attribute_name> DURING <period>
 *	| <attribute_name> DURING OR AFTER <period>
 *	| <attribute_name> AFTER <date-time expression>
 */
  final public void TemporalPredicate() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BEFORE:
      jj_consume_token(BEFORE);
      TemporalPredicateBefore();
      break;
    case AFTER:
      jj_consume_token(AFTER);
      TemporalPredicateAfter();
      break;
    case DURING:
      jj_consume_token(DURING);
      TemporalPredicateDuring();
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void TemporalPredicateBefore() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DURATION:
    case DATE_TIME:
                  SimpleNode jjtn001 = new SimpleNode(JJTTPBEFORE_DATETIME_NODE);
                  boolean jjtc001 = true;
                  jjtree.openNodeScope(jjtn001);
                  jjtreeOpenNodeScope(jjtn001);
      try {
        DateTimeExpression();
      } catch (Throwable jjte001) {
                  if (jjtc001) {
                    jjtree.clearNodeScope(jjtn001);
                    jjtc001 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte001 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte001;}
                  }
                  if (jjte001 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte001;}
                  }
                  {if (true) throw (Error)jjte001;}
      } finally {
                  if (jjtc001) {
                    jjtree.closeNodeScope(jjtn001, true);
                    jjtreeCloseNodeScope(jjtn001);
                  }
      }
      break;
    case OR:
      jj_consume_token(OR);
      jj_consume_token(DURING);
                                SimpleNode jjtn002 = new SimpleNode(JJTTPBEFORE_OR_DURING_PERIOD_NODE);
                                boolean jjtc002 = true;
                                jjtree.openNodeScope(jjtn002);
                                jjtreeOpenNodeScope(jjtn002);
      try {
        Period();
      } catch (Throwable jjte002) {
                                if (jjtc002) {
                                  jjtree.clearNodeScope(jjtn002);
                                  jjtc002 = false;
                                } else {
                                  jjtree.popNode();
                                }
                                if (jjte002 instanceof RuntimeException) {
                                  {if (true) throw (RuntimeException)jjte002;}
                                }
                                if (jjte002 instanceof ParseException) {
                                  {if (true) throw (ParseException)jjte002;}
                                }
                                {if (true) throw (Error)jjte002;}
      } finally {
                                if (jjtc002) {
                                  jjtree.closeNodeScope(jjtn002, true);
                                  jjtreeCloseNodeScope(jjtn002);
                                }
      }
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void TemporalPredicateAfter() throws ParseException {
 /*@bgen(jjtree) TPAfter_DateTime_Node */
  SimpleNode jjtn000 = new SimpleNode(JJTTPAFTER_DATETIME_NODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      DateTimeExpression();
    } catch (Throwable jjte000) {
                  if (jjtc000) {
                    jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte000 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte000;}
                  }
                  if (jjte000 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte000;}
                  }
                  {if (true) throw (Error)jjte000;}
    } finally {
                  if (jjtc000) {
                    jjtree.closeNodeScope(jjtn000, true);
                    jjtreeCloseNodeScope(jjtn000);
                  }
    }
  }

  final public void TemporalPredicateDuring() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DURATION:
    case DATE_TIME:
                  SimpleNode jjtn001 = new SimpleNode(JJTTPDURING_PERIOD_NODE);
                  boolean jjtc001 = true;
                  jjtree.openNodeScope(jjtn001);
                  jjtreeOpenNodeScope(jjtn001);
      try {
        Period();
      } catch (Throwable jjte001) {
                  if (jjtc001) {
                    jjtree.clearNodeScope(jjtn001);
                    jjtc001 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte001 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte001;}
                  }
                  if (jjte001 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte001;}
                  }
                  {if (true) throw (Error)jjte001;}
      } finally {
                  if (jjtc001) {
                    jjtree.closeNodeScope(jjtn001, true);
                    jjtreeCloseNodeScope(jjtn001);
                  }
      }
      break;
    case OR:
      jj_consume_token(OR);
      jj_consume_token(AFTER);
                               SimpleNode jjtn002 = new SimpleNode(JJTTPDURING_OR_AFTER_PERIOD_NODE);
                               boolean jjtc002 = true;
                               jjtree.openNodeScope(jjtn002);
                               jjtreeOpenNodeScope(jjtn002);
      try {
        Period();
      } catch (Throwable jjte002) {
                               if (jjtc002) {
                                 jjtree.clearNodeScope(jjtn002);
                                 jjtc002 = false;
                               } else {
                                 jjtree.popNode();
                               }
                               if (jjte002 instanceof RuntimeException) {
                                 {if (true) throw (RuntimeException)jjte002;}
                               }
                               if (jjte002 instanceof ParseException) {
                                 {if (true) throw (ParseException)jjte002;}
                               }
                               {if (true) throw (Error)jjte002;}
      } finally {
                               if (jjtc002) {
                                 jjtree.closeNodeScope(jjtn002, true);
                                 jjtreeCloseNodeScope(jjtn002);
                               }
      }
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * <date-time expression ::= <date-time> | <period>
 */
  final public void DateTimeExpression() throws ParseException {
    if (jj_2_10(2)) {
      Period();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DATE_TIME:
        DateTime();
        break;
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 *<period> ::= 
 *	  <date-time> "/" <date-time>
 * 	| <date-time> "/" <duration>
 * 	| <duration> "/" <date-time>
 */
  final public void Period() throws ParseException {
    if (jj_2_11(2)) {
      DateTime();
      jj_consume_token(SLASH);
      PeriodTail();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DURATION:
        Duration();
        jj_consume_token(SLASH);
                                     SimpleNode jjtn001 = new SimpleNode(JJTPERIOD_WITH_DURATION_DATE_NODE);
                                     boolean jjtc001 = true;
                                     jjtree.openNodeScope(jjtn001);
                                     jjtreeOpenNodeScope(jjtn001);
        try {
          DateTime();
        } catch (Throwable jjte001) {
                                     if (jjtc001) {
                                       jjtree.clearNodeScope(jjtn001);
                                       jjtc001 = false;
                                     } else {
                                       jjtree.popNode();
                                     }
                                     if (jjte001 instanceof RuntimeException) {
                                       {if (true) throw (RuntimeException)jjte001;}
                                     }
                                     if (jjte001 instanceof ParseException) {
                                       {if (true) throw (ParseException)jjte001;}
                                     }
                                     {if (true) throw (Error)jjte001;}
        } finally {
                                     if (jjtc001) {
                                       jjtree.closeNodeScope(jjtn001, true);
                                       jjtreeCloseNodeScope(jjtn001);
                                     }
        }
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void PeriodTail() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DURATION:
                  SimpleNode jjtn001 = new SimpleNode(JJTPERIOD_WITH_DATE_DURATION_NODE);
                  boolean jjtc001 = true;
                  jjtree.openNodeScope(jjtn001);
                  jjtreeOpenNodeScope(jjtn001);
      try {
        Duration();
      } catch (Throwable jjte001) {
                  if (jjtc001) {
                    jjtree.clearNodeScope(jjtn001);
                    jjtc001 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte001 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte001;}
                  }
                  if (jjte001 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte001;}
                  }
                  {if (true) throw (Error)jjte001;}
      } finally {
                  if (jjtc001) {
                    jjtree.closeNodeScope(jjtn001, true);
                    jjtreeCloseNodeScope(jjtn001);
                  }
      }
      break;
    case DATE_TIME:
                  SimpleNode jjtn002 = new SimpleNode(JJTPERIOD_BETWEEN_DATES_NODE);
                  boolean jjtc002 = true;
                  jjtree.openNodeScope(jjtn002);
                  jjtreeOpenNodeScope(jjtn002);
      try {
        DateTime();
      } catch (Throwable jjte002) {
                  if (jjtc002) {
                    jjtree.clearNodeScope(jjtn002);
                    jjtc002 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte002 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte002;}
                  }
                  if (jjte002 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte002;}
                  }
                  {if (true) throw (Error)jjte002;}
      } finally {
                  if (jjtc002) {
                    jjtree.closeNodeScope(jjtn002, true);
                    jjtreeCloseNodeScope(jjtn002);
                  }
      }
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void DateTime() throws ParseException {
 /*@bgen(jjtree) DateTime_Node */
  SimpleNode jjtn000 = new SimpleNode(JJTDATETIME_NODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(DATE_TIME);
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtreeCloseNodeScope(jjtn000);
          }
    }
  }

/*
 * <duration> ::= "P" <dur-date> | <dur-time>
 * <dur-date> ::= <dur-day> | <dur-month> | <dur-year> [<dur-time>]
 * <dur-day> ::= <digit>... "D"
 * <dur-month> ::= <digit>... "M" [<dur-day>]
 * <dur-year> ::= <digit>... "Y" [<dur-month>]
 */
  final public void Duration() throws ParseException {
                  SimpleNode jjtn001 = new SimpleNode(JJTDURATION_DATE_NODE);
                  boolean jjtc001 = true;
                  jjtree.openNodeScope(jjtn001);
                  jjtreeOpenNodeScope(jjtn001);
    try {
      jj_consume_token(DURATION);
    } finally {
                  if (jjtc001) {
                    jjtree.closeNodeScope(jjtn001, true);
                    jjtreeCloseNodeScope(jjtn001);
                  }
    }
  }

/* ---------------------------------------- *
 *  End <temporal predicate>
 * ---------------------------------------- */

/* ---------------------------------------- *
 *  <existence predicate>
 * ---------------------------------------- */
/*
 * <existence_predicate> ::= <attribute_name> EXISTS
 * | <attribute_name> DOES-NOT-EXIST
 */
  final public void ExistencePredicate() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXISTS:
                  SimpleNode jjtn001 = new SimpleNode(JJTEXISTENCE_PREDICATE_EXISTS_NODE);
                  boolean jjtc001 = true;
                  jjtree.openNodeScope(jjtn001);
                  jjtreeOpenNodeScope(jjtn001);
      try {
        jj_consume_token(EXISTS);
      } finally {
                  if (jjtc001) {
                    jjtree.closeNodeScope(jjtn001, true);
                    jjtreeCloseNodeScope(jjtn001);
                  }
      }
      break;
    case DOES_NOT_EXIST:
                  SimpleNode jjtn002 = new SimpleNode(JJTEXISTENCE_PREDICATE_DOESNOTEXIST_NODE);
                  boolean jjtc002 = true;
                  jjtree.openNodeScope(jjtn002);
                  jjtreeOpenNodeScope(jjtn002);
      try {
        jj_consume_token(DOES_NOT_EXIST);
      } finally {
                  if (jjtc002) {
                    jjtree.closeNodeScope(jjtn002, true);
                    jjtreeCloseNodeScope(jjtn002);
                  }
      }
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* ---------------------------------------- *
 *  end <existence predicate>
 * ---------------------------------------- */
  final public void TextPredicate() throws ParseException {
    if (jj_2_12(2)) {
      jj_consume_token(NOT);
      jj_consume_token(LIKE);
                                             SimpleNode jjtn001 = new SimpleNode(JJTNOT_LIKE_NODE);
                                             boolean jjtc001 = true;
                                             jjtree.openNodeScope(jjtn001);
                                             jjtreeOpenNodeScope(jjtn001);
      try {
        CharacterPattern();
      } catch (Throwable jjte001) {
                                             if (jjtc001) {
                                               jjtree.clearNodeScope(jjtn001);
                                               jjtc001 = false;
                                             } else {
                                               jjtree.popNode();
                                             }
                                             if (jjte001 instanceof RuntimeException) {
                                               {if (true) throw (RuntimeException)jjte001;}
                                             }
                                             if (jjte001 instanceof ParseException) {
                                               {if (true) throw (ParseException)jjte001;}
                                             }
                                             {if (true) throw (Error)jjte001;}
      } finally {
                                             if (jjtc001) {
                                               jjtree.closeNodeScope(jjtn001, true);
                                               jjtreeCloseNodeScope(jjtn001);
                                             }
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIKE:
        jj_consume_token(LIKE);
                                       SimpleNode jjtn002 = new SimpleNode(JJTLIKE_NODE);
                                       boolean jjtc002 = true;
                                       jjtree.openNodeScope(jjtn002);
                                       jjtreeOpenNodeScope(jjtn002);
        try {
          CharacterPattern();
        } catch (Throwable jjte002) {
                                       if (jjtc002) {
                                         jjtree.clearNodeScope(jjtn002);
                                         jjtc002 = false;
                                       } else {
                                         jjtree.popNode();
                                       }
                                       if (jjte002 instanceof RuntimeException) {
                                         {if (true) throw (RuntimeException)jjte002;}
                                       }
                                       if (jjte002 instanceof ParseException) {
                                         {if (true) throw (ParseException)jjte002;}
                                       }
                                       {if (true) throw (Error)jjte002;}
        } finally {
                                       if (jjtc002) {
                                         jjtree.closeNodeScope(jjtn002, true);
                                         jjtreeCloseNodeScope(jjtn002);
                                       }
        }
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void CharacterPattern() throws ParseException {
    StringLiteral();
  }

/*
 * Cql Extension
 * 
 *	<beween predicate>::= ["NOT"] "BETWEEN" expression "AND" expression
 */
  final public void BetweenPredicate() throws ParseException {
    if (jj_2_13(2)) {
      jj_consume_token(NOT);
      jj_consume_token(BETWEEN);
      Expression();
      jj_consume_token(AND);
                                                          SimpleNode jjtn001 = new SimpleNode(JJTNOT_BETWEEN_NODE);
                                                          boolean jjtc001 = true;
                                                          jjtree.openNodeScope(jjtn001);
                                                          jjtreeOpenNodeScope(jjtn001);
      try {
        Expression();
      } catch (Throwable jjte001) {
                                                          if (jjtc001) {
                                                            jjtree.clearNodeScope(jjtn001);
                                                            jjtc001 = false;
                                                          } else {
                                                            jjtree.popNode();
                                                          }
                                                          if (jjte001 instanceof RuntimeException) {
                                                            {if (true) throw (RuntimeException)jjte001;}
                                                          }
                                                          if (jjte001 instanceof ParseException) {
                                                            {if (true) throw (ParseException)jjte001;}
                                                          }
                                                          {if (true) throw (Error)jjte001;}
      } finally {
                                                          if (jjtc001) {
                                                            jjtree.closeNodeScope(jjtn001, true);
                                                            jjtreeCloseNodeScope(jjtn001);
                                                          }
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BETWEEN:
        jj_consume_token(BETWEEN);
        Expression();
        jj_consume_token(AND);
                                                                SimpleNode jjtn002 = new SimpleNode(JJTBETWEEN_NODE);
                                                                boolean jjtc002 = true;
                                                                jjtree.openNodeScope(jjtn002);
                                                                jjtreeOpenNodeScope(jjtn002);
        try {
          Expression();
        } catch (Throwable jjte002) {
                                                                if (jjtc002) {
                                                                  jjtree.clearNodeScope(jjtn002);
                                                                  jjtc002 = false;
                                                                } else {
                                                                  jjtree.popNode();
                                                                }
                                                                if (jjte002 instanceof RuntimeException) {
                                                                  {if (true) throw (RuntimeException)jjte002;}
                                                                }
                                                                if (jjte002 instanceof ParseException) {
                                                                  {if (true) throw (ParseException)jjte002;}
                                                                }
                                                                {if (true) throw (Error)jjte002;}
        } finally {
                                                                if (jjtc002) {
                                                                  jjtree.closeNodeScope(jjtn002, true);
                                                                  jjtreeCloseNodeScope(jjtn002);
                                                                }
        }
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 * cql extension
 */
  final public void Expression() throws ParseException {
    BinaryExpression();
  }

  final public void BinaryExpression() throws ParseException {
    MultiplicativeExpression();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
             SimpleNode jjtn001 = new SimpleNode(JJTADDNODE);
             boolean jjtc001 = true;
             jjtree.openNodeScope(jjtn001);
             jjtreeOpenNodeScope(jjtn001);
        try {
          MultiplicativeExpression();
        } catch (Throwable jjte001) {
             if (jjtc001) {
               jjtree.clearNodeScope(jjtn001);
               jjtc001 = false;
             } else {
               jjtree.popNode();
             }
             if (jjte001 instanceof RuntimeException) {
               {if (true) throw (RuntimeException)jjte001;}
             }
             if (jjte001 instanceof ParseException) {
               {if (true) throw (ParseException)jjte001;}
             }
             {if (true) throw (Error)jjte001;}
        } finally {
             if (jjtc001) {
               jjtree.closeNodeScope(jjtn001,  2);
               jjtreeCloseNodeScope(jjtn001);
             }
        }
        break;
      case MINUS:
        jj_consume_token(MINUS);
              SimpleNode jjtn002 = new SimpleNode(JJTSUBTRACTNODE);
              boolean jjtc002 = true;
              jjtree.openNodeScope(jjtn002);
              jjtreeOpenNodeScope(jjtn002);
        try {
          MultiplicativeExpression();
        } catch (Throwable jjte002) {
              if (jjtc002) {
                jjtree.clearNodeScope(jjtn002);
                jjtc002 = false;
              } else {
                jjtree.popNode();
              }
              if (jjte002 instanceof RuntimeException) {
                {if (true) throw (RuntimeException)jjte002;}
              }
              if (jjte002 instanceof ParseException) {
                {if (true) throw (ParseException)jjte002;}
              }
              {if (true) throw (Error)jjte002;}
        } finally {
              if (jjtc002) {
                jjtree.closeNodeScope(jjtn002,  2);
                jjtreeCloseNodeScope(jjtn002);
              }
        }
        break;
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void MultiplicativeExpression() throws ParseException {
    UnaryExpression();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SLASH:
      case MULT:
        ;
        break;
      default:
        jj_la1[26] = jj_gen;
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULT:
        jj_consume_token(MULT);
             SimpleNode jjtn001 = new SimpleNode(JJTMULNODE);
             boolean jjtc001 = true;
             jjtree.openNodeScope(jjtn001);
             jjtreeOpenNodeScope(jjtn001);
        try {
          UnaryExpression();
        } catch (Throwable jjte001) {
             if (jjtc001) {
               jjtree.clearNodeScope(jjtn001);
               jjtc001 = false;
             } else {
               jjtree.popNode();
             }
             if (jjte001 instanceof RuntimeException) {
               {if (true) throw (RuntimeException)jjte001;}
             }
             if (jjte001 instanceof ParseException) {
               {if (true) throw (ParseException)jjte001;}
             }
             {if (true) throw (Error)jjte001;}
        } finally {
             if (jjtc001) {
               jjtree.closeNodeScope(jjtn001,  2);
               jjtreeCloseNodeScope(jjtn001);
             }
        }
        break;
      case SLASH:
        jj_consume_token(SLASH);
              SimpleNode jjtn002 = new SimpleNode(JJTDIVNODE);
              boolean jjtc002 = true;
              jjtree.openNodeScope(jjtn002);
              jjtreeOpenNodeScope(jjtn002);
        try {
          UnaryExpression();
        } catch (Throwable jjte002) {
              if (jjtc002) {
                jjtree.clearNodeScope(jjtn002);
                jjtc002 = false;
              } else {
                jjtree.popNode();
              }
              if (jjte002 instanceof RuntimeException) {
                {if (true) throw (RuntimeException)jjte002;}
              }
              if (jjte002 instanceof ParseException) {
                {if (true) throw (ParseException)jjte002;}
              }
              {if (true) throw (Error)jjte002;}
        } finally {
              if (jjtc002) {
                jjtree.closeNodeScope(jjtn002,  2);
                jjtreeCloseNodeScope(jjtn002);
              }
        }
        break;
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void UnaryExpression() throws ParseException {
    if (jj_2_14(2147483647)) {
      Function();
    } else if (jj_2_15(2147483647)) {
      Attribute();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
      case TRUE:
      case FALSE:
      case INTEGER_LITERAL:
      case FLOATING_LITERAL:
        Literal();
        break;
      case LP:
        jj_consume_token(LP);
        Expression();
        jj_consume_token(RP);
        break;
      case LSP:
        jj_consume_token(LSP);
        Expression();
        jj_consume_token(RSP);
        break;
      default:
        jj_la1[28] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void Evaluate() throws ParseException {
    if (jj_2_16(2147483647)) {
      Function();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        Attribute();
        break;
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
 * <identifier> ::= <identifier part> [ { <colon> | <identifier part> }... ] 
 */
  final public void Identifier() throws ParseException {
 /*@bgen(jjtree) Identifier_Node */
  SimpleNode jjtn000 = new SimpleNode(JJTIDENTIFIER_NODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      IdentifierPart();
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COLON:
        case IDENTIFIER:
          ;
          break;
        default:
          jj_la1[30] = jj_gen;
          break label_6;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COLON:
          jj_consume_token(COLON);
          break;
        case IDENTIFIER:
          IdentifierPart();
          break;
        default:
          jj_la1[31] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtreeCloseNodeScope(jjtn000);
          }
    }
  }

  final public void IdentifierPart() throws ParseException {
  /*@bgen(jjtree) Identifier_Part_Node */
  SimpleNode jjtn000 = new SimpleNode(JJTIDENTIFIER_PART_NODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(IDENTIFIER);
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtreeCloseNodeScope(jjtn000);
          }
    }
  }

/*
 * <attribute name> ::= 
 *  	  <simple attribute name> 
 * 		| <compound attribute name>
 * 
 * <compound attribute name> ::= 
 * 		<identifier><period> [{<identifier><period>}*] <simple attribute name>
 *
 * <simple attribute name> ::= <identifier>
 */
  final public void Attribute() throws ParseException {
    SimpleAttributeName();
    AttributeTail();
  }

/*
 * <simple attribute name> ::= <identifier>
 */
  final public void SimpleAttributeName() throws ParseException {
 /*@bgen(jjtree) Simple_Attribute_Node */
  SimpleNode jjtn000 = new SimpleNode(JJTSIMPLE_ATTRIBUTE_NODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      Identifier();
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtreeCloseNodeScope(jjtn000);
          }
    }
  }

  final public void AttributeTail() throws ParseException {
 /*@bgen(jjtree) Compound_Attribute_Node */
  SimpleNode jjtn000 = new SimpleNode(JJTCOMPOUND_ATTRIBUTE_NODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PERIOD:
          ;
          break;
        default:
          jj_la1[32] = jj_gen;
          break label_7;
        }
        jj_consume_token(PERIOD);
        SimpleAttributeName();
      }
    } catch (Throwable jjte000) {
           if (jjtc000) {
             jjtree.clearNodeScope(jjtn000);
             jjtc000 = false;
           } else {
             jjtree.popNode();
           }
           if (jjte000 instanceof RuntimeException) {
             {if (true) throw (RuntimeException)jjte000;}
           }
           if (jjte000 instanceof ParseException) {
             {if (true) throw (ParseException)jjte000;}
           }
           {if (true) throw (Error)jjte000;}
    } finally {
           if (jjtc000) {
             jjtree.closeNodeScope(jjtn000, true);
             jjtreeCloseNodeScope(jjtn000);
           }
    }
  }

/*
 * <literal> ::= 
 *			<signed numeric literal>
 * 		| 	<general literal>
 */
  final public void Literal() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
    case FLOATING_LITERAL:
      SignedNumericLiteral();
      break;
    case STRING_LITERAL:
    case TRUE:
    case FALSE:
      GeneralLiteral();
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void SignedNumericLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      IntegerLiteral();
      break;
    case FLOATING_LITERAL:
      FloatingLiteral();
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 *<general literal> ::= 
 * 			<character string literal>
 * 		| 	<datetime literal>
 * 		| 	<boolean literal>
 * 		| 	<geography literal
 */
  final public void GeneralLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      StringLiteral();
      break;
    case TRUE:
    case FALSE:
      BooleanLiteral();
      break;
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void IntegerLiteral() throws ParseException {
 /*@bgen(jjtree) IntegerNode */
  SimpleNode jjtn000 = new SimpleNode(JJTINTEGERNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(INTEGER_LITERAL);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void FloatingLiteral() throws ParseException {
 /*@bgen(jjtree) FloatingNode */
  SimpleNode jjtn000 = new SimpleNode(JJTFLOATINGNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(FLOATING_LITERAL);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

  final public void BooleanLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
    SimpleNode jjtn001 = new SimpleNode(JJTTRUENODE);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001);
    jjtreeOpenNodeScope(jjtn001);
      try {
        jj_consume_token(TRUE);
      } finally {
    if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, true);
      jjtreeCloseNodeScope(jjtn001);
    }
      }
      break;
    case FALSE:
    SimpleNode jjtn002 = new SimpleNode(JJTFALSENODE);
    boolean jjtc002 = true;
    jjtree.openNodeScope(jjtn002);
    jjtreeOpenNodeScope(jjtn002);
      try {
        jj_consume_token(FALSE);
      } finally {
    if (jjtc002) {
      jjtree.closeNodeScope(jjtn002, true);
      jjtreeCloseNodeScope(jjtn002);
    }
      }
      break;
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void StringLiteral() throws ParseException {
 /*@bgen(jjtree) StringNode */
  SimpleNode jjtn000 = new SimpleNode(JJTSTRINGNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(STRING_LITERAL);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

/* ---------------------------------------- *
 *  <function>
 * ---------------------------------------- */
/*
 * <function> ::= <function name> "("<function arg> [,<function arg>]*)
 */
  final public void Function() throws ParseException {
 /*@bgen(jjtree) Function_Node */
  SimpleNode jjtn000 = new SimpleNode(JJTFUNCTION_NODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      FunctionName();
      jj_consume_token(LP);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
      case TRUE:
      case FALSE:
      case LP:
      case LSP:
      case INTEGER_LITERAL:
      case FLOATING_LITERAL:
      case IDENTIFIER:
        FunctionArg();
        label_8:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[37] = jj_gen;
            break label_8;
          }
          jj_consume_token(COMMA);
          FunctionArg();
        }
        break;
      default:
        jj_la1[38] = jj_gen;
        ;
      }
      jj_consume_token(RP);
    } catch (Throwable jjte000) {
                  if (jjtc000) {
                    jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte000 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte000;}
                  }
                  if (jjte000 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte000;}
                  }
                  {if (true) throw (Error)jjte000;}
    } finally {
                  if (jjtc000) {
                    jjtree.closeNodeScope(jjtn000, true);
                    jjtreeCloseNodeScope(jjtn000);
                  }
    }
  }

  final public void FunctionName() throws ParseException {
 /*@bgen(jjtree) FunctionName_Node */
  SimpleNode jjtn000 = new SimpleNode(JJTFUNCTIONNAME_NODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jj_consume_token(IDENTIFIER);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtreeCloseNodeScope(jjtn000);
      }
    }
  }

/*
 * <argument>  ::= 
 *      <literal>  
 *  |   <attribute name>                                            
 * 	|	<expression> (*extension: expression includes literal and attributes*) 
 */
  final public void FunctionArg() throws ParseException {
 /*@bgen(jjtree) FunctionArg_Node */
  SimpleNode jjtn000 = new SimpleNode(JJTFUNCTIONARG_NODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      Expression();
    } catch (Throwable jjte000) {
                  if (jjtc000) {
                    jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte000 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte000;}
                  }
                  if (jjte000 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte000;}
                  }
                  {if (true) throw (Error)jjte000;}
    } finally {
                  if (jjtc000) {
                    jjtree.closeNodeScope(jjtn000, true);
                    jjtreeCloseNodeScope(jjtn000);
                  }
    }
  }

/* ---------------------------------------- *
 *  end <function>
 * ---------------------------------------- */

/*
 * <Point> := <x><space><y>
 */
  final public void Point() throws ParseException {
    NumericLiteral();
    NumericLiteral();
  }

/*
 * <LineString Text> := EMPTY
 * | <left paren><Point>{<comma><Point >} ... <right paren>
 */
  final public void LineStringText() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LP:
      jj_consume_token(LP);
      Point();
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[39] = jj_gen;
          break label_9;
        }
        jj_consume_token(COMMA);
        Point();
      }
      jj_consume_token(RP);
      break;
    default:
      jj_la1[40] = jj_gen;
      ;
    }
  }

  final public void PointTaggedText() throws ParseException {
 /*@bgen(jjtree) WKTNode */
  SimpleNode jjtn000 = new SimpleNode(JJTWKTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jjtn000.token = jj_consume_token(POINT);
      PointText();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

/*
 * <Point Text> := EMPTY | <left paren> <Point> <right paren>
 */
  final public void PointText() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LP:
      jj_consume_token(LP);
      Point();
      jj_consume_token(RP);
      break;
    default:
      jj_la1[41] = jj_gen;
      ;
    }
  }

  final public void LineStringTaggedText() throws ParseException {
 /*@bgen(jjtree) WKTNode */
  SimpleNode jjtn000 = new SimpleNode(JJTWKTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jjtn000.token = jj_consume_token(LINESTRING);
      LineStringText();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

/*
 * <Polygon Tagged Text> := POLYGON <Polygon Text>
 */
  final public void PolygonTaggedText() throws ParseException {
 /*@bgen(jjtree) WKTNode */
  SimpleNode jjtn000 = new SimpleNode(JJTWKTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jjtn000.token = jj_consume_token(POLYGON);
      PolygonText();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

/*
 * <Polygon Text> := EMPTY
 *  	| <left paren><LineString Text>{<comma><LineString Text>}*<right paren>
 */
  final public void PolygonText() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LP:
      jj_consume_token(LP);
      LineStringText();
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[42] = jj_gen;
          break label_10;
        }
        jj_consume_token(COMMA);
        LineStringText();
      }
      jj_consume_token(RP);
      break;
    default:
      jj_la1[43] = jj_gen;
      ;
    }
  }

/*
 * <MultiPoint Tagged Text> ::= MULTIPOINT <Multipoint Text>
 */
  final public void MultiPointTaggedText() throws ParseException {
 /*@bgen(jjtree) WKTNode */
  SimpleNode jjtn000 = new SimpleNode(JJTWKTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jjtn000.token = jj_consume_token(MULTIPOINT);
      MultiPointText();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

/*
 * <Multipoint Text> := EMPTY
 * 	| ( <Point Text > {, <Point Text > }* )
 */
  final public void MultiPointText() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LP:
      jj_consume_token(LP);
      PointText();
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[44] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
        PointText();
      }
      jj_consume_token(RP);
      break;
    default:
      jj_la1[45] = jj_gen;
      ;
    }
  }

/*
 * <MultiLineString Tagged Text> := MULTILINESTRING <MultiLineString Text>
 */
  final public void MultiLineStringTaggedText() throws ParseException {
 /*@bgen(jjtree) WKTNode */
  SimpleNode jjtn000 = new SimpleNode(JJTWKTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jjtn000.token = jj_consume_token(MULTILINESTRING);
      MultiLineStringText();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

/*
 * <MultiLineString Text> := 
 *		EMPTY
 * 		| ( <LineString Text > {, < LineString Text > }* )
 */
  final public void MultiLineStringText() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LP:
      jj_consume_token(LP);
      LineStringText();
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[46] = jj_gen;
          break label_12;
        }
        jj_consume_token(COMMA);
        LineStringText();
      }
      jj_consume_token(RP);
      break;
    default:
      jj_la1[47] = jj_gen;
      ;
    }
  }

/*
 * <MultiPolygon Tagged Text> :: =MULTIPOLYGON <MultiPolygon Text>
 */
  final public void MultiPolygonTaggedText() throws ParseException {
 /*@bgen(jjtree) WKTNode */
  SimpleNode jjtn000 = new SimpleNode(JJTWKTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jjtn000.token = jj_consume_token(MULTIPOLYGON);
      MultiPolygonText();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

/*
 * <MultiPolygon Text> := EMPTY
 * 	| <left paren><Polygon Text>{<comma><Polygon Text>}* <right paren>
 */
  final public void MultiPolygonText() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LP:
      jj_consume_token(LP);
      PolygonText();
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[48] = jj_gen;
          break label_13;
        }
        jj_consume_token(COMMA);
        PolygonText();
      }
      jj_consume_token(RP);
      break;
    default:
      jj_la1[49] = jj_gen;
      ;
    }
  }

  final public void GeometryCollectionTaggedText() throws ParseException {
 /*@bgen(jjtree) WKTNode */
  SimpleNode jjtn000 = new SimpleNode(JJTWKTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jjtn000.token = jj_consume_token(GEOMETRYCOLLECTION);
      GeometryCollectionText();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtreeCloseNodeScope(jjtn000);
    }
    }
  }

/*
 * <GeometryCollection Text> := EMPTY
 * | ( <Geometry Tagged Text> {, <Geometry Tagged Text> }* )
 */
  final public void GeometryCollectionText() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LP:
      jj_consume_token(LP);
      GeometryLiteral();
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[50] = jj_gen;
          break label_14;
        }
        jj_consume_token(COMMA);
        GeometryLiteral();
      }
      jj_consume_token(RP);
      break;
    default:
      jj_la1[51] = jj_gen;
      ;
    }
  }

/*
 * <Envelope Tagged Text> ::= ENVELOPE <Envelope Text>
 */
  final public void EnvelopeTaggedText() throws ParseException {
  /*@bgen(jjtree) EnvelopeTaggedText_Node */
  SimpleNode jjtn000 = new SimpleNode(JJTENVELOPETAGGEDTEXT_NODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
    try {
      jjtn000.token = jj_consume_token(ENVELOPE);
      EnvelopText();
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtreeCloseNodeScope(jjtn000);
          }
    }
  }

/*
 * <Envelope Text> := EMPTY
 * | <left paren>
 *		<WestBoundLongitude><comma>
 *   	<EastBoundLongitude><comma>
 *   	<NorthBoundLatitude><comma>
 *   	<SouthBoundLatitude>
 *	<right paren>
 * <WestBoundLongitude> := numeric literal
 * <EastBoundLongitude> := numeric literal
 * <NorthBoundLatitude> := numeric literal
 * <SouthBoundLatitude> := numeric literal
 */
  final public void EnvelopText() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LP:
      jj_consume_token(LP);
      NumericLiteral();
      jj_consume_token(COMMA);
      NumericLiteral();
      jj_consume_token(COMMA);
      NumericLiteral();
      jj_consume_token(COMMA);
      NumericLiteral();
      jj_consume_token(RP);
      break;
    default:
      jj_la1[52] = jj_gen;
      ;
    }
  }

  final public void NumericLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FLOATING_LITERAL:
      jj_consume_token(FLOATING_LITERAL);
      break;
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    default:
      jj_la1[53] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_3R_106() {
    if (jj_scan_token(SLASH)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_105() {
    if (jj_scan_token(MULT)) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_97() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) return true;
    }
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_3R_26()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_57()) return true;
    if (jj_scan_token(AND)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_scan_token(EXCLUDE)) return true;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_3R_96()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_97()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_48() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    }
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_scan_token(INCLUDE)) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_scan_token(LSP)) return true;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_scan_token(LP)) return true;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_3R_48()) return true;
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_93()) return true;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3R_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3_3()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  final private boolean jj_3R_98() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_93()) return true;
    return false;
  }

  final private boolean jj_3R_94() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) return true;
    }
    return false;
  }

  final private boolean jj_3R_89() {
    if (jj_3R_93()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_94()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_3R_89()) return true;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(LIKE)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_3R_59()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_60()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) return true;
    }
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_57()) return true;
    if (jj_scan_token(AND)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) return true;
    }
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(LIKE)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_83()) return true;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_3R_44()) return true;
    if (jj_scan_token(LP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_45()) jj_scanpos = xsp;
    if (jj_scan_token(RP)) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_scan_token(DOES_NOT_EXIST)) return true;
    return false;
  }

  final private boolean jj_3R_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) return true;
    }
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(DURATION)) return true;
    return false;
  }

  final private boolean jj_3R_123() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  final private boolean jj_3R_122() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  final private boolean jj_3R_121() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) return true;
    }
    return false;
  }

  final private boolean jj_3R_120() {
    if (jj_scan_token(FLOATING_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_112() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3R_111() {
    if (jj_3R_58()) return true;
    return false;
  }

  final private boolean jj_3R_108() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    }
    return false;
  }

  final private boolean jj_3R_119() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_scan_token(DATE_TIME)) return true;
    return false;
  }

  final private boolean jj_3R_118() {
    if (jj_3R_121()) return true;
    return false;
  }

  final private boolean jj_3R_117() {
    if (jj_3R_83()) return true;
    return false;
  }

  final private boolean jj_3R_114() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_117()) {
    jj_scanpos = xsp;
    if (jj_3R_118()) return true;
    }
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_3R_58()) return true;
    if (jj_scan_token(SLASH)) return true;
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3R_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) return true;
    }
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_24()) return true;
    if (jj_scan_token(SLASH)) return true;
    if (jj_3R_108()) return true;
    return false;
  }

  final private boolean jj_3R_110() {
    if (jj_3R_114()) return true;
    return false;
  }

  final private boolean jj_3R_109() {
    if (jj_3R_113()) return true;
    return false;
  }

  final private boolean jj_3R_107() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) return true;
    }
    return false;
  }

  final private boolean jj_3R_115() {
    if (jj_3R_119()) return true;
    return false;
  }

  final private boolean jj_3R_113() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) return true;
    }
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_scan_token(BEYOND)) return true;
    return false;
  }

  final private boolean jj_3R_81() {
    if (jj_scan_token(DWITHIN)) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    }
    return false;
  }

  final private boolean jj_3R_116() {
    if (jj_3R_120()) return true;
    return false;
  }

  final private boolean jj_3R_92() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3R_86() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) return true;
    }
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3R_88() {
    if (jj_scan_token(OR)) return true;
    if (jj_scan_token(AFTER)) return true;
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(PERIOD)) return true;
    if (jj_3R_46()) return true;
    return false;
  }

  final private boolean jj_3R_87() {
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) return true;
    }
    return false;
  }

  final private boolean jj_3R_47() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_62()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_3R_86()) return true;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_3R_61()) return true;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_3R_46()) return true;
    if (jj_3R_47()) return true;
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_3R_90()) return true;
    return false;
  }

  final private boolean jj_3R_85() {
    if (jj_scan_token(OR)) return true;
    if (jj_scan_token(DURING)) return true;
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3R_84() {
    if (jj_3R_86()) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) return true;
    }
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_scan_token(DURING)) return true;
    if (jj_3R_56()) return true;
    return false;
  }

  final private boolean jj_3R_91() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_3R_95()) return true;
    }
    return false;
  }

  final private boolean jj_3R_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_scan_token(BEFORE)) return true;
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_scan_token(AFTER)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_scan_token(RELATE)) return true;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_scan_token(OVERLAPS)) return true;
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_scan_token(CONTAINS)) return true;
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_scan_token(BBOX)) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_scan_token(WITHIN)) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_scan_token(CROSSES)) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_scan_token(TOUCHES)) return true;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_scan_token(INTERSECTS)) return true;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_3R_52()) return true;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_3R_90()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_91()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_scan_token(DISJOINT)) return true;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_3R_51()) return true;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_scan_token(EQUALS)) return true;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_3R_50()) return true;
    return false;
  }

  final private boolean jj_3R_17() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = isGeoOp();
    lookingAhead = false;
    if (!jj_semLA || jj_3R_32()) {
    jj_scanpos = xsp;
    lookingAhead = true;
    jj_semLA = isRelGeoOp();
    lookingAhead = false;
    if (!jj_semLA || jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_50() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) return true;
    }
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_21()) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_20()) return true;
    return false;
  }

  final private boolean jj_3R_104() {
    if (jj_scan_token(LSP)) return true;
    if (jj_3R_57()) return true;
    if (jj_scan_token(RSP)) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3R_103() {
    if (jj_scan_token(LP)) return true;
    if (jj_3R_57()) return true;
    if (jj_scan_token(RP)) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_18()) return true;
    return false;
  }

  final private boolean jj_3R_102() {
    if (jj_3R_107()) return true;
    return false;
  }

  final private boolean jj_3R_101() {
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3R_100() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_96() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_scan_token(NEQ)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_scan_token(EQ)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_scan_token(LTE)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_scan_token(GTE)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(GT)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  public CQLParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[54];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0x100,0x80,0x200,0x1800000,0xfc00,0x0,0x0,0x0,0x0,0x0,0xfe000000,0x1800000,0xfc00,0x200000,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x80000,0x100000,0x0,0x0,0x0,0x0,0x30040,0x0,0x0,0x0,0x0,0x30040,0x0,0x30040,0x30000,0x0,0x30040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x20000000,0x0,0x0,0x0,0x5000000,0x0,0x0,0x1ff80,0x12000000,0x60000,0xf80000,0x1,0x0,0x0,0x0,0xe,0x0,0x0,0x0,0x0,0x0,0x60,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x5000000,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x10000000,0x5000000,0x10000000,0x1000000,0x1000000,0x10000000,0x1000000,0x10000000,0x1000000,0x10000000,0x1000000,0x10000000,0x1000000,0x10000000,0x1000000,0x1000000,0x0,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x48000,0x48000,0x40000,0x8000,0x48000,0x0,0x0,0x0,0xc,0xc,0x2,0x2,0x60,0x80000,0x80001,0x80001,0x0,0x60,0x60,0x0,0x0,0x0,0x80060,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[16];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public CQLParser(java.io.InputStream stream) {
     this(stream, null);
  }
  public CQLParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new CQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 54; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 54; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public CQLParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new CQLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 54; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 54; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public CQLParser(CQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 54; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(CQLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 54; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[88];
    for (int i = 0; i < 88; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 54; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 88; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 16; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
