/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 * 
 *    (C) 2005-2008, Open Source Geospatial Foundation (OSGeo)
 *    
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.renderer.style.customshape;

import java.awt.Shape;
import java.awt.geom.GeneralPath;

/**
 * ShapeCreator for a diamond shape.
 * 
 * @author fabiomano
 */
public class DiamondShapeCreator extends AbstractShapeCreator
{
    private static final String SHAPE_NAME = "diamond";

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.geotools.renderer.style.customshape.AbstractShapeCreator#createShape
     * (org
     * .geotools.renderer.style.customshape.AbstractShapeCreator.Parameter<java
     * .lang.String>[])
     */
    @Override
    protected Shape createShape(Parameter<String>... parameters)
    {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(-0.5f, 0);
        gp.lineTo(0, -0.5f);
        gp.lineTo(0.5f, 0);
        gp.lineTo(0, 0.5f);
        gp.lineTo(-0.5f, 0);
        gp.closePath();

        return gp;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.geotools.renderer.style.customshape.ShapeCreator#getShapeName()
     */
    @Override
    public String getShapeName()
    {
        return SHAPE_NAME;
    }

    public String buildShapeSpecification()
    {
        return getShapeName();
    }
}
