/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen.info;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.geotools.data.gen.info.Generalization;
import org.geotools.data.gen.info.GeneralizationInfo;
import org.geotools.data.gen.info.GeneralizationInfos;
import org.geotools.data.gen.info.GeneralizationInfosProvider;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GeneralizationInfosProviderImpl
implements GeneralizationInfosProvider {
    protected static final String GENERALIZATION_INFOS_TAG = "GeneralizationInfos";
    protected static final String GENERALIZATION_INFO_TAG = "GeneralizationInfo";
    protected static final String GENERALIZATION_TAG = "Generalization";
    protected static final String FEATURE_NAME_ATTR = "featureName";
    protected static final String BASE_FEATURE_NAME_ATTR = "baseFeatureName";
    protected static final String GEOM_PROPERTY_NAME_ATTR = "geomPropertyName";
    protected static final String DISTANCE_ATTR = "distance";
    protected static final String DATASOURCE_NAME_ATTR = "dataSourceName";
    protected static final String DATASOURCE_NAMESPACE_NAME_ATTR = "dataSourceNameSpace";
    protected static final String VERSION_ATTR = "version";
    protected static Validator VALIDATOR;

    public GeneralizationInfos getGeneralizationInfos(Object source) throws IOException {
        URL inputURL = this.deriveURLFromSourceObject(source);
        GeneralizationInfos infos = this.parseXML(inputURL);
        infos.validate();
        return infos;
    }

    protected URL deriveURLFromSourceObject(Object source) throws IOException {
        if (source == null) {
            throw new IOException("Cannot read from null");
        }
        if (source instanceof URL) {
            return (URL)source;
        }
        if (source instanceof String) {
            URL url = null;
            File f = new File((String)source);
            url = f.exists() ? f.toURI().toURL() : new URL((String)source);
            url = new URL(URLDecoder.decode(url.toExternalForm(), "UTF8"));
            return url;
        }
        if (source instanceof URI) {
            return ((URI)source).toURL();
        }
        return null;
    }

    protected GeneralizationInfos parseXML(URL url) throws IOException {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            doc = db.parse(url.openStream());
            VALIDATOR.validate(new DOMSource(doc));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        NodeList nl = doc.getElementsByTagName(GENERALIZATION_INFOS_TAG);
        GeneralizationInfos gInfos = new GeneralizationInfos();
        Node gInfosNode = nl.item(0);
        this.checkVersion(gInfosNode);
        NamedNodeMap attrMap = gInfosNode.getAttributes();
        if (attrMap.getNamedItem(DATASOURCE_NAME_ATTR) != null) {
            gInfos.setDataSourceName(attrMap.getNamedItem(DATASOURCE_NAME_ATTR).getTextContent());
        }
        if (attrMap.getNamedItem(DATASOURCE_NAMESPACE_NAME_ATTR) != null) {
            gInfos.setDataSourceNameSpace(attrMap.getNamedItem(DATASOURCE_NAMESPACE_NAME_ATTR).getTextContent());
        }
        this.parseGeneralizationInfoNodes(gInfosNode, gInfos);
        return gInfos;
    }

    protected void parseGeneralizationInfoNodes(Node parentNode, GeneralizationInfos gInfos) {
        NodeList nl = parentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node generalisationInfoNode = nl.item(i);
            if (!GENERALIZATION_INFO_TAG.equals(generalisationInfoNode.getNodeName())) continue;
            NamedNodeMap attrMap = generalisationInfoNode.getAttributes();
            String baseFeatureName = attrMap.getNamedItem(BASE_FEATURE_NAME_ATTR).getTextContent();
            String featureName = attrMap.getNamedItem(FEATURE_NAME_ATTR).getTextContent();
            String geomPropertyName = null;
            if (attrMap.getNamedItem(GEOM_PROPERTY_NAME_ATTR) != null) {
                geomPropertyName = attrMap.getNamedItem(GEOM_PROPERTY_NAME_ATTR).getTextContent();
            }
            GeneralizationInfo gi = new GeneralizationInfo(baseFeatureName, featureName, geomPropertyName, gInfos);
            if (attrMap.getNamedItem(DATASOURCE_NAME_ATTR) != null) {
                gi.setDataSourceName(attrMap.getNamedItem(DATASOURCE_NAME_ATTR).getTextContent());
            }
            if (attrMap.getNamedItem(DATASOURCE_NAMESPACE_NAME_ATTR) != null) {
                gi.setDataSourceNameSpace(attrMap.getNamedItem(DATASOURCE_NAMESPACE_NAME_ATTR).getTextContent());
            }
            this.parseDistanceInfoNodes(generalisationInfoNode, gi);
            gInfos.addGeneralizationInfo(gi);
        }
    }

    protected void parseDistanceInfoNodes(Node parentNode, GeneralizationInfo gInfo) {
        NodeList nl = parentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node distanceInfoNode = nl.item(i);
            if (!GENERALIZATION_TAG.equals(distanceInfoNode.getNodeName())) continue;
            NamedNodeMap attrMap = distanceInfoNode.getAttributes();
            Double distance = new Double(attrMap.getNamedItem(DISTANCE_ATTR).getTextContent());
            String featureName = attrMap.getNamedItem(FEATURE_NAME_ATTR).getTextContent();
            String geomPropertyName = null;
            if (attrMap.getNamedItem(GEOM_PROPERTY_NAME_ATTR) != null) {
                geomPropertyName = attrMap.getNamedItem(GEOM_PROPERTY_NAME_ATTR).getTextContent();
            }
            Generalization di = new Generalization(distance, featureName, geomPropertyName, gInfo);
            if (attrMap.getNamedItem(DATASOURCE_NAME_ATTR) != null) {
                di.setDataSourceName(attrMap.getNamedItem(DATASOURCE_NAME_ATTR).getTextContent());
            }
            if (attrMap.getNamedItem(DATASOURCE_NAMESPACE_NAME_ATTR) != null) {
                di.setDataSourceNameSpace(attrMap.getNamedItem(DATASOURCE_NAMESPACE_NAME_ATTR).getTextContent());
            }
            gInfo.getGeneralizations().add(di);
        }
    }

    protected void checkVersion(Node gInfos) throws IOException {
        String version = gInfos.getAttributes().getNamedItem(VERSION_ATTR).getTextContent();
        if (!"1.0".equals(version)) {
            throw new IOException(gInfos.getLocalName() + " " + version + " is not supported");
        }
    }

    static {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL url = GeneralizationInfosProviderImpl.class.getResource("/geninfos_1.0.xsd");
        Schema schema = null;
        try {
            schema = factory.newSchema(url);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        VALIDATOR = schema.newValidator();
    }
}

