/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.index.quadtree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.geometry.iso.index.ItemVisitor;
import org.geotools.geometry.iso.index.quadtree.Node;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.Envelope;

public abstract class NodeBase {
    protected List items = new ArrayList();
    protected Node[] subnode = new Node[4];

    public static int getSubnodeIndex(Envelope env, Coordinate centre) {
        int subnodeIndex = -1;
        if (env.getMinX() >= centre.x) {
            if (env.getMinY() >= centre.y) {
                subnodeIndex = 3;
            }
            if (env.getMaxY() <= centre.y) {
                subnodeIndex = 1;
            }
        }
        if (env.getMaxX() <= centre.x) {
            if (env.getMinY() >= centre.y) {
                subnodeIndex = 2;
            }
            if (env.getMaxY() <= centre.y) {
                subnodeIndex = 0;
            }
        }
        return subnodeIndex;
    }

    public List getItems() {
        return this.items;
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    public void add(Object item) {
        this.items.add(item);
    }

    public boolean remove(Envelope itemEnv, Object item) {
        if (!this.isSearchMatch(itemEnv)) {
            return false;
        }
        boolean found = false;
        int i = 0;
        while (i < 4) {
            if (this.subnode[i] != null && (found = this.subnode[i].remove(itemEnv, item))) {
                if (!this.subnode[i].isPrunable()) break;
                this.subnode[i] = null;
                break;
            }
            ++i;
        }
        if (found) {
            return found;
        }
        found = this.items.remove(item);
        return found;
    }

    public boolean isPrunable() {
        return !this.hasChildren() && !this.hasItems();
    }

    public boolean hasChildren() {
        int i = 0;
        while (i < 4) {
            if (this.subnode[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        if (!this.items.isEmpty()) {
            isEmpty = false;
        }
        int i = 0;
        while (i < 4) {
            if (this.subnode[i] != null && !this.subnode[i].isEmpty()) {
                isEmpty = false;
            }
            ++i;
        }
        return isEmpty;
    }

    public List addAllItems(List resultItems) {
        resultItems.addAll(this.items);
        int i = 0;
        while (i < 4) {
            if (this.subnode[i] != null) {
                this.subnode[i].addAllItems(resultItems);
            }
            ++i;
        }
        return resultItems;
    }

    protected abstract boolean isSearchMatch(Envelope var1);

    public void addAllItemsFromOverlapping(Envelope searchEnv, List resultItems) {
        if (!this.isSearchMatch(searchEnv)) {
            return;
        }
        resultItems.addAll(this.items);
        int i = 0;
        while (i < 4) {
            if (this.subnode[i] != null) {
                this.subnode[i].addAllItemsFromOverlapping(searchEnv, resultItems);
            }
            ++i;
        }
    }

    public void visit(Envelope searchEnv, ItemVisitor visitor) {
        if (!this.isSearchMatch(searchEnv)) {
            return;
        }
        this.visitItems(searchEnv, visitor);
        int i = 0;
        while (i < 4) {
            if (this.subnode[i] != null) {
                this.subnode[i].visit(searchEnv, visitor);
            }
            ++i;
        }
    }

    private void visitItems(Envelope searchEnv, ItemVisitor visitor) {
        Iterator i = this.items.iterator();
        while (i.hasNext()) {
            visitor.visitItem(i.next());
        }
    }

    int depth() {
        int maxSubDepth = 0;
        int i = 0;
        while (i < 4) {
            int sqd;
            if (this.subnode[i] != null && (sqd = this.subnode[i].depth()) > maxSubDepth) {
                maxSubDepth = sqd;
            }
            ++i;
        }
        return maxSubDepth + 1;
    }

    int size() {
        int subSize = 0;
        int i = 0;
        while (i < 4) {
            if (this.subnode[i] != null) {
                subSize += this.subnode[i].size();
            }
            ++i;
        }
        return subSize + this.items.size();
    }

    int getNodeCount() {
        int subSize = 0;
        int i = 0;
        while (i < 4) {
            if (this.subnode[i] != null) {
                subSize += this.subnode[i].size();
            }
            ++i;
        }
        return subSize + 1;
    }
}

