/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.io.wkt;

import java.util.Iterator;
import java.util.List;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.aggregate.MultiCurve;
import org.opengis.geometry.aggregate.MultiPoint;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.aggregate.MultiSurface;
import org.opengis.geometry.complex.CompositeCurve;
import org.opengis.geometry.complex.CompositePoint;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;

public class GeometryToWKTString {
    private boolean lineBreak = false;

    public GeometryToWKTString(boolean lineBreak) {
        this.lineBreak = lineBreak;
    }

    public String getString(Geometry geom) {
        String rString = "";
        if (this.lineBreak) {
            rString = String.valueOf(rString) + "\n";
        }
        rString = geom instanceof Curve ? String.valueOf(rString) + this.curveToString((Curve)geom) : (geom instanceof Point ? String.valueOf(rString) + this.pointToString((Point)geom) : (geom instanceof Ring ? String.valueOf(rString) + this.ringToString((Ring)geom) : (geom instanceof SurfaceBoundary ? String.valueOf(rString) + this.surfaceBoundaryToString((SurfaceBoundary)geom) : (geom instanceof Surface ? String.valueOf(rString) + this.surfaceToString((Surface)geom) : (geom instanceof MultiPrimitive ? String.valueOf(rString) + this.multiPrimitiveToString((MultiPrimitive)geom) : (geom instanceof CompositePoint ? String.valueOf(rString) + this.compositePointToString((CompositePoint)geom) : (geom instanceof CompositeCurve ? String.valueOf(rString) + this.compositeCurveToString((CompositeCurve)geom) : "")))))));
        return rString;
    }

    private String pointToString(Point c) {
        return "Point(" + this.pointCoordToString(c) + ")";
    }

    private String curveToString(Curve c) {
        return "Curve(" + this.curveCoordToString(c) + ")";
    }

    private String ringToString(Ring r) {
        return "Ring(" + this.ringCoordToString(r) + ")";
    }

    private String surfaceBoundaryToString(SurfaceBoundary sb) {
        return "SurfaceBoundary(" + this.surfaceBoundaryCoordToString(sb) + ")";
    }

    private String surfaceToString(Surface s) {
        return "Surface(" + this.surfaceBoundaryCoordToString(s.getBoundary()) + ")";
    }

    private String multiPrimitiveToString(MultiPrimitive mp) {
        if (mp instanceof MultiPoint) {
            return this.multiPointToString((MultiPoint)mp);
        }
        if (mp instanceof MultiCurve) {
            return this.multiCurveToString((MultiCurve)mp);
        }
        if (mp instanceof MultiSurface) {
            return this.multiSurfaceToString((MultiSurface)mp);
        }
        return "MultiPrimitive(" + this.multiPrimitiveCoordToString(mp) + ")";
    }

    private String multiPointToString(MultiPoint mp) {
        return "MultiPoint(" + this.multiPointCoordToString(mp) + ")";
    }

    private String multiCurveToString(MultiCurve mc) {
        return "MultiCurve(" + this.multiCurveCoordToString(mc) + ")";
    }

    private String multiSurfaceToString(MultiSurface ms) {
        return "MultiSurface(" + this.multiSurfaceCoordToString(ms) + ")";
    }

    private String compositePointToString(CompositePoint cp) {
        Point p = (Point)cp.getElements().iterator().next();
        return "CompositePoint(" + this.pointCoordToString(p) + ")";
    }

    private String compositeCurveToString(CompositeCurve cc) {
        return "CompositeCurve(" + this.compositeCurveCoordToString(cc) + ")";
    }

    private String directPositionToString(DirectPosition dp) {
        double[] coord = dp.getCoordinates();
        String str = Double.toString(coord[0]);
        int i = 1;
        while (i < coord.length) {
            str = String.valueOf(str) + " " + Double.toString(coord[i]);
            ++i;
        }
        return str;
    }

    private String lineStringCoordToStringWithoutFirstCoord(CurveSegment ls) {
        return this.pointArrayCoordToStringWithoutFirstCoord(ls.getSamplePoints());
    }

    private String pointArrayCoordToStringWithoutFirstCoord(PointArray pa) {
        String rString = "";
        List positions = pa.positions();
        if (positions.size() == 0) {
            return "";
        }
        int i = 1;
        while (i < positions.size()) {
            if (i > 1) {
                rString = String.valueOf(rString) + ", ";
            }
            rString = String.valueOf(rString) + this.directPositionToString(((Position)positions.get(i)).getPosition());
            ++i;
        }
        return rString;
    }

    private String curveCoordToString(Curve c) {
        String rString = "";
        List segments = c.getSegments();
        rString = String.valueOf(rString) + this.directPositionToString(c.getStartPoint());
        int i = 0;
        while (i < segments.size()) {
            rString = String.valueOf(rString) + ", ";
            rString = String.valueOf(rString) + this.lineStringCoordToStringWithoutFirstCoord((CurveSegment)segments.get(i));
            ++i;
        }
        return rString;
    }

    private String curveCoordToStringWithoutFirstCoord(Curve c) {
        String rString = "";
        for (CurveSegment segment : c.getSegments()) {
            rString = String.valueOf(rString) + ", ";
            rString = String.valueOf(rString) + this.lineStringCoordToStringWithoutFirstCoord(segment);
        }
        return rString;
    }

    private String ringCoordToString(Ring r) {
        List orientableCurves = r.getGenerators();
        String rString = this.directPositionToString(((Curve)orientableCurves.iterator().next()).getStartPoint());
        for (Primitive p : orientableCurves) {
            rString = String.valueOf(rString) + this.curveCoordToStringWithoutFirstCoord((Curve)p);
        }
        return rString;
    }

    private String compositeCurveCoordToString(CompositeCurve cc) {
        List orientableCurves = cc.getGenerators();
        String rString = this.directPositionToString(((Curve)orientableCurves.iterator().next()).getStartPoint());
        for (Primitive p : orientableCurves) {
            rString = String.valueOf(rString) + this.curveCoordToStringWithoutFirstCoord((Curve)p);
        }
        return rString;
    }

    private String surfaceBoundaryCoordToString(SurfaceBoundary sb) {
        String rString = "(";
        rString = String.valueOf(rString) + this.ringCoordToString(sb.getExterior());
        rString = String.valueOf(rString) + ")";
        List interior = sb.getInteriors();
        if (interior.size() > 0) {
            int i = 0;
            while (i < interior.size()) {
                rString = String.valueOf(rString) + ", (";
                rString = String.valueOf(rString) + this.ringCoordToString((Ring)interior.get(i));
                rString = String.valueOf(rString) + ")";
                ++i;
            }
        }
        return rString;
    }

    private String multiPointCoordToString(MultiPoint mp) {
        Iterator mpIter = mp.getElements().iterator();
        String rString = this.pointCoordToString((Point)mpIter.next());
        while (mpIter.hasNext()) {
            rString = String.valueOf(rString) + ", (";
            rString = String.valueOf(rString) + this.pointCoordToString((Point)mpIter.next());
            rString = String.valueOf(rString) + ")";
        }
        return rString;
    }

    private String multiCurveCoordToString(MultiCurve mc) {
        Iterator mpIter = mc.getElements().iterator();
        String rString = "(" + this.curveCoordToString((Curve)mpIter.next()) + ")";
        while (mpIter.hasNext()) {
            if (this.lineBreak) {
                rString = String.valueOf(rString) + "\n\t";
            }
            rString = String.valueOf(rString) + ", (";
            rString = String.valueOf(rString) + this.curveCoordToString((Curve)mpIter.next());
            rString = String.valueOf(rString) + ")";
        }
        return rString;
    }

    private String multiSurfaceCoordToString(MultiSurface mc) {
        Iterator mpIter = mc.getElements().iterator();
        String rString = "(" + this.surfaceBoundaryCoordToString(((Surface)mpIter.next()).getBoundary()) + ")";
        while (mpIter.hasNext()) {
            if (this.lineBreak) {
                rString = String.valueOf(rString) + "\n\t";
            }
            rString = String.valueOf(rString) + ", ";
            rString = String.valueOf(rString) + "(" + this.surfaceBoundaryCoordToString(((Surface)mpIter.next()).getBoundary()) + ")";
        }
        return rString;
    }

    private String pointCoordToString(Point p) {
        return this.directPositionToString(p.getPosition());
    }

    private String multiPrimitiveCoordToString(MultiPrimitive mp) {
        Iterator primitives = mp.getElements().iterator();
        String rString = "";
        while (primitives.hasNext()) {
            Primitive p = (Primitive)primitives.next();
            rString = p instanceof Point ? String.valueOf(rString) + "\n\t" + this.pointToString((Point)p) : (p instanceof Curve ? String.valueOf(rString) + "\n\t" + this.curveToString((Curve)p) : (p instanceof Surface ? String.valueOf(rString) + "\n\t" + this.surfaceToString((Surface)p) : String.valueOf(rString) + "\n[INVALID TYPE in MULTIPRIMITIVE]"));
        }
        return rString;
    }
}

