/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.topograph2D;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.geometry.iso.topograph2D.DirectedEdge;
import org.geotools.geometry.iso.topograph2D.Edge;
import org.geotools.geometry.iso.topograph2D.EdgeEnd;
import org.geotools.geometry.iso.topograph2D.EdgeEndStar;
import org.geotools.geometry.iso.topograph2D.EdgeRing;
import org.geotools.geometry.iso.topograph2D.GeometryGraph;
import org.geotools.geometry.iso.topograph2D.Label;
import org.geotools.geometry.iso.topograph2D.Quadrant;
import org.geotools.geometry.iso.topograph2D.TopologyException;
import org.geotools.geometry.iso.util.Assert;

public class DirectedEdgeStar
extends EdgeEndStar {
    private List resultAreaEdgeList;
    private Label label;
    private final int SCANNING_FOR_INCOMING = 1;
    private final int LINKING_TO_OUTGOING = 2;

    public void insert(EdgeEnd ee) {
        DirectedEdge de = (DirectedEdge)ee;
        this.insertEdgeEnd(de, de);
    }

    public Label getLabel() {
        return this.label;
    }

    public int getOutgoingDegree() {
        int degree = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            if (!de.isInResult()) continue;
            ++degree;
        }
        return degree;
    }

    public int getOutgoingDegree(EdgeRing er) {
        int degree = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            if (de.getEdgeRing() != er) continue;
            ++degree;
        }
        return degree;
    }

    public DirectedEdge getRightmostEdge() {
        List edges = this.getEdges();
        int size = edges.size();
        if (size < 1) {
            return null;
        }
        DirectedEdge de0 = (DirectedEdge)edges.get(0);
        if (size == 1) {
            return de0;
        }
        DirectedEdge deLast = (DirectedEdge)edges.get(size - 1);
        int quad0 = de0.getQuadrant();
        int quad1 = deLast.getQuadrant();
        if (Quadrant.isNorthern(quad0) && Quadrant.isNorthern(quad1)) {
            return de0;
        }
        if (!Quadrant.isNorthern(quad0) && !Quadrant.isNorthern(quad1)) {
            return deLast;
        }
        Object nonHorizontalEdge = null;
        if (de0.getDy() != 0.0) {
            return de0;
        }
        if (deLast.getDy() != 0.0) {
            return deLast;
        }
        Assert.shouldNeverReachHere("found two horizontal edges incident on node");
        return null;
    }

    public void computeLabelling(GeometryGraph[] geom) {
        super.computeLabelling(geom);
        this.label = new Label(-1);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd ee = (EdgeEnd)it.next();
            Edge e = ee.getEdge();
            Label eLabel = e.getLabel();
            int i = 0;
            while (i < 2) {
                int eLoc = eLabel.getLocation(i);
                if (eLoc == 0 || eLoc == 1) {
                    this.label.setLocation(i, 0);
                }
                ++i;
            }
        }
    }

    public void mergeSymLabels() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            Label label = de.getLabel();
            label.merge(de.getSym().getLabel());
        }
    }

    public void updateLabelling(Label nodeLabel) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            Label label = de.getLabel();
            label.setAllLocationsIfNull(0, nodeLabel.getLocation(0));
            label.setAllLocationsIfNull(1, nodeLabel.getLocation(1));
        }
    }

    private List getResultAreaEdges() {
        if (this.resultAreaEdgeList != null) {
            return this.resultAreaEdgeList;
        }
        this.resultAreaEdgeList = new ArrayList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            if (!de.isInResult() && !de.getSym().isInResult()) continue;
            this.resultAreaEdgeList.add(de);
        }
        return this.resultAreaEdgeList;
    }

    public void linkResultDirectedEdges() {
        this.getResultAreaEdges();
        DirectedEdge firstOut = null;
        DirectedEdge incoming = null;
        int state = 1;
        int i = 0;
        while (i < this.resultAreaEdgeList.size()) {
            DirectedEdge nextOut = (DirectedEdge)this.resultAreaEdgeList.get(i);
            DirectedEdge nextIn = nextOut.getSym();
            if (nextOut.getLabel().isArea()) {
                if (firstOut == null && nextOut.isInResult()) {
                    firstOut = nextOut;
                }
                switch (state) {
                    case 1: {
                        if (!nextIn.isInResult()) break;
                        incoming = nextIn;
                        state = 2;
                        break;
                    }
                    case 2: {
                        if (!nextOut.isInResult()) break;
                        incoming.setNext(nextOut);
                        state = 1;
                    }
                }
            }
            ++i;
        }
        if (state == 2) {
            if (firstOut == null) {
                throw new TopologyException("no outgoing dirEdge found", this.getCoordinate());
            }
            Assert.isTrue(firstOut.isInResult(), "unable to link last incoming dirEdge");
            incoming.setNext(firstOut);
        }
    }

    public void linkMinimalDirectedEdges(EdgeRing er) {
        DirectedEdge firstOut = null;
        DirectedEdge incoming = null;
        int state = 1;
        int i = this.resultAreaEdgeList.size() - 1;
        while (i >= 0) {
            DirectedEdge nextOut = (DirectedEdge)this.resultAreaEdgeList.get(i);
            DirectedEdge nextIn = nextOut.getSym();
            if (firstOut == null && nextOut.getEdgeRing() == er) {
                firstOut = nextOut;
            }
            switch (state) {
                case 1: {
                    if (nextIn.getEdgeRing() != er) break;
                    incoming = nextIn;
                    state = 2;
                    break;
                }
                case 2: {
                    if (nextOut.getEdgeRing() != er) break;
                    incoming.setNextMin(nextOut);
                    state = 1;
                }
            }
            --i;
        }
        if (state == 2) {
            Assert.isTrue(firstOut != null, "found null for first outgoing dirEdge");
            Assert.isTrue(firstOut.getEdgeRing() == er, "unable to link last incoming dirEdge");
            incoming.setNextMin(firstOut);
        }
    }

    public void linkAllDirectedEdges() {
        this.getEdges();
        DirectedEdge prevOut = null;
        DirectedEdge firstIn = null;
        int i = this.edgeList.size() - 1;
        while (i >= 0) {
            DirectedEdge nextOut = (DirectedEdge)this.edgeList.get(i);
            DirectedEdge nextIn = nextOut.getSym();
            if (firstIn == null) {
                firstIn = nextIn;
            }
            if (prevOut != null) {
                nextIn.setNext(prevOut);
            }
            prevOut = nextOut;
            --i;
        }
        firstIn.setNext(prevOut);
    }

    public void findCoveredLineEdges() {
        int startLoc = -1;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge nextOut = (DirectedEdge)it.next();
            DirectedEdge nextIn = nextOut.getSym();
            if (nextOut.isLineEdge()) continue;
            if (nextOut.isInResult()) {
                startLoc = 0;
                break;
            }
            if (!nextIn.isInResult()) continue;
            startLoc = 2;
            break;
        }
        if (startLoc == -1) {
            return;
        }
        int currLoc = startLoc;
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            DirectedEdge nextOut = (DirectedEdge)it2.next();
            DirectedEdge nextIn = nextOut.getSym();
            if (nextOut.isLineEdge()) {
                nextOut.getEdge().setCovered(currLoc == 0);
                continue;
            }
            if (nextOut.isInResult()) {
                currLoc = 2;
            }
            if (!nextIn.isInResult()) continue;
            currLoc = 0;
        }
    }

    public void computeDepths(DirectedEdge de) {
        int edgeIndex = this.findIndex(de);
        Label label = de.getLabel();
        int startDepth = de.getDepth(1);
        int targetLastDepth = de.getDepth(2);
        int nextDepth = this.computeDepths(edgeIndex + 1, this.edgeList.size(), startDepth);
        int lastDepth = this.computeDepths(0, edgeIndex, nextDepth);
        if (lastDepth != targetLastDepth) {
            throw new TopologyException("depth mismatch at " + de.getCoordinate());
        }
    }

    private int computeDepths(int startIndex, int endIndex, int startDepth) {
        int currDepth = startDepth;
        int i = startIndex;
        while (i < endIndex) {
            DirectedEdge nextDe = (DirectedEdge)this.edgeList.get(i);
            Label label = nextDe.getLabel();
            nextDe.setEdgeDepths(2, currDepth);
            currDepth = nextDe.getDepth(1);
            ++i;
        }
        return currDepth;
    }

    public void print(PrintStream out) {
        System.out.println("DirectedEdgeStar: " + this.getCoordinate());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            out.print("out ");
            de.print(out);
            out.println();
            out.print("in ");
            de.getSym().print(out);
            out.println();
        }
    }
}

