/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.topograph2D;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.coordinate.LineStringImpl;
import org.geotools.geometry.iso.coordinate.PointArrayImpl;
import org.geotools.geometry.iso.coordinate.PositionImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.RingImpl;
import org.geotools.geometry.iso.primitive.SurfaceBoundaryImpl;
import org.geotools.geometry.iso.primitive.SurfaceImpl;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.DirectedEdge;
import org.geotools.geometry.iso.topograph2D.DirectedEdgeStar;
import org.geotools.geometry.iso.topograph2D.Edge;
import org.geotools.geometry.iso.topograph2D.Label;
import org.geotools.geometry.iso.topograph2D.Node;
import org.geotools.geometry.iso.topograph2D.TopologyException;
import org.geotools.geometry.iso.util.Assert;
import org.geotools.geometry.iso.util.algorithm2D.CGAlgorithms;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.Ring;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class EdgeRing {
    protected DirectedEdge startDe;
    private int maxNodeDegree = -1;
    private List edges = new ArrayList();
    private List pts = new ArrayList();
    private Label label = new Label(-1);
    private Ring ring;
    private boolean isHole;
    private EdgeRing shell;
    private ArrayList holes = new ArrayList();
    protected CoordinateReferenceSystem crs;
    protected CGAlgorithms cga;

    public EdgeRing(DirectedEdge start, CoordinateReferenceSystem crs, CGAlgorithms cga) {
        this.crs = crs;
        this.cga = cga;
        this.computePoints(start);
        LinkedList<DirectPosition> dpList = new LinkedList<DirectPosition>();
        int i = 0;
        while (i < this.pts.size()) {
            double[] doubleCoords = ((Coordinate)this.pts.get(i)).getCoordinates();
            DirectPositionImpl dp = new DirectPositionImpl(crs, doubleCoords);
            dpList.add(dp);
            ++i;
        }
        this.isHole = CGAlgorithms.isCCW(dpList);
    }

    public abstract DirectedEdge getNext(DirectedEdge var1);

    public abstract void setEdgeRing(DirectedEdge var1, EdgeRing var2);

    public boolean isIsolated() {
        return this.label.getGeometryCount() == 1;
    }

    public boolean isHole() {
        return this.isHole;
    }

    public Coordinate getCoordinate(int i) {
        return (Coordinate)this.pts.get(i);
    }

    public Ring getRing() {
        this.computeRing();
        return this.ring;
    }

    public Label getLabel() {
        return this.label;
    }

    public boolean isShell() {
        return this.shell == null;
    }

    public EdgeRing getShell() {
        return this.shell;
    }

    public void setShell(EdgeRing shell) {
        this.shell = shell;
        if (shell != null) {
            shell.addHole(this);
        }
    }

    public void addHole(EdgeRing ring) {
        this.holes.add(ring);
    }

    public SurfaceImpl toPolygon() {
        ArrayList<Ring> interiorRings = new ArrayList<Ring>();
        int i = 0;
        while (i < this.holes.size()) {
            interiorRings.add(((EdgeRing)this.holes.get(i)).getRing());
            ++i;
        }
        SurfaceBoundaryImpl surfaceBoundary = new SurfaceBoundaryImpl(this.crs, this.getRing(), interiorRings);
        return new SurfaceImpl(surfaceBoundary);
    }

    private void computeRing() {
        if (this.ring != null) {
            return;
        }
        LinkedList<Position> dpList = new LinkedList<Position>();
        int i = 0;
        while (i < this.pts.size()) {
            double[] doubleCoords = ((Coordinate)this.pts.get(i)).getCoordinates();
            PositionImpl dp = new PositionImpl(new DirectPositionImpl(this.crs, doubleCoords));
            dpList.add(dp);
            ++i;
        }
        LineStringImpl lineString = new LineStringImpl(new PointArrayImpl((List<Position>)dpList), 0.0);
        ArrayList<LineStringImpl> segments = new ArrayList<LineStringImpl>();
        segments.add(lineString);
        CurveImpl curve = new CurveImpl(this.crs, segments);
        ArrayList<OrientableCurve> orientableCurves = new ArrayList<OrientableCurve>();
        orientableCurves.add(curve);
        this.ring = new RingImpl((List<OrientableCurve>)orientableCurves);
    }

    public List getEdges() {
        return this.edges;
    }

    protected void computePoints(DirectedEdge start) {
        this.startDe = start;
        DirectedEdge de = start;
        boolean isFirstEdge = true;
        do {
            Assert.isTrue(de != null, "found null Directed Edge");
            if (de.getEdgeRing() == this) {
                throw new TopologyException("Directed Edge visited twice during ring-building at " + de.getCoordinate());
            }
            this.edges.add(de);
            Label label = de.getLabel();
            Assert.isTrue(label.isArea());
            this.mergeLabel(label);
            this.addPoints(de.getEdge(), de.isForward(), isFirstEdge);
            isFirstEdge = false;
            this.setEdgeRing(de, this);
        } while ((de = this.getNext(de)) != this.startDe);
    }

    public int getMaxNodeDegree() {
        if (this.maxNodeDegree < 0) {
            this.computeMaxNodeDegree();
        }
        return this.maxNodeDegree;
    }

    private void computeMaxNodeDegree() {
        this.maxNodeDegree = 0;
        DirectedEdge de = this.startDe;
        do {
            Node node;
            int degree;
            if ((degree = ((DirectedEdgeStar)(node = de.getNode()).getEdges()).getOutgoingDegree(this)) <= this.maxNodeDegree) continue;
            this.maxNodeDegree = degree;
        } while ((de = this.getNext(de)) != this.startDe);
        this.maxNodeDegree *= 2;
    }

    public void setInResult() {
        DirectedEdge de = this.startDe;
        do {
            de.getEdge().setInResult(true);
        } while ((de = de.getNext()) != this.startDe);
    }

    protected void mergeLabel(Label deLabel) {
        this.mergeLabel(deLabel, 0);
        this.mergeLabel(deLabel, 1);
    }

    protected void mergeLabel(Label deLabel, int geomIndex) {
        int loc = deLabel.getLocation(geomIndex, 2);
        if (loc == -1) {
            return;
        }
        if (this.label.getLocation(geomIndex) == -1) {
            this.label.setLocation(geomIndex, loc);
            return;
        }
    }

    protected void addPoints(Edge edge, boolean isForward, boolean isFirstEdge) {
        Coordinate[] edgePts = edge.getCoordinates();
        if (isForward) {
            int startIndex = 1;
            if (isFirstEdge) {
                startIndex = 0;
            }
            int i = startIndex;
            while (i < edgePts.length) {
                this.pts.add(edgePts[i]);
                ++i;
            }
        } else {
            int startIndex = edgePts.length - 2;
            if (isFirstEdge) {
                startIndex = edgePts.length - 1;
            }
            int i = startIndex;
            while (i >= 0) {
                this.pts.add(edgePts[i]);
                --i;
            }
        }
    }

    public boolean containsPoint(Coordinate p) {
        Ring shell = this.getRing();
        return true;
    }
}

