/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.topograph2D.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.geometry.iso.topograph2D.Edge;
import org.geotools.geometry.iso.topograph2D.index.EdgeSetIntersector;
import org.geotools.geometry.iso.topograph2D.index.MonotoneChain;
import org.geotools.geometry.iso.topograph2D.index.MonotoneChainEdge;
import org.geotools.geometry.iso.topograph2D.index.SegmentIntersector;
import org.geotools.geometry.iso.topograph2D.index.SweepLineEvent;

public class SimpleMonotoneChainSweepLineIntersector
extends EdgeSetIntersector {
    List events = new ArrayList();
    int nOverlaps;

    public void computeIntersections(List edges, SegmentIntersector si, boolean testAllSegments) {
        if (testAllSegments) {
            this.add(edges, null);
        } else {
            this.add(edges);
        }
        this.computeIntersections(si);
    }

    public void computeIntersections(List edges0, List edges1, SegmentIntersector si) {
        this.add(edges0, (Object)edges0);
        this.add(edges1, (Object)edges1);
        this.computeIntersections(si);
    }

    private void add(List edges) {
        for (Edge edge : edges) {
            this.add(edge, (Object)edge);
        }
    }

    private void add(List edges, Object edgeSet) {
        for (Edge edge : edges) {
            this.add(edge, edgeSet);
        }
    }

    private void add(Edge edge, Object edgeSet) {
        MonotoneChainEdge mce = edge.getMonotoneChainEdge();
        int[] startIndex = mce.getStartIndexes();
        int i = 0;
        while (i < startIndex.length - 1) {
            MonotoneChain mc = new MonotoneChain(mce, i);
            SweepLineEvent insertEvent = new SweepLineEvent(edgeSet, mce.getMinX(i), null, mc);
            this.events.add(insertEvent);
            this.events.add(new SweepLineEvent(edgeSet, mce.getMaxX(i), insertEvent, mc));
            ++i;
        }
    }

    private void prepareEvents() {
        Collections.sort(this.events);
        int i = 0;
        while (i < this.events.size()) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i);
            if (ev.isDelete()) {
                ev.getInsertEvent().setDeleteEventIndex(i);
            }
            ++i;
        }
    }

    private void computeIntersections(SegmentIntersector si) {
        this.nOverlaps = 0;
        this.prepareEvents();
        int i = 0;
        while (i < this.events.size()) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i);
            if (ev.isInsert()) {
                this.processOverlaps(i, ev.getDeleteEventIndex(), ev, si);
            }
            ++i;
        }
    }

    private void processOverlaps(int start, int end, SweepLineEvent ev0, SegmentIntersector si) {
        MonotoneChain mc0 = (MonotoneChain)ev0.getObject();
        int i = start;
        while (i < end) {
            SweepLineEvent ev1 = (SweepLineEvent)this.events.get(i);
            if (ev1.isInsert()) {
                MonotoneChain mc1 = (MonotoneChain)ev1.getObject();
                if (ev0.edgeSet == null || ev0.edgeSet != ev1.edgeSet) {
                    mc0.computeIntersections(mc1, si);
                    ++this.nOverlaps;
                }
            }
            ++i;
        }
    }
}

