/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.elem2D;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.geotools.geometry.iso.util.algorithm2D.AlgoPoint2D;
import org.geotools.geometry.iso.util.algorithm2D.AlgoRectangle2D;
import org.geotools.geometry.iso.util.elem2D.Edge2D;
import org.geotools.geometry.iso.util.elem2D.Node2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Simplex2D {
    protected Node2D[] point;
    protected Object[] neighbour;
    public int id = -1;
    public Object object = null;

    protected Simplex2D(Node2D[] p) {
        this.initialize();
        int i = 0;
        int n = this.n();
        while (i < n) {
            this.point[i] = p[i];
            ++i;
        }
    }

    protected Simplex2D(Node2D[] p, int n) {
        this.initialize(n);
        int i = 0;
        while (i < n) {
            this.point[i] = new Node2D(p[i]);
            ++i;
        }
    }

    protected abstract int n();

    public abstract int sideBits(int var1);

    private void initialize() {
        this.point = new Node2D[this.n()];
        this.neighbour = new Object[this.n()];
    }

    private void initialize(int n) {
        this.point = new Node2D[n];
        this.neighbour = new Object[this.n()];
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Node2D[] getPoints() {
        return this.point;
    }

    public Node2D getPoint(int n) {
        return this.point[n];
    }

    public Node2D[] getPointFromSide(int side) {
        return new Node2D[]{this.point[side], this.point[(side + 1) % this.n()]};
    }

    public Object[] getNeighbours() {
        return this.neighbour;
    }

    public Rectangle2D getRectangle() {
        return AlgoRectangle2D.createRectangle(this.point);
    }

    public void setRectangle(Rectangle2D r) {
        AlgoRectangle2D.setValues(r, this.point);
    }

    public double getSizeSq() {
        double sizeSq = Double.MIN_VALUE;
        int i = 0;
        int n = this.n();
        while (i < n) {
            double distSq = this.point[i].distanceSq(this.point[(i + 1) % n]);
            if (distSq > sizeSq) {
                sizeSq = distSq;
            }
            ++i;
        }
        return sizeSq;
    }

    public double getSize() {
        return Math.sqrt(this.getSizeSq());
    }

    boolean hasNeighbour(int side) {
        return this.neighbour[side] != null;
    }

    boolean hasEdge(Edge2D e) {
        int i = 0;
        int n = this.n();
        while (i < n) {
            if (this.neighbour[i] == e) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasPoint(Node2D p) {
        int i = 0;
        int n = this.n();
        while (i < n) {
            if (p == this.point[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasEqualPoint(Point2D p) {
        int i = 0;
        int n = this.n();
        while (i < n) {
            if (p.equals(this.point[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getSide(Point2D p0, Point2D p1) {
        int flag = 0;
        int n = this.n();
        int i = 0;
        while (i < n) {
            if (p0.equals(this.point[i])) {
                flag |= 1 << i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            if (p1.equals(this.point[i])) {
                flag |= 1 << i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            if (flag == this.sideBits(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] getSides(Node2D node) {
        int n = this.n();
        if (node == this.point[0]) {
            int[] nArray = new int[2];
            nArray[0] = n - 1;
            return nArray;
        }
        int i = 1;
        while (i < n) {
            if (node == this.point[i]) {
                return new int[]{(i - 1) % n, i};
            }
            ++i;
        }
        return null;
    }

    public int getSide(Edge2D e) {
        return this.getSide(e.getP1(), e.getP2());
    }

    public int getSide(Simplex2D f) {
        if (f != this) {
            int i = 0;
            int n = this.n();
            while (i < n) {
                Edge2D e;
                if (this.neighbour[i] == f) {
                    return i;
                }
                if (this.neighbour[i] instanceof Edge2D && (e = (Edge2D)this.neighbour[i]).hasSimplex(f)) {
                    return i;
                }
                ++i;
            }
        }
        throw new IllegalArgumentException("getSide(Simplex2D f)");
    }

    public Simplex2D getNeighbourSimplex(int side) {
        if (this.neighbour[side] instanceof Simplex2D) {
            return (Simplex2D)this.neighbour[side];
        }
        Edge2D e = (Edge2D)this.neighbour[side];
        return e == null ? null : e.getNeighborSimplex(this);
    }

    public Edge2D getNeighbourEdge(int side) {
        return this.neighbour[side] instanceof Edge2D ? (Edge2D)this.neighbour[side] : null;
    }

    public Node2D getNextPoint(Point2D p0, Point2D p1) {
        int i = 0;
        int n = this.n();
        while (i < n) {
            if (this.point[i] == p0) {
                if (this.point[(i + 1) % n] == p1) {
                    return this.point[(i + 2) % n];
                }
                if (this.point[(i + n - 1) % n] == p1) {
                    return this.point[(i + n - 2) % n];
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    protected void linkSimplex(int side, Simplex2D s) {
        this.neighbour[side] = s;
    }

    protected boolean linkSimplex(Simplex2D other) {
        int thisSide = 0;
        int thisN = this.n();
        while (thisSide < thisN) {
            int otherSide = 0;
            int otherN = other.n();
            while (otherSide < otherN) {
                if (this.point[thisSide] == other.point[otherSide] && this.point[(thisSide + 1) % thisN] == other.point[(otherSide + 1) % otherN] || this.point[thisSide] == other.point[(otherSide + 1) % otherN] && this.point[(thisSide + 1) % thisN] == other.point[otherSide]) {
                    this.neighbour[thisSide] = other;
                    other.neighbour[otherSide] = this;
                    return true;
                }
                ++otherSide;
            }
            ++thisSide;
        }
        return false;
    }

    protected void linkEdge(int side, Edge2D e) {
        this.neighbour[side] = e;
    }

    protected void linkEdge(Edge2D e) {
        this.linkEdge(this.getSide(e.getP1(), e.getP2()), e);
    }

    protected void unlinkEdge(int side, Edge2D e) {
        if (this.neighbour[side] != e) {
            throw new IllegalArgumentException("error on unlink_edge");
        }
        this.neighbour[side] = null;
    }

    protected void unlinkEdge(Edge2D e) {
        int i = 0;
        int n = this.n();
        while (i < n) {
            if (this.neighbour[i] == e) {
                this.neighbour[i] = null;
                return;
            }
            ++i;
        }
    }

    protected void swapSide(Edge2D e, Simplex2D f) {
        int i = 0;
        while (i < this.n()) {
            if (this.neighbour[i] == e) {
                this.neighbour[i] = f;
            }
            ++i;
        }
    }

    public ArrayList<Simplex2D> getAllSimpliciesOnSimplex() {
        int n = this.n();
        ArrayList<Simplex2D> result = new ArrayList<Simplex2D>(n);
        int i = 0;
        while (i < n) {
            Simplex2D s = this.getNeighbourSimplex(i);
            if (s != null) {
                result.add(s);
            }
            ++i;
        }
        return result;
    }

    public ArrayList<Edge2D> getAllEdgesOnFace() {
        int n = this.n();
        ArrayList<Edge2D> result = new ArrayList<Edge2D>(n);
        int i = 0;
        while (i < n) {
            Edge2D e = this.getNeighbourEdge(i);
            if (e != null) {
                result.add(e);
            }
            ++i;
        }
        return result;
    }

    public ArrayList<Node2D> getAllPointsOnFace() {
        int n = this.n();
        ArrayList<Node2D> result = new ArrayList<Node2D>(n);
        int i = 0;
        while (i < n) {
            result.add(this.point[i]);
            ++i;
        }
        return result;
    }

    public int getOrientation(Node2D n0, Node2D n1) {
        int i = 0;
        int n = this.n();
        while (i < n) {
            if (this.point[i] == n0 && this.point[(i + 1) % n] == n1) {
                return 1;
            }
            if (this.point[i] == n1 && this.point[(i + 1) % n] == n0) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public int getOrientation(int s0, int s1) {
        return s0 < s1 || s0 == this.n() && s1 == 0 ? 1 : -1;
    }

    public int getOrientation(Simplex2D f0, Simplex2D f1) {
        int s0 = this.getSide(f0);
        int s1 = this.getSide(f1);
        if (s0 == -1 || s1 == -1) {
            throw new IllegalArgumentException("error on get_side(GenVertex *v0, GenVertex *v1)");
        }
        return this.getOrientation(s0, s1);
    }

    public int getOrientation(Simplex2D f) {
        int s0 = this.getSide(f);
        int s1 = f.getSide(this);
        if (s0 == -1 || s1 == -1) {
            return 0;
        }
        if (this.point[s0] == f.point[s1]) {
            return -1;
        }
        return 1;
    }

    public Point2D getCentroid() {
        Point2D.Double result = new Point2D.Double(0.0, 0.0);
        int n = this.n();
        int i = 0;
        while (i < n) {
            AlgoPoint2D.add((Point2D)result, this.point[i]);
            ++i;
        }
        return AlgoPoint2D.scale(result, 1.0 / (double)n);
    }

    public boolean hasID() {
        return this.id != -1;
    }
}

