/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.topograph2D;

import org.geotools.geometry.iso.topograph2D.TopologyLocation;

public class Label {
    TopologyLocation[] elt = new TopologyLocation[2];

    public static Label toLineLabel(Label label) {
        Label lineLabel = new Label(-1);
        for (int i = 0; i < 2; ++i) {
            lineLabel.setLocation(i, label.getLocation(i));
        }
        return lineLabel;
    }

    public Label(int onLoc) {
        this.elt[0] = new TopologyLocation(onLoc);
        this.elt[1] = new TopologyLocation(onLoc);
    }

    public Label(int geomIndex, int onLoc) {
        this.elt[0] = new TopologyLocation(-1);
        this.elt[1] = new TopologyLocation(-1);
        this.elt[geomIndex].setLocation(onLoc);
    }

    public Label(int onLoc, int leftLoc, int rightLoc) {
        this.elt[0] = new TopologyLocation(onLoc, leftLoc, rightLoc);
        this.elt[1] = new TopologyLocation(onLoc, leftLoc, rightLoc);
    }

    public Label(int geomIndex, int onLoc, int leftLoc, int rightLoc) {
        this.elt[0] = new TopologyLocation(-1, -1, -1);
        this.elt[1] = new TopologyLocation(-1, -1, -1);
        this.elt[geomIndex].setLocations(onLoc, leftLoc, rightLoc);
    }

    public Label(Label lbl) {
        this.elt[0] = new TopologyLocation(lbl.elt[0]);
        this.elt[1] = new TopologyLocation(lbl.elt[1]);
    }

    public void flip() {
        this.elt[0].flip();
        this.elt[1].flip();
    }

    public int getLocation(int geomIndex, int posIndex) {
        return this.elt[geomIndex].get(posIndex);
    }

    public int getLocation(int geomIndex) {
        return this.elt[geomIndex].get(0);
    }

    public void setLocation(int geomIndex, int posIndex, int location) {
        this.elt[geomIndex].setLocation(posIndex, location);
    }

    public void setLocation(int geomIndex, int location) {
        this.elt[geomIndex].setLocation(0, location);
    }

    public void setAllLocations(int geomIndex, int location) {
        this.elt[geomIndex].setAllLocations(location);
    }

    public void setAllLocationsIfNull(int geomIndex, int location) {
        this.elt[geomIndex].setAllLocationsIfNull(location);
    }

    public void setAllLocationsIfNull(int location) {
        this.setAllLocationsIfNull(0, location);
        this.setAllLocationsIfNull(1, location);
    }

    public void merge(Label lbl) {
        for (int i = 0; i < 2; ++i) {
            if (this.elt[i] == null && lbl.elt[i] != null) {
                this.elt[i] = new TopologyLocation(lbl.elt[i]);
                continue;
            }
            this.elt[i].merge(lbl.elt[i]);
        }
    }

    public int getGeometryCount() {
        int count = 0;
        if (!this.elt[0].isNull()) {
            ++count;
        }
        if (!this.elt[1].isNull()) {
            ++count;
        }
        return count;
    }

    public boolean isNull(int geomIndex) {
        return this.elt[geomIndex].isNull();
    }

    public boolean isAnyNull(int geomIndex) {
        return this.elt[geomIndex].isAnyNull();
    }

    public boolean isArea() {
        return this.elt[0].isArea() || this.elt[1].isArea();
    }

    public boolean isArea(int geomIndex) {
        return this.elt[geomIndex].isArea();
    }

    public boolean isLine(int geomIndex) {
        return this.elt[geomIndex].isLine();
    }

    public boolean isEqualOnSide(Label lbl, int side) {
        return this.elt[0].isEqualOnSide(lbl.elt[0], side) && this.elt[1].isEqualOnSide(lbl.elt[1], side);
    }

    public boolean allPositionsEqual(int geomIndex, int loc) {
        return this.elt[geomIndex].allPositionsEqual(loc);
    }

    public void toLine(int geomIndex) {
        if (this.elt[geomIndex].isArea()) {
            this.elt[geomIndex] = new TopologyLocation(this.elt[geomIndex].location[0]);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.elt[0] != null) {
            buf.append("a:");
            buf.append(this.elt[0].toString());
        }
        if (this.elt[1] != null) {
            buf.append(" b:");
            buf.append(this.elt[1].toString());
        }
        return buf.toString();
    }
}

