/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.algorithm2D;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Stack;
import org.geotools.geometry.iso.util.algorithm2D.AlgoPoint2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgoLine2D {
    public static final int EQUALSEGMENT = 1;
    public static final int OPPOSITESEGMENT = -1;
    public static final int DIFFERENTSEGMENT = 0;

    public static double length(Line2D line) {
        return line.getP1().distance(line.getP2());
    }

    public static ArrayList<Line2D> splitLines(double maxLength, ArrayList<Line2D> lines) {
        if (maxLength <= 0.0) {
            return lines;
        }
        ArrayList<Line2D> result = new ArrayList<Line2D>(lines.size());
        for (int i = 0; i < lines.size(); ++i) {
            Line2D line = lines.get(i);
            if (AlgoLine2D.length(line) > maxLength) {
                result.addAll(AlgoLine2D.split(line, maxLength));
                continue;
            }
            result.add(line);
        }
        return result;
    }

    public static ArrayList<Line2D> split(Line2D line, double maxSpacing) {
        ArrayList<Line2D> result = new ArrayList<Line2D>();
        int n = (int)Math.ceil(AlgoLine2D.length(line) / maxSpacing);
        double x1 = line.getX1();
        double y1 = line.getY1();
        double x2 = line.getX2();
        double y2 = line.getY2();
        double deltaX = (x2 - x1) / (double)n;
        double deltaY = (y2 - y1) / (double)n;
        Point2D p1 = line.getP1();
        for (int j = 1; j < n; ++j) {
            Point2D.Double p2 = new Point2D.Double(x1 + deltaX * (double)j, y1 + deltaY * (double)j);
            result.add(new Line2D.Double(p1, p2));
            p1 = p2;
        }
        result.add(new Line2D.Double(p1, line.getP2()));
        return result;
    }

    public static Line2D merge(Line2D line, Line2D other) {
        Line2D.Double result = new Line2D.Double(line.getP1(), other.getP2());
        return result;
    }

    public static boolean isParallel(Line2D l0, Line2D l1) {
        return AlgoLine2D.isParallel(l0.getP1(), l0.getP2(), l1.getP1(), l1.getP2());
    }

    public static boolean isParallel(Point2D p0, Point2D p1, Point2D q0, Point2D q1) {
        return Math.abs(AlgoPoint2D.cross(AlgoPoint2D.subtract(p1, p0), AlgoPoint2D.subtract(q1, q0))) <= 1.0E-6;
    }

    public static double constrParamForPoint(Point2D p0, Point2D p1, Point2D dp) {
        double eps = 1.0E-6;
        double result = Double.NaN;
        if (!AlgoLine2D.isParallel(p0, p1, p0, dp)) {
            return Double.NaN;
        }
        if (p0.equals(p1)) {
            if (AlgoPoint2D.equals(p0, dp, eps)) {
                return 0.0;
            }
            return Double.NaN;
        }
        result = Math.abs(p0.getX() - p1.getX()) > Math.abs(p0.getY() - p1.getY()) ? (dp.getX() - p0.getX()) / (p1.getX() - p0.getX()) : (dp.getY() - p0.getY()) / (p1.getY() - p0.getY());
        if (Math.abs(result) <= eps) {
            result = 0.0;
        }
        if (Math.abs(1.0 - result) <= eps) {
            result = 1.0;
        }
        if (result < 0.0 || result > 1.0) {
            return Double.NaN;
        }
        return result;
    }

    public static double orientation(Line2D line, Point2D point) {
        return AlgoPoint2D.cross(AlgoPoint2D.subtract(point, line.getP1()), AlgoPoint2D.subtract(line.getP2(), line.getP1()));
    }

    public static boolean rightSide(Line2D line, Point2D p) {
        return AlgoLine2D.rightSide(line.getP1(), line.getP2(), p);
    }

    public static boolean rightSide(Point2D p0, Point2D p1, Point2D p) {
        return AlgoPoint2D.cross(AlgoPoint2D.subtract(p, p0), AlgoPoint2D.subtract(p1, p0)) > 0.0;
    }

    public static boolean leftSide(Line2D line, Point2D p) {
        return AlgoLine2D.leftSide(line.getP1(), line.getP2(), p);
    }

    public static boolean leftSide(Point2D p0, Point2D p1, Point2D p) {
        return AlgoPoint2D.cross(AlgoPoint2D.subtract(p, p0), AlgoPoint2D.subtract(p1, p0)) < 0.0;
    }

    public static int sameSegment(Line2D lineA, Line2D lineB) {
        return AlgoLine2D.sameSegment(lineA.getP1(), lineA.getP2(), lineB.getP1(), lineB.getP2());
    }

    public static int sameSegment(Line2D line, Point2D pb0, Point2D pb1) {
        return AlgoLine2D.sameSegment(line.getP1(), line.getP2(), pb0, pb1);
    }

    public static int sameSegment(Point2D pa0, Point2D pa1, Point2D pb0, Point2D pb1) {
        return pa0.equals(pb0) && pa1.equals(pb1) ? 1 : (pa0.equals(pb1) && pa1.equals(pb0) ? -1 : 0);
    }

    public static Point2D evaluate(Line2D line, double r) {
        return AlgoPoint2D.evaluate(line.getP1(), line.getP2(), r);
    }

    public static GeneralPath reverse(GeneralPath path) {
        PathIterator pi = path.getPathIterator(new AffineTransform());
        double[] coords = new double[6];
        Stack<Point2D.Double> ps = new Stack<Point2D.Double>();
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            if (type == 0 || type == 1) {
                ps.push(new Point2D.Double(coords[0], coords[1]));
            }
            pi.next();
        }
        GeneralPath revPath = new GeneralPath();
        Point2D.Double p = (Point2D.Double)ps.pop();
        revPath.moveTo((float)p.x, (float)p.y);
        while (!ps.empty()) {
            revPath.lineTo((float)p.x, (float)p.y);
        }
        return revPath;
    }

    public static double getAngle2D(Line2D line, Point2D point) {
        return AlgoPoint2D.getAngle2D(AlgoPoint2D.subtract(line.getP2(), line.getP1()), point);
    }
}

