/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Logger;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraph;
import org.geotools.graph.util.delaunay.DelaunayNode;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoClustUtils {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.graph");

    public static Vector findConnectedComponents(Collection nodes, Collection edges) {
        Vector<BasicGraph> components = new Vector<BasicGraph>();
        Vector nodesVisited = new Vector();
        for (Node next : nodes) {
            if (nodesVisited.contains(next)) continue;
            Vector componentNodes = new Vector();
            Vector componentEdges = new Vector();
            AutoClustUtils.expandComponent(next, edges, componentNodes, componentEdges);
            nodesVisited.addAll(componentNodes);
            BasicGraph component = new BasicGraph(componentNodes, componentEdges);
            components.add(component);
        }
        return components;
    }

    private static void expandComponent(Node node, Collection edges, Collection componentNodes, Collection componentEdges) {
        if (!componentNodes.contains(node)) {
            componentNodes.add(node);
            Vector adjacentEdges = AutoClustUtils.findAdjacentEdges(node, edges);
            adjacentEdges.trimToSize();
            componentEdges.addAll(adjacentEdges);
            for (Edge next : adjacentEdges) {
                Node additionalNode = next.getOtherNode(node);
                if (additionalNode == null) {
                    throw new RuntimeException("I tried to get the other node of this edge " + next + " but it doesn't have " + node);
                }
                AutoClustUtils.expandComponent(additionalNode, edges, componentNodes, componentEdges);
            }
            adjacentEdges.clear();
        }
    }

    public static Vector findAdjacentEdges(Node node, Collection edges) {
        Vector<Edge> ret = new Vector<Edge>();
        for (Edge next : edges) {
            if (!next.getNodeA().equals(node) && !next.getNodeB().equals(node)) continue;
            ret.add(next);
        }
        return ret;
    }

    public static DelaunayNode[] featureCollectionToNodeArray(FeatureCollection<SimpleFeatureType, SimpleFeature> fc) {
        FeatureIterator iter = fc.features();
        int size = fc.size();
        DelaunayNode[] nodes = new DelaunayNode[size];
        int index = 0;
        while (iter.hasNext()) {
            SimpleFeature next = (SimpleFeature)iter.next();
            Geometry geom = (Geometry)next.getDefaultGeometry();
            Point centroid = geom instanceof Point ? (Point)geom : geom.getCentroid();
            DelaunayNode node = new DelaunayNode();
            node.setCoordinate(centroid.getCoordinate());
            node.setFeature(next);
            if (AutoClustUtils.arrayContains(node, nodes, index)) continue;
            nodes[index] = node;
            ++index;
        }
        DelaunayNode[] trimmed = new DelaunayNode[index];
        for (int i = 0; i < index; ++i) {
            trimmed[i] = nodes[i];
        }
        return trimmed;
    }

    public static boolean arrayContains(DelaunayNode node, DelaunayNode[] nodes, int index) {
        boolean ret = false;
        boolean done = false;
        int i = 0;
        while (!done) {
            if (i < index) {
                done = ret = nodes[i].equals(node);
                ++i;
                continue;
            }
            done = true;
        }
        return ret;
    }
}

