/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid.hexagon;

import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.Orientation;
import org.geotools.grid.hexagon.Hexagon;
import org.geotools.grid.hexagon.HexagonGridBuilder;
import org.geotools.grid.hexagon.HexagonImpl;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Hexagons {
    private static final double ROOT3 = Math.sqrt(3.0);

    public static double sideLengthToArea(double sideLen) {
        if (sideLen <= 0.0) {
            throw new IllegalArgumentException("side length must be > 0");
        }
        return sideLen * sideLen * 1.5 * ROOT3;
    }

    public static double areaToSideLength(double area) {
        if (area <= 0.0) {
            throw new IllegalArgumentException("area must be > 0");
        }
        return Math.sqrt(area * 2.0 / 3.0 / ROOT3);
    }

    public static Hexagon create(double minX, double minY, double sideLen, Orientation orientation, CoordinateReferenceSystem crs) {
        return new HexagonImpl(minX, minY, sideLen, orientation, crs);
    }

    public static SimpleFeatureSource createGrid(ReferencedEnvelope bounds, double sideLen, Orientation orientation, GridFeatureBuilder gridBuilder) {
        return Hexagons.createGrid(bounds, sideLen, -1.0, orientation, gridBuilder);
    }

    public static SimpleFeatureSource createGrid(ReferencedEnvelope bounds, double sideLen, double vertexSpacing, Orientation orientation, GridFeatureBuilder gridFeatureBuilder) {
        if (bounds == null || bounds.isEmpty() || bounds.isNull()) {
            throw new IllegalArgumentException("bounds should not be null or empty");
        }
        if (sideLen <= 0.0) {
            throw new IllegalArgumentException("sideLen must be greater than 0");
        }
        if (orientation == null) {
            throw new IllegalArgumentException("orientation should not be null");
        }
        CoordinateReferenceSystem boundsCRS = bounds.getCoordinateReferenceSystem();
        CoordinateReferenceSystem builderCRS = gridFeatureBuilder.getType().getCoordinateReferenceSystem();
        if (boundsCRS != null && builderCRS != null && !CRS.equalsIgnoreMetadata((Object)boundsCRS, (Object)builderCRS)) {
            throw new IllegalArgumentException("Different CRS set for bounds and grid feature builder");
        }
        ListFeatureCollection fc = new ListFeatureCollection(gridFeatureBuilder.getType());
        HexagonGridBuilder gridBuilder = new HexagonGridBuilder(bounds, sideLen, orientation);
        gridBuilder.buildGrid((SimpleFeatureCollection)fc, gridFeatureBuilder, vertexSpacing);
        return DataUtilities.source((FeatureCollection)fc);
    }
}

