/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid.oblong;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.AbstractGridBuilder;
import org.geotools.grid.GridElement;
import org.geotools.grid.Neighbor;
import org.geotools.grid.oblong.Oblong;
import org.geotools.grid.oblong.Oblongs;

class OblongGridBuilder
extends AbstractGridBuilder {
    private final double elementWidth;
    private final double elementHeight;

    OblongGridBuilder(ReferencedEnvelope bounds, double width, double height) {
        super(bounds);
        this.elementWidth = width;
        this.elementHeight = height;
    }

    public boolean isValidNeighbor(Neighbor neighbor) {
        return true;
    }

    public Oblong createNeighbor(GridElement el, Neighbor neighbor) {
        double dy;
        double dx;
        if (el == null || neighbor == null) {
            throw new IllegalArgumentException("el and neighbour position must both be non-null");
        }
        if (!(el instanceof Oblong)) {
            throw new IllegalArgumentException("el must be an instance of Oblong");
        }
        Oblong oblong = (Oblong)el;
        ReferencedEnvelope bounds = oblong.getBounds();
        switch (neighbor) {
            case LEFT: {
                dx = -bounds.getWidth();
                dy = 0.0;
                break;
            }
            case LOWER: {
                dx = 0.0;
                dy = -bounds.getHeight();
                break;
            }
            case LOWER_LEFT: {
                dx = -bounds.getWidth();
                dy = -bounds.getHeight();
                break;
            }
            case LOWER_RIGHT: {
                dx = bounds.getWidth();
                dy = -bounds.getHeight();
                break;
            }
            case RIGHT: {
                dx = bounds.getWidth();
                dy = 0.0;
                break;
            }
            case UPPER: {
                dx = 0.0;
                dy = bounds.getHeight();
                break;
            }
            case UPPER_LEFT: {
                dx = -bounds.getWidth();
                dy = bounds.getHeight();
                break;
            }
            case UPPER_RIGHT: {
                dx = bounds.getWidth();
                dy = bounds.getHeight();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized value for neighbor");
            }
        }
        return Oblongs.create(bounds.getMinX() + dx, bounds.getMinY() + dy, bounds.getWidth(), bounds.getHeight(), bounds.getCoordinateReferenceSystem());
    }

    public boolean isValidDenseVertexSpacing(double v) {
        return v > 0.0 && v < Math.min(this.elementWidth, this.elementHeight) / 2.0;
    }

    public GridElement getFirstElement() {
        return Oblongs.create(this.gridBounds.getMinX(), this.gridBounds.getMinY(), this.elementWidth, this.elementHeight, this.gridBounds.getCoordinateReferenceSystem());
    }

    public GridElement getNextXElement(GridElement el) {
        return this.createNeighbor(el, Neighbor.RIGHT);
    }

    public GridElement getNextYElement(GridElement el) {
        return this.createNeighbor(el, Neighbor.UPPER);
    }
}

