/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2008(c).
 * 
 * file: GridCoverageFeatureSourceImpl.java
 * created: 17/10/2008
 */
package org.geotools.data.gridcoverage;

import java.awt.RenderingHints;
import java.util.Set;

import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureStore;
import org.geotools.data.gridcoverage.exception.DataAccessGridCoverageException;
import org.opengis.feature.simple.SimpleFeatureType;

/**
 * Specifies a {@link FeatureStore} that wraps and allows read and write access
 * to coverage data. This is an equivalent to the
 * {@link DefaultGridCoverageFeatureSource} implementation, which only allows
 * read access.
 * 
 * @author milton
 * @since TDK 3.0.0
 */
@SuppressWarnings("unchecked")
public class DefaultGridCoverageFeatureStore extends AbstractFeatureStore implements GridCoverageFeatureSource
{
    private DataStore _dataStore;
    private SimpleFeatureType _featureType;

    /**
     * Regular constructor that builds a GridCoverageFeatureStore within a
     * provided DataStore.
     * 
     * @param dataStore the DataStore that will contain the newly created
     *            FeatureSource.
     * @param featureType the SimpleFeatureType (schema) of the new
     *            GridCoverageFeatureStore, which should contain a "bounds"
     *            Polygon attribute for the coverage bounds, a "grid"
     *            AbstractGridCoverage2DReader attribute for the coverage data,
     *            and a "params" GeneralParameterValue[] attribute for storing
     *            optional coverage reading parameters.
     * @since TDK 3.0.0
     */
    public DefaultGridCoverageFeatureStore(DataStore dataStore, SimpleFeatureType featureType)
    {
        super();

        if (dataStore == null)
            throw new NullPointerException("dataStore can't be null");
        if (featureType == null)
            throw new NullPointerException("featureType can't be null");

        _dataStore = dataStore;
        _featureType = featureType;
    }

    /**
     * Constructor that builds a GridCoverageFeatureStore within a provided
     * DataStore and allows the setting of user-specified hints.
     * 
     * @param dataStore the DataStore that will contain the newly created
     *            FeatureSource.
     * @param featureType the SimpleFeatureType (schema) of the new
     *            GridCoverageFeatureStore, which should contain a "bounds"
     *            Polygon attribute for the coverage bounds, a "grid"
     *            AbstractGridCoverage2DReader attribute for the coverage data,
     *            and a "params" GeneralParameterValue[] attribute for storing
     *            optional coverage reading parameters.
     * @param hints a Hints objects containing configurations or settings that
     *            may influence the new object's behavior.
     * @since TDK 3.0.0
     */
    public DefaultGridCoverageFeatureStore(DataStore dataStore, SimpleFeatureType featureType,
            Set<RenderingHints.Key> hints)
    {
        super(hints);

        if (dataStore == null)
            throw new NullPointerException("dataStore can't be null");
        if (featureType == null)
            throw new NullPointerException("featureType can't be null");

        _dataStore = dataStore;
        _featureType = featureType;
    }

    /*
     * (non-Javadoc)
     * 
     * @seeorg.tecgraf.tdk.dataaccess.gridcoverage.GridCoverageFeatureSource#
     * getCoverageReader()
     */
    @Override
    public AbstractGridCoverage2DReader getCoverageReader() throws DataAccessGridCoverageException
    {
        return DefaultGridCoverageFeatureSource.getCoverageReader(this);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.geotools.data.AbstractFeatureSource#getDataStore()
     */
    @Override
    public DataStore getDataStore()
    {
        return _dataStore;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.geotools.data.FeatureSource#addFeatureListener(org.geotools.data.
     * FeatureListener)
     */
    @Override
    public void addFeatureListener(FeatureListener listener)
    {
        // this is not ideal, but it is the most straightforward way of dealing
        // with this method
        // (see GridCoverageFeatureSourceImpl.addFeatureListener for a
        // discussion)
        if (!(_dataStore instanceof AbstractDataStore))
            throw new UnsupportedOperationException(
                    "FeatureListenerManager is only available for DataStores that extend AbstactDataStore.");

        ((AbstractDataStore) _dataStore).listenerManager.addFeatureListener(this, listener);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.geotools.data.FeatureSource#removeFeatureListener(org.geotools.data
     * .FeatureListener)
     */
    @Override
    public void removeFeatureListener(FeatureListener listener)
    {
        // this is not ideal, but it is the most straightforward way of dealing
        // with this method
        // (see GridCoverageFeatureSourceImpl.addFeatureListener for a
        // discussion)
        if (!(_dataStore instanceof AbstractDataStore))
            throw new UnsupportedOperationException(
                    "FeatureListenerManager is only available for DataStores that extend AbstactDataStore.");

        ((AbstractDataStore) _dataStore).listenerManager.removeFeatureListener(this, listener);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.geotools.data.FeatureSource#getSchema()
     */
    @Override
    public SimpleFeatureType getSchema()
    {
        return _featureType;
    }
}
