/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2008(c).
 * 
 * file: GridCoverageFeatureSource.java
 * created: 17/10/2008
 */
package org.geotools.data.gridcoverage;

import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.gridcoverage.exception.DataAccessGridCoverageException;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/**
 * Defines a {@link FeatureSource} that contains a {@link GridCoverage}. In
 * practice, this specifies a wrapper around an AbstractGridCoverage2DReader.
 * 
 * @author milton
 * @since TDK 3.0.0
 */
public interface GridCoverageFeatureSource extends FeatureSource<SimpleFeatureType, SimpleFeature>
{
    /**
     * Retrieves the coverage reader wrapped by the GridCoverageFeatureSource.
     * 
     * @return The reader, which cannot be null.
     * @throws DataAccessGridCoverageException If the coverage reader cannot be
     *             retrieved.
     * @since TDK 3.0.0
     */
    public AbstractGridCoverage2DReader getCoverageReader() throws DataAccessGridCoverageException;
}
