/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio;

import java.io.File;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class GridCoverageUtilities {
    static final String DEFAULT_WORLDFILE_EXT = ".wld";
    static final char SEPARATOR = File.separatorChar;
    static final String IMAGEREAD = "ImageRead";
    static final String IMAGEREADMT = "ImageReadMT";

    private GridCoverageUtilities() {
    }

    public static ReferencedEnvelope getReferencedEnvelopeFromGeographicBoundingBox(GeographicBoundingBox geographicBBox) {
        GridCoverageUtilities.ensureNonNull("GeographicBoundingBox", geographicBBox);
        return new ReferencedEnvelope(geographicBBox.getEastBoundLongitude(), geographicBBox.getWestBoundLongitude(), geographicBBox.getSouthBoundLatitude(), geographicBBox.getNorthBoundLatitude(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format((int)105, (Object)name));
        }
    }
}

