/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc.custom;

import java.awt.Rectangle;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.jdbc.datasource.DataSourceFinder;
import org.geotools.gce.imagemosaic.jdbc.Config;
import org.geotools.gce.imagemosaic.jdbc.ImageLevelInfo;
import org.geotools.gce.imagemosaic.jdbc.JDBCAccess;
import org.geotools.gce.imagemosaic.jdbc.TileQueueElement;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDBCAccessCustom
implements JDBCAccess {
    private static final Logger LOGGER = Logger.getLogger(JDBCAccessCustom.class.getPackage().getName());
    private Config config;
    private DataSource dataSource;
    private List<ImageLevelInfo> levelInfos = new ArrayList<ImageLevelInfo>();

    public JDBCAccessCustom(Config config) throws IOException {
        this.config = config;
        this.dataSource = DataSourceFinder.getDataSource(config.getDataSourceParams());
    }

    @Override
    public ImageLevelInfo getLevelInfo(int level) {
        LOGGER.fine("getLevelInfo Method");
        return this.levelInfos.get(level);
    }

    @Override
    public int getNumOverviews() {
        LOGGER.fine("getNumOverviews Method");
        return this.levelInfos.size() - 1;
    }

    @Override
    public abstract void initialize() throws SQLException, IOException;

    @Override
    public abstract void startTileDecoders(Rectangle var1, GeneralEnvelope var2, ImageLevelInfo var3, LinkedBlockingQueue<TileQueueElement> var4, GridCoverageFactory var5) throws IOException;

    protected Connection getConnection() {
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return con;
    }

    protected void closeConnection(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void closePreparedStmt(PreparedStatement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void closeCallableStmt(CallableStatement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void closeStmt(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected CoordinateReferenceSystem getCRS() {
        LOGGER.fine("getCRS Method");
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)this.config.getCoordsys());
            LOGGER.fine("CRS get Identifier" + crs.getIdentifiers());
        }
        catch (Exception e) {
            LOGGER.severe("Cannot parse Decode CRS from Config File " + e.getMessage());
            throw new RuntimeException(e);
        }
        LOGGER.fine("Returning CRS Result");
        return crs;
    }

    public Config getConfig() {
        return this.config;
    }

    public List<ImageLevelInfo> getLevelInfos() {
        return this.levelInfos;
    }
}

