/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.jdbc;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geotools.data.jdbc.datasource.DBCPDataSourceFactory;
import org.geotools.data.jdbc.datasource.JNDIDataSourceFactory;
import org.geotools.gce.imagemosaic.jdbc.SpatialExtension;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Config {
    private static Map<String, Config> ConfigMap = new Hashtable<String, Config>();
    private String xmlUrl;
    private String coverageName;
    private String coordsys;
    private SpatialExtension spatialExtension;
    private String dstype;
    private String username;
    private String password;
    private String jdbcUrl;
    private String driverClassName;
    private Integer maxActive;
    private Integer maxIdle;
    private String jndiReferenceName;
    private String coverageNameAttribute;
    private String blobAttributeNameInTileTable;
    private String keyAttributeNameInTileTable;
    private String keyAttributeNameInSpatialTable;
    private String geomAttributeNameInSpatialTable;
    private String maxXAttribute;
    private String maxYAttribute;
    private String minXAttribute;
    private String minYAttribute;
    private String masterTable;
    private String resXAttribute;
    private String resYAttribute;
    private String tileTableNameAtribute;
    private String spatialTableNameAtribute;
    private String sqlUpdateMosaicStatement;
    private String sqlSelectCoverageStatement;
    private String sqlUpdateResStatement;
    private Boolean verifyCardinality;
    private Integer interpolation;
    private String tileMaxXAttribute;
    private String tileMaxYAttribute;
    private String tileMinXAttribute;
    private String tileMinYAttribute;

    protected Config() {
    }

    static Config readFrom(URL xmlURL) throws Exception {
        Config result = ConfigMap.get(xmlURL.toString());
        if (result != null) {
            return result;
        }
        InputStream in = xmlURL.openStream();
        InputSource input = new InputSource(xmlURL.toString());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(input);
        in.close();
        result = new Config();
        result.xmlUrl = xmlURL.toString();
        result.dstype = Config.readValueString(dom, "dstype");
        result.username = Config.readValueString(dom, "username");
        result.password = Config.readValueString(dom, "password");
        result.jdbcUrl = Config.readValueString(dom, "jdbcUrl");
        result.driverClassName = Config.readValueString(dom, "driverClassName");
        result.jndiReferenceName = Config.readValueString(dom, "jndiReferenceName");
        result.maxActive = Config.readValueInteger(dom, "maxActive");
        result.maxIdle = Config.readValueInteger(dom, "maxIdle");
        result.coordsys = Config.readNameString(dom.getDocumentElement(), "coordsys");
        result.coverageName = Config.readNameString(dom.getDocumentElement(), "coverageName");
        result.spatialExtension = SpatialExtension.fromString(Config.readNameString(dom.getDocumentElement(), "spatialExtension"));
        result.masterTable = Config.readNameString(dom.getDocumentElement(), "masterTable");
        Element masterTableElem = (Element)dom.getElementsByTagName("masterTable").item(0);
        result.coverageNameAttribute = Config.readNameString(masterTableElem, "coverageNameAttribute");
        result.maxXAttribute = Config.readNameString(masterTableElem, "maxXAttribute");
        result.maxYAttribute = Config.readNameString(masterTableElem, "maxYAttribute");
        result.minXAttribute = Config.readNameString(masterTableElem, "minXAttribute");
        result.minYAttribute = Config.readNameString(masterTableElem, "minYAttribute");
        result.resXAttribute = Config.readNameString(masterTableElem, "resXAttribute");
        result.resYAttribute = Config.readNameString(masterTableElem, "resYAttribute");
        result.tileTableNameAtribute = Config.readNameString(masterTableElem, "tileTableNameAtribute");
        result.spatialTableNameAtribute = Config.readNameString(masterTableElem, "spatialTableNameAtribute");
        Element tileTableElem = (Element)dom.getElementsByTagName("tileTable").item(0);
        result.blobAttributeNameInTileTable = Config.readNameString(tileTableElem, "blobAttributeName");
        result.keyAttributeNameInTileTable = Config.readNameString(tileTableElem, "keyAttributeName");
        Element spatialTableElem = (Element)dom.getElementsByTagName("spatialTable").item(0);
        result.keyAttributeNameInSpatialTable = Config.readNameString(spatialTableElem, "keyAttributeName");
        result.geomAttributeNameInSpatialTable = Config.readNameString(spatialTableElem, "geomAttributeName");
        result.tileMaxXAttribute = Config.readNameString(spatialTableElem, "tileMaxXAttribute");
        result.tileMaxYAttribute = Config.readNameString(spatialTableElem, "tileMaxYAttribute");
        result.tileMinXAttribute = Config.readNameString(spatialTableElem, "tileMinXAttribute");
        result.tileMinYAttribute = Config.readNameString(spatialTableElem, "tileMinYAttribute");
        Node tmp = dom.getElementsByTagName("scaleop").item(0);
        NamedNodeMap map = tmp.getAttributes();
        String s = map.getNamedItem("interpolation").getNodeValue();
        result.interpolation = new Integer(s);
        tmp = dom.getElementsByTagName("verify").item(0);
        map = tmp.getAttributes();
        s = map.getNamedItem("cardinality").getNodeValue();
        result.verifyCardinality = new Boolean(s);
        result.initStatements();
        ConfigMap.put(xmlURL.toString(), result);
        return result;
    }

    private void initStatements() {
        StringBuffer buff = null;
        buff = new StringBuffer("update ").append(this.masterTable).append(" set ");
        buff.append(this.maxXAttribute).append(" = ?,");
        buff.append(this.maxYAttribute).append(" = ?,");
        buff.append(this.minXAttribute).append(" = ?,");
        buff.append(this.minYAttribute).append(" = ?");
        buff.append(" where ").append(this.coverageNameAttribute).append(" = ? ");
        buff.append(" and ").append(this.tileTableNameAtribute).append(" = ? ");
        buff.append(" and ").append(this.spatialTableNameAtribute).append(" = ? ");
        this.sqlUpdateMosaicStatement = buff.toString();
        buff = new StringBuffer("select * from ").append(this.masterTable).append(" where ").append(this.coverageNameAttribute).append(" = ? ");
        this.sqlSelectCoverageStatement = buff.toString();
        buff = new StringBuffer("update ").append(this.masterTable).append(" set ");
        buff.append(this.resXAttribute).append(" = ?,");
        buff.append(this.resYAttribute).append(" = ? ");
        buff.append(" where ").append(this.coverageNameAttribute).append(" = ? ");
        buff.append(" and ").append(this.tileTableNameAtribute).append(" = ? ");
        buff.append(" and ").append(this.spatialTableNameAtribute).append(" = ? ");
        this.sqlUpdateResStatement = buff.toString();
    }

    private static String readValueString(Document dom, String elemName) {
        Node n = Config.readValueAttribute(dom, elemName);
        if (n == null) {
            return null;
        }
        return n.getNodeValue();
    }

    private static String readNameString(Element elem, String elemName) {
        Node n = Config.readNameAttribute(elem, elemName);
        if (n == null) {
            return null;
        }
        return n.getNodeValue();
    }

    private static Integer readValueInteger(Document dom, String elemName) {
        Node n = Config.readValueAttribute(dom, elemName);
        if (n == null) {
            return null;
        }
        return new Integer(n.getNodeValue());
    }

    private static Node readValueAttribute(Document dom, String elemName) {
        NodeList list = dom.getElementsByTagName(elemName);
        Node n = list.item(0);
        if (n == null) {
            return null;
        }
        return n.getAttributes().getNamedItem("value");
    }

    private static Node readNameAttribute(Element elem, String elemName) {
        NodeList list = elem.getElementsByTagName(elemName);
        Node n = list.item(0);
        if (n == null) {
            return null;
        }
        return n.getAttributes().getNamedItem("name");
    }

    Map<String, Object> getDataSourceParams() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if ("DBCP".equals(this.dstype)) {
            result.put(DBCPDataSourceFactory.DSTYPE.key, this.dstype);
            result.put(DBCPDataSourceFactory.USERNAME.key, this.username);
            result.put(DBCPDataSourceFactory.PASSWORD.key, this.password);
            result.put(DBCPDataSourceFactory.JDBC_URL.key, this.jdbcUrl);
            result.put(DBCPDataSourceFactory.DRIVERCLASS.key, this.driverClassName);
            result.put(DBCPDataSourceFactory.MAXACTIVE.key, this.maxActive);
            result.put(DBCPDataSourceFactory.MAXIDLE.key, this.maxIdle);
        }
        if ("JNDI".equals(this.dstype)) {
            result.put(JNDIDataSourceFactory.DSTYPE.key, this.dstype);
            result.put(JNDIDataSourceFactory.JNDI_REFNAME.key, this.jndiReferenceName);
        }
        return result;
    }

    String getBlobAttributeNameInTileTable() {
        return this.blobAttributeNameInTileTable;
    }

    String getKeyAttributeNameInSpatialTable() {
        return this.keyAttributeNameInSpatialTable;
    }

    String getKeyAttributeNameInTileTable() {
        return this.keyAttributeNameInTileTable;
    }

    String getJdbcUrl() {
        return this.jdbcUrl;
    }

    String getJndiReferenceName() {
        return this.jndiReferenceName;
    }

    String getSqlUpdateMosaicStatement() {
        return this.sqlUpdateMosaicStatement;
    }

    String getSqlSelectCoverageStatement() {
        return this.sqlSelectCoverageStatement;
    }

    String getSpatialTableNameAtribute() {
        return this.spatialTableNameAtribute;
    }

    String getTileTableNameAtribute() {
        return this.tileTableNameAtribute;
    }

    String getSqlUpdateResStatement() {
        return this.sqlUpdateResStatement;
    }

    String getMaxXAttribute() {
        return this.maxXAttribute;
    }

    String getMaxYAttribute() {
        return this.maxYAttribute;
    }

    String getMinXAttribute() {
        return this.minXAttribute;
    }

    String getMinYAttribute() {
        return this.minYAttribute;
    }

    String getResXAttribute() {
        return this.resXAttribute;
    }

    String getResYAttribute() {
        return this.resYAttribute;
    }

    String getCoordsys() {
        return this.coordsys;
    }

    String getCoverageName() {
        return this.coverageName;
    }

    Integer getInterpolation() {
        return this.interpolation;
    }

    String getXmlUrl() {
        return this.xmlUrl;
    }

    Boolean getVerifyCardinality() {
        return this.verifyCardinality;
    }

    String getDriverClassName() {
        return this.driverClassName;
    }

    String getMasterTable() {
        return this.masterTable;
    }

    String getCoverageNameAttribute() {
        return this.coverageNameAttribute;
    }

    String getPassword() {
        return this.password;
    }

    String getUsername() {
        return this.username;
    }

    String getTileMaxXAttribute() {
        return this.tileMaxXAttribute;
    }

    String getTileMaxYAttribute() {
        return this.tileMaxYAttribute;
    }

    String getTileMinXAttribute() {
        return this.tileMinXAttribute;
    }

    String getTileMinYAttribute() {
        return this.tileMinYAttribute;
    }

    String getGeomAttributeNameInSpatialTable() {
        return this.geomAttributeNameInSpatialTable;
    }

    SpatialExtension getSpatialExtension() {
        return this.spatialExtension;
    }
}

