/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLibSpi;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderSpi;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import it.geosolutions.imageio.plugins.jp2ecw.JP2GDALEcwImageReaderSpi;
import it.geosolutions.imageio.plugins.jp2kakadu.JP2GDALKakaduImageReaderSpi;
import it.geosolutions.imageio.plugins.jp2mrsid.JP2GDALMrSidImageReaderSpi;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.RenderingHints;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.coverageio.gdal.jp2ecw.JP2ECWFormatFactory;
import org.geotools.coverageio.gdal.jp2kak.JP2KFormatFactory;
import org.geotools.coverageio.gdal.jp2mrsid.JP2MrSIDFormatFactory;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageMosaicFormatFactory
implements GridFormatFactorySpi {
    private static final Logger LOGGER = Logging.getLogger(ImageMosaicFormatFactory.class);

    public boolean isAvailable() {
        boolean available = true;
        try {
            Class.forName("javax.media.jai.JAI");
            Class.forName("com.sun.media.jai.operator.ImageReadDescriptor");
        }
        catch (ClassNotFoundException cnf) {
            available = false;
        }
        return available;
    }

    private static void replaceTIFF() {
        try {
            String customTiffName = it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi.class.getName();
            Class.forName(customTiffName);
            String imageioTiffName = TIFFImageReaderSpi.class.getName();
            boolean succeeded = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)customTiffName, (String)imageioTiffName, (String)"tiff");
            if (!succeeded) {
                LOGGER.warning("Unable to set ordering between tiff readers spi");
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Unable to load specific TIFF reader spi", e);
        }
    }

    private static boolean JP2GDALKAK() {
        return new JP2KFormatFactory().isAvailable();
    }

    private static void replaceGDALKAK() {
        try {
            String imageioJ2KImageReaderName;
            boolean succeeded;
            boolean succeeded2;
            String kakJP2 = JP2GDALKakaduImageReaderSpi.class.getName();
            Class.forName(kakJP2);
            String imageioJ2KImageReaderCodecName = J2KImageReaderCodecLibSpi.class.getName();
            if (PackageUtil.isCodecLibAvailable() && !(succeeded2 = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)kakJP2, (String)imageioJ2KImageReaderCodecName, (String)"JPEG 2000"))) {
                LOGGER.warning("Unable to set ordering between jp2 readers spi-" + kakJP2 + ":" + imageioJ2KImageReaderCodecName);
            }
            if (!(succeeded = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)kakJP2, (String)(imageioJ2KImageReaderName = J2KImageReaderSpi.class.getName()), (String)"JPEG 2000"))) {
                LOGGER.warning("Unable to set ordering between jp2 readers spi-" + kakJP2 + ":" + imageioJ2KImageReaderName);
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Unable to load specific JPEG2000 reader spi", e);
        }
    }

    private static void replaceMRSID() {
        try {
            String imageioJ2KImageReaderName;
            boolean succeeded;
            boolean succeeded2;
            String mrsidJP2 = JP2GDALMrSidImageReaderSpi.class.getName();
            Class.forName(mrsidJP2);
            String imageioJ2KImageReaderCodecName = J2KImageReaderCodecLibSpi.class.getName();
            if (PackageUtil.isCodecLibAvailable() && !(succeeded2 = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)mrsidJP2, (String)imageioJ2KImageReaderCodecName, (String)"JPEG 2000"))) {
                LOGGER.warning("Unable to set ordering between jp2 readers spi-" + mrsidJP2 + ":" + imageioJ2KImageReaderCodecName);
            }
            if (!(succeeded = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)mrsidJP2, (String)(imageioJ2KImageReaderName = J2KImageReaderSpi.class.getName()), (String)"JPEG 2000"))) {
                LOGGER.warning("Unable to set ordering between jp2 readers spi-" + mrsidJP2 + ":" + imageioJ2KImageReaderName);
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Unable to load specific JPEG2000 reader spi", e);
        }
    }

    private static boolean JP2MRSID() {
        return new JP2MrSIDFormatFactory().isAvailable();
    }

    private static void replaceECW() {
        try {
            String imageioJ2KImageReaderName;
            boolean succeeded;
            boolean succeeded2;
            String ecwJP2 = JP2GDALEcwImageReaderSpi.class.getName();
            Class.forName(ecwJP2);
            String imageioJ2KImageReaderCodecName = J2KImageReaderCodecLibSpi.class.getName();
            if (PackageUtil.isCodecLibAvailable() && !(succeeded2 = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)ecwJP2, (String)imageioJ2KImageReaderCodecName, (String)"JPEG 2000"))) {
                LOGGER.warning("Unable to set ordering between jp2 readers spi-" + ecwJP2 + ":" + imageioJ2KImageReaderCodecName);
            }
            if (!(succeeded = ImageIOUtilities.replaceProvider(ImageReaderSpi.class, (String)ecwJP2, (String)(imageioJ2KImageReaderName = J2KImageReaderSpi.class.getName()), (String)"JPEG 2000"))) {
                LOGGER.warning("Unable to set ordering between jp2 readers spi-" + ecwJP2 + ":" + imageioJ2KImageReaderName);
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Unable to load specific JPEG2000 reader spi", e);
        }
    }

    private static boolean JP2ECW() {
        return new JP2ECWFormatFactory().isAvailable();
    }

    public ImageMosaicFormat createFormat() {
        return new ImageMosaicFormat();
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    static {
        ImageMosaicFormatFactory.replaceTIFF();
        if (ImageMosaicFormatFactory.JP2ECW()) {
            ImageMosaicFormatFactory.replaceECW();
        }
        if (ImageMosaicFormatFactory.JP2MRSID()) {
            ImageMosaicFormatFactory.replaceMRSID();
        }
        if (ImageMosaicFormatFactory.JP2GDALKAK()) {
            ImageMosaicFormatFactory.replaceGDALKAK();
        }
    }
}

