/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageReaderSpi;
import javax.swing.SwingUtilities;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.geotools.console.CommandLine;
import org.geotools.console.Option;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.image.WorldImageFormat;
import org.geotools.gce.imagemosaic.ImageMosaicUtils;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;

final class IndexBuilder
implements Runnable {
    static final Logger LOGGER = Logging.getLogger(IndexBuilder.class);
    private int numFiles;
    private List<ProcessingEventListener> notificationListeners = Collections.synchronizedList(new ArrayList());
    private boolean sendDelayedMessages = false;
    private volatile boolean stop = false;
    private ImageMosaicUtils.MosaicConfigurationBean mosaicConfiguration;
    private GeometryFactory geomFactory;
    private ShapefileDataStore store;
    private FeatureWriter<SimpleFeatureType, SimpleFeature> fw = null;
    private int numberOfProcessedFiles;
    private boolean mustConvertToRGB = false;
    private GeneralEnvelope globalEnvelope = null;
    private int fileIndex = 0;
    private ColorModel defaultCM = null;
    private CoordinateReferenceSystem defaultCRS = null;
    private byte[][] defaultPalette = null;
    private IndexBuilderConfiguration runConfiguration;

    public void run() {
        try {
            IOFileFilter finalFilter = this.createIndexingFilter();
            this.numFiles = 0;
            for (String indexingDirectory : this.runConfiguration.indexingDirectories) {
                File directoryToScan = new File(indexingDirectory);
                Collection files = FileUtils.listFiles((File)directoryToScan, (IOFileFilter)finalFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
                this.numFiles += files.size();
            }
            if (this.numFiles > 0) {
                this.indexingPreamble();
                for (String indexingDirectory : this.runConfiguration.indexingDirectories) {
                    MosaicDirectoryWalker walker = new MosaicDirectoryWalker(new File(indexingDirectory), (FileFilter)finalFilter);
                }
                this.indexingPostamble();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private IOFileFilter createIndexingFilter() {
        WildcardFileFilter specialWildCardFileFilter = new WildcardFileFilter(this.runConfiguration.wildcardString, IOCase.INSENSITIVE);
        IOFileFilter dirFilter = FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)HiddenFileFilter.VISIBLE);
        IOFileFilter fileFilter = ImageMosaicUtils.excludeFilters(FileFilterUtils.makeSVNAware((IOFileFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)specialWildCardFileFilter, (IOFileFilter)HiddenFileFilter.VISIBLE))), FileFilterUtils.suffixFileFilter((String)"shp"), FileFilterUtils.suffixFileFilter((String)"dbf"), FileFilterUtils.suffixFileFilter((String)"shx"), FileFilterUtils.suffixFileFilter((String)"prj"), FileFilterUtils.nameFileFilter((String)"error.txt"), FileFilterUtils.nameFileFilter((String)"error.txt.lck"), FileFilterUtils.suffixFileFilter((String)"properties"), FileFilterUtils.suffixFileFilter((String)"svn-base"));
        Set extensions = WorldImageFormat.getWorldExtension((String)"png");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"gif");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"jpg");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"tiff");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        extensions = WorldImageFormat.getWorldExtension((String)"bmp");
        for (String ext : extensions) {
            fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1))));
        }
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"sdw")));
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"aux")));
        fileFilter = FileFilterUtils.andFileFilter((IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"wld")));
        IOFileFilter finalFilter = FileFilterUtils.orFileFilter((IOFileFilter)dirFilter, (IOFileFilter)fileFilter);
        return finalFilter;
    }

    public IndexBuilder(IndexBuilderConfiguration configuration) {
        ImageMosaicUtils.ensureNonNull("runConfiguration", configuration);
        if (configuration.indexingDirectories == null || configuration.indexingDirectories.size() <= 0) {
            throw new IllegalArgumentException("Indexing directories are empty");
        }
        ArrayList<String> directories = new ArrayList<String>();
        for (String dir : configuration.indexingDirectories) {
            directories.add(ImageMosaicUtils.checkInputDirectory(dir));
        }
        configuration.indexingDirectories = directories;
        if (configuration.indexName == null || configuration.indexName.length() == 0) {
            throw new IllegalArgumentException("Index name cannot be empty");
        }
        if (configuration.rootMosaicDirectory == null || configuration.rootMosaicDirectory.length() == 0) {
            throw new IllegalArgumentException("RootMosaicDirectory name cannot be empty");
        }
        configuration.rootMosaicDirectory = ImageMosaicUtils.checkInputDirectory(configuration.rootMosaicDirectory);
        if (configuration.wildcardString == null || configuration.wildcardString.length() == 0) {
            throw new IllegalArgumentException("WildcardString name cannot be empty");
        }
        this.runConfiguration = new IndexBuilderConfiguration(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addProcessingEventListener(ProcessingEventListener listener) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.notificationListeners.add(listener);
        }
    }

    public void reset() {
        this.removeAllProcessingEventListeners();
        this.stop = false;
        this.closeShapefileObjects();
        this.globalEnvelope = null;
        this.defaultCM = null;
        this.defaultCRS = null;
        this.defaultPalette = null;
        this.fileIndex = 0;
        this.numberOfProcessedFiles = 0;
        this.runConfiguration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(Level level, String inMessage, double percentage) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, inMessage);
        }
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            String newLine = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder("Thread Name ");
            message.append(Thread.currentThread().getName()).append(newLine);
            message.append(this.getClass().toString()).append(newLine).append(inMessage);
            ProcessingEvent evt = new ProcessingEvent(this, message.toString(), percentage);
            ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
            eventLauncher.setEvent(evt, this.notificationListeners.toArray());
            this.sendEvent(eventLauncher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireException(Exception ex) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.fireException(ImageMosaicUtils.getMessageFromException(ex), -1.0, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireException(String string, double percentage, Exception ex) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            String newLine = System.getProperty("line.separator");
            StringBuilder message = new StringBuilder("Thread Name ");
            message.append(Thread.currentThread().getName()).append(newLine);
            message.append(this.getClass().toString()).append(newLine).append(string);
            ExceptionEvent evt = new ExceptionEvent(this, string, percentage, ex);
            ProgressEventDispatchThreadEventLauncher eventLauncher = new ProgressEventDispatchThreadEventLauncher();
            eventLauncher.setEvent(evt, this.notificationListeners.toArray());
            this.sendEvent(eventLauncher);
        }
    }

    public boolean getStop() {
        return this.stop;
    }

    public boolean isSendDelayedMessages() {
        return this.sendDelayedMessages;
    }

    public void setSendDelayedMessages(boolean sendDelayedMessages) {
        this.sendDelayedMessages = sendDelayedMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllProcessingEventListeners() {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.notificationListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessingEventListener(ProcessingEventListener listener) {
        List<ProcessingEventListener> list = this.notificationListeners;
        synchronized (list) {
            this.notificationListeners.remove(listener);
        }
    }

    private void sendEvent(ProgressEventDispatchThreadEventLauncher eventLauncher) {
        if (this.sendDelayedMessages) {
            SwingUtilities.invokeLater(eventLauncher);
        } else {
            eventLauncher.run();
        }
    }

    public void stop() {
        this.stop = true;
    }

    private void indexingPreamble() throws IOException {
        PrecisionModel precMod = new PrecisionModel(PrecisionModel.FLOATING);
        this.geomFactory = new GeometryFactory(precMod);
        try {
            this.store = new ShapefileDataStore(new File(this.runConfiguration.rootMosaicDirectory, this.runConfiguration.indexName + ".shp").toURI().toURL());
        }
        catch (MalformedURLException ex) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
            this.fireException(ex);
            return;
        }
        this.mosaicConfiguration = new ImageMosaicUtils.MosaicConfigurationBean();
    }

    private void indexingPostamble() throws IOException {
        this.closeShapefileObjects();
        if (this.numberOfProcessedFiles > 0) {
            this.mosaicConfiguration.setName(this.runConfiguration.indexName);
            this.mosaicConfiguration.setExpandToRGB(this.mustConvertToRGB);
            this.mosaicConfiguration.setAbsolutePath(this.runConfiguration.absolute);
            this.mosaicConfiguration.setLocationAttribute(this.runConfiguration.locationAttribute);
            this.mosaicConfiguration.setEnvelope2D(new Envelope2D((org.opengis.geometry.Envelope)this.globalEnvelope));
            this.createPropertiesFiles();
            this.fireEvent(Level.FINE, "Done!!!", 100.0);
        } else {
            this.fireEvent(Level.FINE, "Nothing to process!!!", 100.0);
        }
    }

    private void closeShapefileObjects() {
        try {
            if (this.fw != null) {
                this.fw.close();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        this.fw = null;
        try {
            if (this.store != null) {
                this.store.dispose();
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        this.store = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void createPropertiesFiles() {
        block18: {
            this.fireEvent(Level.INFO, "Creating final properties file ", 99.9);
            Properties properties = new Properties();
            properties.setProperty("AbsolutePath", Boolean.toString(this.mosaicConfiguration.isAbsolutePath()));
            properties.setProperty("LocationAttribute", this.mosaicConfiguration.getLocationAttribute());
            properties.setProperty("Envelope2D", Double.toString(this.globalEnvelope.getMinimum(0)) + "," + Double.toString(this.globalEnvelope.getMinimum(1)) + " " + Double.toString(this.globalEnvelope.getMaximum(0)) + "," + Double.toString(this.globalEnvelope.getMaximum(1)));
            int numberOfLevels = this.mosaicConfiguration.getLevelsNum();
            double[][] resolutionLevels = this.mosaicConfiguration.getLevels();
            properties.setProperty("LevelsNum", Integer.toString(numberOfLevels));
            StringBuilder levels = new StringBuilder();
            for (int k = 0; k < numberOfLevels; ++k) {
                levels.append(Double.toString(resolutionLevels[0][k])).append(",").append(Double.toString(resolutionLevels[1][k]));
                if (k >= numberOfLevels - 1) continue;
                levels.append(" ");
            }
            properties.setProperty("Levels", levels.toString());
            properties.setProperty("Name", this.runConfiguration.indexName);
            properties.setProperty("ExpandToRGB", Boolean.toString(this.mustConvertToRGB));
            OutputStream outStream = null;
            outStream = new BufferedOutputStream(new FileOutputStream(this.runConfiguration.rootMosaicDirectory + "/" + this.runConfiguration.indexName + ".properties"));
            properties.store(outStream, "-Automagically created-");
            Object var8_7 = null;
            try {
                if (outStream != null) {
                    outStream.close();
                }
                break block18;
            }
            catch (Throwable e2) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                }
                break block18;
            }
            {
                catch (FileNotFoundException e) {
                    this.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
                    Object var8_8 = null;
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                        break block18;
                    }
                    catch (Throwable e2) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                        }
                        break block18;
                    }
                }
                catch (IOException e) {
                    this.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
                    Object var8_9 = null;
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                        break block18;
                    }
                    catch (Throwable e2) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Object var8_10 = null;
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                    }
                    catch (Throwable e2) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block19;
                        LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                    }
                }
                throw throwable;
            }
        }
    }

    public void dispose() {
        this.reset();
    }

    static /* synthetic */ int access$808(IndexBuilder x0) {
        return x0.fileIndex++;
    }

    static /* synthetic */ void access$900(IndexBuilder x0, Exception x1) {
        x0.fireException(x1);
    }

    static /* synthetic */ ColorModel access$1302(IndexBuilder x0, ColorModel x1) {
        x0.defaultCM = x1;
        return x0.defaultCM;
    }

    static /* synthetic */ ColorModel access$1300(IndexBuilder x0) {
        return x0.defaultCM;
    }

    static /* synthetic */ byte[][] access$1402(IndexBuilder x0, byte[][] x1) {
        x0.defaultPalette = x1;
        return x1;
    }

    static /* synthetic */ byte[][] access$1400(IndexBuilder x0) {
        return x0.defaultPalette;
    }

    static /* synthetic */ CoordinateReferenceSystem access$1502(IndexBuilder x0, CoordinateReferenceSystem x1) {
        x0.defaultCRS = x1;
        return x0.defaultCRS;
    }

    static /* synthetic */ GeneralEnvelope access$1602(IndexBuilder x0, GeneralEnvelope x1) {
        x0.globalEnvelope = x1;
        return x0.globalEnvelope;
    }

    static /* synthetic */ ImageMosaicUtils.MosaicConfigurationBean access$1700(IndexBuilder x0) {
        return x0.mosaicConfiguration;
    }

    static /* synthetic */ ShapefileDataStore access$1900(IndexBuilder x0) {
        return x0.store;
    }

    static /* synthetic */ FeatureWriter access$2002(IndexBuilder x0, FeatureWriter x1) {
        x0.fw = x1;
        return x0.fw;
    }

    static /* synthetic */ GeneralEnvelope access$1600(IndexBuilder x0) {
        return x0.globalEnvelope;
    }

    static /* synthetic */ CoordinateReferenceSystem access$1500(IndexBuilder x0) {
        return x0.defaultCRS;
    }

    static /* synthetic */ FeatureWriter access$2000(IndexBuilder x0) {
        return x0.fw;
    }

    static /* synthetic */ GeometryFactory access$2100(IndexBuilder x0) {
        return x0.geomFactory;
    }

    static /* synthetic */ int access$1208(IndexBuilder x0) {
        return x0.numberOfProcessedFiles++;
    }

    final class MosaicDirectoryWalker
    extends DirectoryWalker {
        private ImageReaderSpi cachedSPI;
        private AbstractGridFormat cachedFormat;

        protected void handleCancelled(File startDirectory, Collection results, DirectoryWalker.CancelException cancel) throws IOException {
            IndexBuilder.this.closeShapefileObjects();
            super.handleCancelled(startDirectory, results, cancel);
        }

        protected boolean handleIsCancelled(File file, int depth, Collection results) throws IOException {
            return IndexBuilder.this.stop && super.handleIsCancelled(file, depth, results);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void handleFile(File fileBeingProcessed, int depth, Collection results) throws IOException {
            block97: {
                IndexBuilder.access$808(IndexBuilder.this);
                if (!this.checkFile(fileBeingProcessed)) {
                    return;
                }
                if (!this.checkStop()) {
                    return;
                }
                try {
                    validFileName = fileBeingProcessed.getCanonicalPath();
                    validFileName = FilenameUtils.normalize((String)validFileName);
                }
                catch (IOException e1) {
                    IndexBuilder.access$900(IndexBuilder.this, e1);
                    return;
                }
                validFileName = FilenameUtils.getName((String)validFileName);
                IndexBuilder.access$1100(IndexBuilder.this, Level.INFO, "Now indexing file " + validFileName, (double)IndexBuilder.access$800(IndexBuilder.this) * 100.0 / (double)IndexBuilder.access$1000(IndexBuilder.this));
                inStream = null;
                imageioReader = null;
                coverageReader = null;
                try {
                    block105: {
                        block106: {
                            block103: {
                                block104: {
                                    block102: {
                                        block101: {
                                            block100: {
                                                block99: {
                                                    block98: {
                                                        inStream = ImageIO.createImageInputStream(fileBeingProcessed);
                                                        if (inStream != null) break block98;
                                                        IndexBuilder.access$1100(IndexBuilder.this, Level.INFO, fileBeingProcessed + " has been skipped since we could not get a stream for it", (double)IndexBuilder.access$800(IndexBuilder.this) * 100.0 / (double)IndexBuilder.access$1000(IndexBuilder.this));
                                                        var18_9 = null;
                                                        ** GOTO lbl225
                                                    }
                                                    inStream.mark();
                                                    if (this.cachedSPI != null) break block99;
                                                    it = ImageIO.getImageReaders(inStream);
                                                    if (it.hasNext()) {
                                                        imageioReader = it.next();
                                                        if (imageioReader != null) {
                                                            this.cachedSPI = imageioReader.getOriginatingProvider();
                                                            imageioReader.setInput(inStream);
                                                        }
                                                        break block100;
                                                    } else {
                                                        imageioReader = null;
                                                    }
                                                    break block100;
                                                }
                                                if (!this.cachedSPI.canDecodeInput(inStream)) {
                                                    this.cachedSPI = null;
                                                } else {
                                                    imageioReader = this.cachedSPI.createReaderInstance();
                                                    imageioReader.setInput(inStream);
                                                }
                                            }
                                            if (imageioReader != null) break block101;
                                            IndexBuilder.access$1100(IndexBuilder.this, Level.INFO, "Skipped file " + fileBeingProcessed + ":No ImageIO readeres avalaible.", (double)IndexBuilder.access$800(IndexBuilder.this) * 99.0 / (double)IndexBuilder.access$1000(IndexBuilder.this));
                                            ** GOTO lbl249
                                        }
                                        format /* !! */  = this.cachedFormat == null ? GridFormatFinder.findFormat((Object)fileBeingProcessed) : (this.cachedFormat.accepts((Object)fileBeingProcessed) != false ? this.cachedFormat : new UnknownFormat());
                                        if (!(format /* !! */  instanceof UnknownFormat) && format /* !! */  != null) break block102;
                                        IndexBuilder.access$1100(IndexBuilder.this, Level.INFO, "Skipped file " + fileBeingProcessed + ": File format is not supported.", (double)IndexBuilder.access$800(IndexBuilder.this) * 99.0 / (double)IndexBuilder.access$1000(IndexBuilder.this));
                                        ** GOTO lbl274
                                    }
                                    this.cachedFormat = format /* !! */ ;
                                    coverageReader = format /* !! */ .getReader((Object)fileBeingProcessed);
                                    envelope = coverageReader.getOriginalEnvelope();
                                    actualCRS = coverageReader.getCrs();
                                    its = imageioReader.getImageTypes(0).next();
                                    if (IndexBuilder.access$1200(IndexBuilder.this) != 0) break block103;
                                    IndexBuilder.access$1302(IndexBuilder.this, its.getColorModel());
                                    if (IndexBuilder.access$1300(IndexBuilder.this) instanceof IndexColorModel) {
                                        icm = (IndexColorModel)IndexBuilder.access$1300(IndexBuilder.this);
                                        numBands = IndexBuilder.access$1300(IndexBuilder.this).getNumColorComponents();
                                        IndexBuilder.access$1402(IndexBuilder.this, new byte[3][icm.getMapSize()]);
                                        icm.getReds(IndexBuilder.access$1400(IndexBuilder.this)[0]);
                                        icm.getGreens(IndexBuilder.access$1400(IndexBuilder.this)[0]);
                                        icm.getBlues(IndexBuilder.access$1400(IndexBuilder.this)[0]);
                                        if (numBands == 4) {
                                            icm.getAlphas(IndexBuilder.access$1400(IndexBuilder.this)[0]);
                                        }
                                    }
                                    IndexBuilder.access$1502(IndexBuilder.this, actualCRS);
                                    IndexBuilder.access$1602(IndexBuilder.this, new GeneralEnvelope((org.opengis.geometry.Envelope)envelope));
                                    imageioReader.reset();
                                    try {
                                        inStream.reset();
                                    }
                                    catch (IOException e) {
                                        block76: {
                                            try {
                                                inStream.close();
                                            }
                                            catch (Throwable e1) {
                                                if (!IndexBuilder.LOGGER.isLoggable(Level.FINE)) break block76;
                                                IndexBuilder.LOGGER.log(Level.FINE, e1.getLocalizedMessage(), e1);
                                            }
                                        }
                                        inStream = ImageIO.createImageInputStream(fileBeingProcessed);
                                    }
                                    if (inStream != null) break block104;
                                    IndexBuilder.access$1100(IndexBuilder.this, Level.INFO, fileBeingProcessed + " has been skipped since we could not get a stream for it", (double)IndexBuilder.access$800(IndexBuilder.this) * 100.0 / (double)IndexBuilder.access$1000(IndexBuilder.this));
                                    ** GOTO lbl299
                                }
                                imageioReader.setInput(inStream);
                                numberOfLevels = imageioReader.getNumImages(true);
                                resolutionLevels = new double[2][numberOfLevels];
                                res = CoverageUtilities.getResolution((AffineTransform)((AffineTransform)coverageReader.getOriginalGridToWorld(PixelInCell.CELL_CORNER)));
                                resolutionLevels[0][0] = res[0];
                                resolutionLevels[1][0] = res[1];
                                if (numberOfLevels > 1) {
                                    for (k = 0; k < numberOfLevels; ++k) {
                                        resolutionLevels[0][k] = resolutionLevels[0][0] * (double)coverageReader.getOriginalGridRange().getSpan(0) / (1.0 * (double)imageioReader.getWidth(k));
                                        resolutionLevels[1][k] = resolutionLevels[1][0] * (double)coverageReader.getOriginalGridRange().getSpan(1) / (1.0 * (double)imageioReader.getHeight(k));
                                    }
                                }
                                IndexBuilder.access$1700(IndexBuilder.this).setLevelsNum(numberOfLevels);
                                IndexBuilder.access$1700(IndexBuilder.this).setLevels(resolutionLevels);
                                featureBuilder = new SimpleFeatureTypeBuilder();
                                featureBuilder.setName("mosaic_index");
                                featureBuilder.setNamespaceURI("http://www.geo-solutions.it/");
                                featureBuilder.add(IndexBuilder.access$1800(IndexBuilder.this).getLocationAttribute(), String.class);
                                featureBuilder.add("the_geom", Polygon.class, actualCRS);
                                featureBuilder.setDefaultGeometry("the_geom");
                                simpleFeatureType = featureBuilder.buildFeatureType();
                                IndexBuilder.access$1900(IndexBuilder.this).createSchema(simpleFeatureType);
                                IndexBuilder.access$2002(IndexBuilder.this, IndexBuilder.access$1900(IndexBuilder.this).getFeatureWriter(IndexBuilder.access$1900(IndexBuilder.this).getTypeNames()[0], Transaction.AUTO_COMMIT));
                                break block105;
                            }
                            IndexBuilder.access$1600(IndexBuilder.this).add((org.opengis.geometry.Envelope)envelope);
                            actualCM = its.getColorModel();
                            if (IndexBuilder.access$800(IndexBuilder.this) <= 0 || CRS.equalsIgnoreMetadata((Object)IndexBuilder.access$1500(IndexBuilder.this), (Object)actualCRS)) break block106;
                            IndexBuilder.access$1100(IndexBuilder.this, Level.INFO, "Skipping image " + fileBeingProcessed + " because CRSs do not match.", (double)(IndexBuilder.access$800(IndexBuilder.this) + 1) * 99.0 / (double)IndexBuilder.access$1000(IndexBuilder.this));
                            ** GOTO lbl324
                        }
                        if (!this.checkColorModels(IndexBuilder.access$1300(IndexBuilder.this), IndexBuilder.access$1400(IndexBuilder.this), actualCM)) break block105;
                        IndexBuilder.access$1100(IndexBuilder.this, Level.INFO, "Skipping image " + fileBeingProcessed + " because color models do not match.", (double)(IndexBuilder.access$800(IndexBuilder.this) + 1) * 99.0 / (double)IndexBuilder.access$1000(IndexBuilder.this));
                        ** GOTO lbl349
                    }
                    feature = (SimpleFeature)IndexBuilder.access$2000(IndexBuilder.this).next();
                    feature.setAttribute(1, (Object)IndexBuilder.access$2100(IndexBuilder.this).toGeometry((Envelope)new ReferencedEnvelope((org.opengis.geometry.Envelope)envelope)));
                    feature.setAttribute(0, (Object)this.prepareLocation(fileBeingProcessed));
                    IndexBuilder.access$2000(IndexBuilder.this).write();
                    IndexBuilder.access$1100(IndexBuilder.this, Level.FINE, "Done with file " + fileBeingProcessed, (double)(IndexBuilder.access$800(IndexBuilder.this) + 1) * 99.0 / (double)IndexBuilder.access$1000(IndexBuilder.this));
                    IndexBuilder.access$1208(IndexBuilder.this);
                    ** GOTO lbl374
                }
                catch (IOException e) {
                    block78: {
                        block77: {
                            IndexBuilder.access$900(IndexBuilder.this, e);
                            var18_16 = null;
                            try {
                                if (inStream != null) {
                                    inStream.close();
                                }
                            }
                            catch (Throwable e) {
                                if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block77;
                                IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                        try {
                            if (imageioReader != null) {
                                imageioReader.dispose();
                            }
                        }
                        catch (Throwable e) {
                            if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block78;
                            IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    try {
                        if (coverageReader == null) return;
                        coverageReader.dispose();
                        return;
                    }
                    catch (Throwable e) {
                        if (IndexBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                        IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    block80: {
                        block79: {
                            IndexBuilder.access$900(IndexBuilder.this, e);
                            var18_17 = null;
                            ** try [egrp 5[TRYBLOCK] [27 : 1455->1470)] { 
lbl175:
                            // 1 sources

                            if (inStream != null) {
                                inStream.close();
                            }
                            break block79;
lbl178:
                            // 1 sources

                            catch (Throwable e) {
                                if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block79;
                                IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                        ** try [egrp 6[TRYBLOCK] [28 : 1500->1513)] { 
lbl183:
                        // 1 sources

                        if (imageioReader != null) {
                            imageioReader.dispose();
                        }
                        break block80;
lbl186:
                        // 1 sources

                        catch (Throwable e) {
                            if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block80;
                            IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    ** try [egrp 7[TRYBLOCK] [29 : 1543->1556)] { 
lbl191:
                    // 1 sources

                    if (coverageReader == null) return;
                    coverageReader.dispose();
                    return;
lbl194:
                    // 1 sources

                    catch (Throwable e) {
                        if (IndexBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                        IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                    return;
                }
                {
                    block96: {
                        block95: {
                            block94: {
                                block93: {
                                    block92: {
                                        block91: {
                                            block90: {
                                                block89: {
                                                    block88: {
                                                        block87: {
                                                            block86: {
                                                                block85: {
                                                                    block84: {
                                                                        block83: {
                                                                            catch (Throwable var17_47) {
                                                                                block82: {
                                                                                    block81: {
                                                                                        var18_18 = null;
                                                                                        ** try [egrp 5[TRYBLOCK] [27 : 1455->1470)] { 
lbl202:
                                                                                        // 1 sources

                                                                                        if (inStream != null) {
                                                                                            inStream.close();
                                                                                        }
                                                                                        break block81;
lbl205:
                                                                                        // 1 sources

                                                                                        catch (Throwable e) {
                                                                                            if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block81;
                                                                                            IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                                        }
                                                                                    }
                                                                                    ** try [egrp 6[TRYBLOCK] [28 : 1500->1513)] { 
lbl210:
                                                                                    // 1 sources

                                                                                    if (imageioReader != null) {
                                                                                        imageioReader.dispose();
                                                                                    }
                                                                                    break block82;
lbl213:
                                                                                    // 1 sources

                                                                                    catch (Throwable e) {
                                                                                        if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block82;
                                                                                        IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                                    }
                                                                                }
                                                                                ** try [egrp 7[TRYBLOCK] [29 : 1543->1556)] { 
lbl218:
                                                                                // 1 sources

                                                                                if (coverageReader == null) throw var17_47;
                                                                                coverageReader.dispose();
                                                                                throw var17_47;
lbl221:
                                                                                // 1 sources

                                                                                catch (Throwable e) {
                                                                                    if (IndexBuilder.LOGGER.isLoggable(Level.FINEST) == false) throw var17_47;
                                                                                    IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                                }
                                                                                throw var17_47;
                                                                            }
lbl225:
                                                                            // 1 sources

                                                                            ** try [egrp 5[TRYBLOCK] [27 : 1455->1470)] { 
lbl226:
                                                                            // 1 sources

                                                                            if (inStream != null) {
                                                                                inStream.close();
                                                                            }
                                                                            break block83;
lbl229:
                                                                            // 1 sources

                                                                            catch (Throwable e) {
                                                                                if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block83;
                                                                                IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                            }
                                                                        }
                                                                        ** try [egrp 6[TRYBLOCK] [28 : 1500->1513)] { 
lbl234:
                                                                        // 1 sources

                                                                        if (imageioReader != null) {
                                                                            imageioReader.dispose();
                                                                        }
                                                                        break block84;
lbl237:
                                                                        // 1 sources

                                                                        catch (Throwable e) {
                                                                            if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block84;
                                                                            IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                        }
                                                                    }
                                                                    ** try [egrp 7[TRYBLOCK] [29 : 1543->1556)] { 
lbl242:
                                                                    // 1 sources

                                                                    if (coverageReader == null) return;
                                                                    coverageReader.dispose();
                                                                    return;
lbl245:
                                                                    // 1 sources

                                                                    catch (Throwable e) {
                                                                        if (IndexBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                                                        IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                    }
                                                                    return;
lbl249:
                                                                    // 1 sources

                                                                    var18_10 = null;
                                                                    ** try [egrp 5[TRYBLOCK] [27 : 1455->1470)] { 
lbl251:
                                                                    // 1 sources

                                                                    if (inStream != null) {
                                                                        inStream.close();
                                                                    }
                                                                    break block85;
lbl254:
                                                                    // 1 sources

                                                                    catch (Throwable e) {
                                                                        if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block85;
                                                                        IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                    }
                                                                }
                                                                ** try [egrp 6[TRYBLOCK] [28 : 1500->1513)] { 
lbl259:
                                                                // 1 sources

                                                                if (imageioReader != null) {
                                                                    imageioReader.dispose();
                                                                }
                                                                break block86;
lbl262:
                                                                // 1 sources

                                                                catch (Throwable e) {
                                                                    if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block86;
                                                                    IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                                }
                                                            }
                                                            ** try [egrp 7[TRYBLOCK] [29 : 1543->1556)] { 
lbl267:
                                                            // 1 sources

                                                            if (coverageReader == null) return;
                                                            coverageReader.dispose();
                                                            return;
lbl270:
                                                            // 1 sources

                                                            catch (Throwable e) {
                                                                if (IndexBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                                                IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                            }
                                                            return;
lbl274:
                                                            // 1 sources

                                                            var18_11 = null;
                                                            ** try [egrp 5[TRYBLOCK] [27 : 1455->1470)] { 
lbl276:
                                                            // 1 sources

                                                            if (inStream != null) {
                                                                inStream.close();
                                                            }
                                                            break block87;
lbl279:
                                                            // 1 sources

                                                            catch (Throwable e) {
                                                                if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block87;
                                                                IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                            }
                                                        }
                                                        ** try [egrp 6[TRYBLOCK] [28 : 1500->1513)] { 
lbl284:
                                                        // 1 sources

                                                        if (imageioReader != null) {
                                                            imageioReader.dispose();
                                                        }
                                                        break block88;
lbl287:
                                                        // 1 sources

                                                        catch (Throwable e) {
                                                            if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block88;
                                                            IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                        }
                                                    }
                                                    ** try [egrp 7[TRYBLOCK] [29 : 1543->1556)] { 
lbl292:
                                                    // 1 sources

                                                    if (coverageReader == null) return;
                                                    coverageReader.dispose();
                                                    return;
lbl295:
                                                    // 1 sources

                                                    catch (Throwable e) {
                                                        if (IndexBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                                        IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                    }
                                                    return;
lbl299:
                                                    // 1 sources

                                                    var18_12 = null;
                                                    ** try [egrp 5[TRYBLOCK] [27 : 1455->1470)] { 
lbl301:
                                                    // 1 sources

                                                    if (inStream != null) {
                                                        inStream.close();
                                                    }
                                                    break block89;
lbl304:
                                                    // 1 sources

                                                    catch (Throwable e) {
                                                        if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block89;
                                                        IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                    }
                                                }
                                                ** try [egrp 6[TRYBLOCK] [28 : 1500->1513)] { 
lbl309:
                                                // 1 sources

                                                if (imageioReader != null) {
                                                    imageioReader.dispose();
                                                }
                                                break block90;
lbl312:
                                                // 1 sources

                                                catch (Throwable e) {
                                                    if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block90;
                                                    IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                                }
                                            }
                                            ** try [egrp 7[TRYBLOCK] [29 : 1543->1556)] { 
lbl317:
                                            // 1 sources

                                            if (coverageReader == null) return;
                                            coverageReader.dispose();
                                            return;
lbl320:
                                            // 1 sources

                                            catch (Throwable e) {
                                                if (IndexBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                                IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                            }
                                            return;
lbl324:
                                            // 1 sources

                                            var18_13 = null;
                                            ** try [egrp 5[TRYBLOCK] [27 : 1455->1470)] { 
lbl326:
                                            // 1 sources

                                            if (inStream != null) {
                                                inStream.close();
                                            }
                                            break block91;
lbl329:
                                            // 1 sources

                                            catch (Throwable e) {
                                                if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block91;
                                                IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                            }
                                        }
                                        ** try [egrp 6[TRYBLOCK] [28 : 1500->1513)] { 
lbl334:
                                        // 1 sources

                                        if (imageioReader != null) {
                                            imageioReader.dispose();
                                        }
                                        break block92;
lbl337:
                                        // 1 sources

                                        catch (Throwable e) {
                                            if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block92;
                                            IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                        }
                                    }
                                    ** try [egrp 7[TRYBLOCK] [29 : 1543->1556)] { 
lbl342:
                                    // 1 sources

                                    if (coverageReader == null) return;
                                    coverageReader.dispose();
                                    return;
lbl345:
                                    // 1 sources

                                    catch (Throwable e) {
                                        if (IndexBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                        IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                    }
                                    return;
lbl349:
                                    // 1 sources

                                    var18_14 = null;
                                    ** try [egrp 5[TRYBLOCK] [27 : 1455->1470)] { 
lbl351:
                                    // 1 sources

                                    if (inStream != null) {
                                        inStream.close();
                                    }
                                    break block93;
lbl354:
                                    // 1 sources

                                    catch (Throwable e) {
                                        if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block93;
                                        IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                    }
                                }
                                ** try [egrp 6[TRYBLOCK] [28 : 1500->1513)] { 
lbl359:
                                // 1 sources

                                if (imageioReader != null) {
                                    imageioReader.dispose();
                                }
                                break block94;
lbl362:
                                // 1 sources

                                catch (Throwable e) {
                                    if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block94;
                                    IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                }
                            }
                            ** try [egrp 7[TRYBLOCK] [29 : 1543->1556)] { 
lbl367:
                            // 1 sources

                            if (coverageReader == null) return;
                            coverageReader.dispose();
                            return;
lbl370:
                            // 1 sources

                            catch (Throwable e) {
                                if (IndexBuilder.LOGGER.isLoggable(Level.FINEST) == false) return;
                                IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                            return;
lbl374:
                            // 1 sources

                            var18_15 = null;
                            ** try [egrp 5[TRYBLOCK] [27 : 1455->1470)] { 
lbl376:
                            // 1 sources

                            if (inStream != null) {
                                inStream.close();
                            }
                            break block95;
lbl379:
                            // 1 sources

                            catch (Throwable e) {
                                if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block95;
                                IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                        ** try [egrp 6[TRYBLOCK] [28 : 1500->1513)] { 
lbl384:
                        // 1 sources

                        if (imageioReader != null) {
                            imageioReader.dispose();
                        }
                        break block96;
lbl387:
                        // 1 sources

                        catch (Throwable e) {
                            if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block96;
                            IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    ** try [egrp 7[TRYBLOCK] [29 : 1543->1556)] { 
lbl392:
                    // 1 sources

                    if (coverageReader != null) {
                        coverageReader.dispose();
                    }
lbl396:
                    // 1 sources

                    catch (Throwable e) {}
                    if (!IndexBuilder.LOGGER.isLoggable(Level.FINEST)) break block97;
                    IndexBuilder.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
            super.handleFile(fileBeingProcessed, depth, results);
        }

        private String prepareLocation(File fileBeingProcessed) throws IOException {
            if (IndexBuilder.this.runConfiguration.absolute) {
                return fileBeingProcessed.getAbsolutePath();
            }
            String path = fileBeingProcessed.getCanonicalPath();
            path = path.substring(IndexBuilder.this.runConfiguration.rootMosaicDirectory.length());
            return path;
        }

        private boolean checkStop() {
            if (IndexBuilder.this.getStop()) {
                StringBuilder message = new StringBuilder("Stopping requested at file  ").append(IndexBuilder.this.fileIndex).append(" of ").append(IndexBuilder.this.numFiles).append(" files");
                IndexBuilder.this.fireEvent(Level.INFO, message.toString(), (double)IndexBuilder.this.fileIndex * 100.0 / (double)IndexBuilder.this.numFiles);
                return false;
            }
            return true;
        }

        private boolean checkFile(File fileBeingProcessed) {
            if (!(fileBeingProcessed.exists() && fileBeingProcessed.canRead() && fileBeingProcessed.isFile())) {
                StringBuilder message = new StringBuilder("Skipped file ").append(fileBeingProcessed).append(" snce it seems invalid.");
                IndexBuilder.this.fireEvent(Level.INFO, message.toString(), (double)IndexBuilder.this.fileIndex * 99.0 / (double)IndexBuilder.this.numFiles);
                return false;
            }
            return true;
        }

        public MosaicDirectoryWalker(File root, FileFilter filter) throws IOException {
            super(filter, Integer.MAX_VALUE);
            this.walk(root, null);
        }

        public int getNumberOfProcessedFiles() {
            return IndexBuilder.this.numberOfProcessedFiles;
        }

        private boolean checkColorModels(ColorModel defaultCM, byte[][] defaultPalette, ColorModel actualCM) {
            if (defaultCM instanceof ComponentColorModel && actualCM instanceof ComponentColorModel) {
                boolean colorSpaceIsOk;
                ComponentColorModel defCCM = (ComponentColorModel)defaultCM;
                ComponentColorModel actualCCM = (ComponentColorModel)actualCM;
                ColorSpace defCS = defCCM.getColorSpace();
                ColorSpace actualCS = actualCCM.getColorSpace();
                boolean isBogusDef = defCS instanceof BogusColorSpace;
                boolean isBogusActual = actualCS instanceof BogusColorSpace;
                if (isBogusDef && isBogusActual) {
                    BogusColorSpace def = (BogusColorSpace)defCS;
                    BogusColorSpace act = (BogusColorSpace)actualCS;
                    colorSpaceIsOk = def.getNumComponents() == act.getNumComponents() && def.isCS_sRGB() == act.isCS_sRGB() && def.getType() == act.getType();
                } else {
                    colorSpaceIsOk = defCS.equals(actualCS);
                }
                return defCCM.getNumColorComponents() != actualCCM.getNumColorComponents() || defCCM.hasAlpha() != actualCCM.hasAlpha() || !colorSpaceIsOk || defCCM.getTransparency() != actualCCM.getTransparency() || defCCM.getTransferType() != actualCCM.getTransferType();
            }
            if (defaultCM instanceof IndexColorModel && actualCM instanceof IndexColorModel) {
                IndexColorModel defICM = (IndexColorModel)defaultCM;
                IndexColorModel actualICM = (IndexColorModel)actualCM;
                if (defICM.getNumColorComponents() != actualICM.getNumColorComponents() || defICM.hasAlpha() != actualICM.hasAlpha() || !defICM.getColorSpace().equals(actualICM.getColorSpace()) || defICM.getTransferType() != actualICM.getTransferType()) {
                    return true;
                }
                if (defICM.getMapSize() != actualICM.getMapSize() || defICM.getTransparency() != actualICM.getTransparency() || defICM.getTransferType() != actualICM.getTransferType() || defICM.getTransparentPixel() != actualICM.getTransparentPixel()) {
                    IndexBuilder.this.mustConvertToRGB = true;
                    return false;
                }
                int numBands = actualICM.getNumColorComponents();
                byte[][] actualPalette = new byte[3][actualICM.getMapSize()];
                actualICM.getReds(actualPalette[0]);
                actualICM.getGreens(actualPalette[0]);
                actualICM.getBlues(actualPalette[0]);
                if (numBands == 4) {
                    actualICM.getAlphas(defaultPalette[0]);
                }
                block0: for (int i = 0; i < defICM.getMapSize(); ++i) {
                    for (int j = 0; j < numBands; ++j) {
                        if (actualPalette[j][i] == defaultPalette[j][i]) continue;
                        IndexBuilder.this.mustConvertToRGB = true;
                        continue block0;
                    }
                }
                return false;
            }
            return true;
        }
    }

    static final class ProgressEventDispatchThreadEventLauncher
    implements Runnable {
        private ProcessingEvent event;
        private Object[] listeners;

        ProgressEventDispatchThreadEventLauncher() {
        }

        synchronized void setEvent(ProcessingEvent evt, Object[] listeners) {
            if (listeners == null || evt == null) {
                throw new NullPointerException("Input argumentBuilder cannot be null");
            }
            this.listeners = listeners;
            this.event = evt;
        }

        public void run() {
            int numListeners = this.listeners.length;
            if (this.event instanceof ExceptionEvent) {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).exceptionOccurred((ExceptionEvent)this.event);
                }
            } else {
                for (int i = 0; i < numListeners; ++i) {
                    ((ProcessingEventListener)this.listeners[i]).getNotification(this.event);
                }
            }
        }
    }

    static final class ExceptionEvent
    extends ProcessingEvent {
        private static final long serialVersionUID = 2272452028229922551L;
        private Exception exception;

        public ExceptionEvent(Object source, String message, double percentage, Exception exception) {
            super(source, message, percentage);
            this.exception = exception;
        }

        public ExceptionEvent(Object source, Exception exception) {
            super(source, ImageMosaicUtils.getMessageFromException(exception), -1.0);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    static class ProcessingEvent
    extends EventObject {
        private static final long serialVersionUID = 6930580659705360225L;
        private String message = null;
        private double percentage = 0.0;

        public ProcessingEvent(Object source, String message, double percentage) {
            super(source);
            this.message = message;
            this.percentage = percentage;
        }

        public double getPercentage() {
            return this.percentage;
        }

        public String getMessage() {
            return this.message;
        }
    }

    static abstract class ProcessingEventListener
    implements EventListener {
        ProcessingEventListener() {
        }

        abstract void getNotification(ProcessingEvent var1);

        abstract void exceptionOccurred(ExceptionEvent var1);
    }

    static class CommandLineIndexBuilderRunner
    extends CommandLine {
        @Option(description="This index must use absolute or relative path", mandatory=false, name="absolute")
        private Boolean absolute;
        @Option(description="Directories where to look for file to index", mandatory=true, name="indexingDirectories")
        private String indexingDirectoriesString;
        @Option(description="Name to use for the index of this mosaic", mandatory=false, name="index")
        private String indexName;
        @Option(description="Root directory where to place the index file", mandatory=true, name="rootDirectory")
        private String rootMosaicDirectory;
        @Option(description="Wildcard to use for building the index of this mosaic", mandatory=false, name="wildcard")
        private String wildcardString = "*.*";
        @Option(description="Default location attribute for this index", mandatory=false, name="locationAttribute")
        private String locationAttribute = "location";

        public CommandLineIndexBuilderRunner(String[] args) {
            super(args);
            if (this.absolute == null) {
                this.absolute = false;
            }
            if (this.indexName == null) {
                this.indexName = "index";
            }
        }

        public static void main(String[] args) {
            CommandLineIndexBuilderRunner runner = new CommandLineIndexBuilderRunner(args);
            IndexBuilderConfiguration configuration = new IndexBuilderConfiguration();
            configuration.absolute = runner.absolute;
            configuration.indexName = runner.indexName;
            configuration.rootMosaicDirectory = runner.rootMosaicDirectory;
            configuration.wildcardString = runner.wildcardString;
            configuration.locationAttribute = runner.locationAttribute;
            String directories = runner.indexingDirectoriesString;
            String[] dirs_ = directories.split(",");
            ArrayList<String> dirs = new ArrayList<String>();
            for (String dir : dirs_) {
                dirs.add(dir);
            }
            configuration.indexingDirectories = dirs;
            IndexBuilder builder = new IndexBuilder(configuration);
            builder.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IndexBuilderConfiguration {
        private boolean absolute = false;
        private String indexName = "index";
        private String locationAttribute = "location";
        @Option(description="Root directory where to place the index file", mandatory=true, name="rootDirectory")
        private String rootMosaicDirectory;
        @Option(description="Wildcard to use for building the index of this mosaic", mandatory=false, name="wildcard")
        private String wildcardString = "*.*";
        private List<String> indexingDirectories;

        public IndexBuilderConfiguration() {
        }

        public IndexBuilderConfiguration(IndexBuilderConfiguration that) {
            this.absolute = that.absolute;
            this.indexingDirectories = new ArrayList<String>(that.indexingDirectories);
            this.indexName = that.indexName;
            this.locationAttribute = that.locationAttribute;
            this.rootMosaicDirectory = that.rootMosaicDirectory;
            this.wildcardString = that.wildcardString;
        }

        public void setIndexingDirectories(List<String> indexingDirectories) {
            this.indexingDirectories = indexingDirectories;
        }

        public List<String> getIndexingDirectories() {
            return this.indexingDirectories;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getLocationAttribute() {
            return this.locationAttribute;
        }

        public String getRootMosaicDirectory() {
            return this.rootMosaicDirectory;
        }

        public String getWildcardString() {
            return this.wildcardString;
        }

        public boolean isAbsolute() {
            return this.absolute;
        }

        public void setAbsolute(boolean absolute) {
            this.absolute = absolute;
        }

        public void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public void setLocationAttribute(String locationAttribute) {
            this.locationAttribute = locationAttribute;
        }

        public void setRootMosaicDirectory(String rootMosaicDirectory) {
            ImageMosaicUtils.ensureNonNull("rootMosaicDirectory", rootMosaicDirectory);
            String testingDirectory = rootMosaicDirectory;
            ImageMosaicUtils.checkInputDirectory(testingDirectory);
            this.rootMosaicDirectory = testingDirectory;
        }

        public void setWildcardString(String wildcardString) {
            this.wildcardString = wildcardString;
        }

        protected IndexBuilderConfiguration clone() throws CloneNotSupportedException {
            return new IndexBuilderConfiguration(this);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IndexBuilderConfiguration)) {
                return false;
            }
            IndexBuilderConfiguration that = (IndexBuilderConfiguration)obj;
            if (this.absolute != that.absolute) {
                return false;
            }
            if (!(this.indexName == null && that.indexName == null || this.indexName.equals(that.indexName))) {
                return false;
            }
            if (!(this.locationAttribute == null && that.locationAttribute == null || this.locationAttribute.equals(that.locationAttribute))) {
                return false;
            }
            if (!(this.rootMosaicDirectory == null && that.rootMosaicDirectory == null || this.rootMosaicDirectory.equals(that.rootMosaicDirectory))) {
                return false;
            }
            return Utilities.deepEquals(this.indexingDirectories, that.indexingDirectories);
        }

        public int hashCode() {
            int seed = 37;
            seed = Utilities.hash((boolean)this.absolute, (int)seed);
            seed = Utilities.hash((Object)this.locationAttribute, (int)seed);
            seed = Utilities.hash((Object)this.indexName, (int)seed);
            seed = Utilities.hash((Object)this.wildcardString, (int)seed);
            seed = Utilities.hash((Object)this.rootMosaicDirectory, (int)seed);
            seed = Utilities.hash(this.indexingDirectories, (int)seed);
            return seed;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("IndexBuilderConfiguration").append("\n");
            builder.append("wildcardString:\t\t\t").append(this.wildcardString).append("\n");
            builder.append("indexName:\t\t\t").append(this.indexName).append("\n");
            builder.append("absolute:\t\t\t").append(this.absolute).append("\n");
            builder.append("locationAttribute:\t\t\t").append(this.locationAttribute).append("\n");
            builder.append("rootMosaicDirectory:\t\t\t").append(this.rootMosaicDirectory).append("\n");
            builder.append("indexingDirectories:\t\t\t").append(Utilities.deepToString(this.indexingDirectories)).append("\n");
            return builder.toString();
        }
    }
}

