/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import org.geotools.jdbc.JDBCFeatureSourceTest;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class JDBCFeatureSourceExposePkTest
extends JDBCFeatureSourceTest {
    protected void setUp() throws Exception {
        super.setUp();
        ((JDBCFeatureStore)this.featureSource).setExposePrimaryKeyColumns(true);
    }

    public void testSchema() throws Exception {
        SimpleFeatureType schema = this.featureSource.getSchema();
        JDBCFeatureSourceExposePkTest.assertEquals((String)this.tname("ft1"), (String)schema.getTypeName());
        JDBCFeatureSourceExposePkTest.assertEquals((String)this.dataStore.getNamespaceURI(), (String)schema.getName().getNamespaceURI());
        JDBCFeatureSourceExposePkTest.assertTrue((boolean)this.areCRSEqual(CRS.decode((String)"EPSG:4326"), schema.getCoordinateReferenceSystem()));
        JDBCFeatureSourceExposePkTest.assertEquals((int)5, (int)schema.getAttributeCount());
        JDBCFeatureSourceExposePkTest.assertNotNull((Object)schema.getDescriptor(this.aname("id")));
        JDBCFeatureSourceExposePkTest.assertNotNull((Object)schema.getDescriptor(this.aname("geometry")));
        JDBCFeatureSourceExposePkTest.assertNotNull((Object)schema.getDescriptor(this.aname("intProperty")));
        JDBCFeatureSourceExposePkTest.assertNotNull((Object)schema.getDescriptor(this.aname("stringProperty")));
        JDBCFeatureSourceExposePkTest.assertNotNull((Object)schema.getDescriptor(this.aname("doubleProperty")));
    }
}

